;
; EMM501.ASM        v1.0
;
; Purpose:          Disable Clipper S'87->5.01a from using EMS
;                   in situations where the pageframe is not
;                   present or the EMM driver is disabled.
;
; Written by Malc.
;
; masm emm501 /ml;
; tasm emm501 /ml;
; optasm emm501 /ml;
;
;
;
.model large

public   __e_avail

.code

__e_avail proc      far
          push      bp
          mov       bp,sp
          push      ds
          push      si
          push      di
          mov       al,67h                      ; Int 67
          mov       ah,35h                      ; Get vector address function
          int       21h                         ; Get handler address
          mov       di,0ah                      ; Offset 10 in driver header
          push      cs                          ; Segment of string
          pop       ds                          ; Set up segment
          mov       si,offset cs:sig            ; Signature to match
          cld                                   ; Forwards
          mov       cx,4                        ; Number of words
          rep       cmpsw                       ; Compare them
          jnz       fail                        ; No match
          mov       ah,41h                      ; Get pageframe address
          int       67h                         ; Call driver
          or        ah,ah                       ; Was there an error
          jnz       fail                        ; Yes - no pageframe
          mov       ah,42h                      ; Get number of pages
          int       67h                         ; Call driver
          or        ah,ah                       ; Was there an error
          jnz       fail                        ; Yes, so no ems
          mov       al,10h                      ; Multiply by 16
          mul       bx                          ; Gives number of KB available
          jmp       short done                  ; All done
fail:
          xor       ax,ax                       ; Indicate no ems available
done:
          pop       di
          pop       si
          pop       ds
          pop       bp
          ret
__e_avail endp
sig       db        'EMMXXXX0'
          end

