// ---- 256 color converter from 256 b&w gray scans -----------256scan.cpp

// -------------- Include files -------------------------------------

#include "stdio.h"
#include "alloc.h"
#include "graphics.h"
#include "dos.h"
#include "stdlib.h"
#include "mem.h"
#include "conio.h"
#include "io.h"

// ----------- Prototypes --------------------------------------

void zRPCXRead(void);          // read, decode R.PCX & dump as R.BIN
void zGPCXRead(void);          // read, decode G.PCX & dump as G.BIN
void zBPCXRead(void);          // read, decode B.PCX & dump as B.BIN
void zRGBBMPMake(void);        // read, combine and dump as RGB.BMP

// ----------- Typedefs and Structs -----------------------------------

typedef struct       // define 8-bit header
 {
 char manufacturer;
 char version;
 char encoding;
 char bits_per_pixel;
 int xmin,ymin;
 int xmax,ymax;
 int hres;
 int vres;
 char palette[48];
 char reserved;
 char color_planes;
 int bytes_per_line;
 int palette_type;
 char filler[58];
 } PCXHEAD;

 PCXHEAD Header;   // where the header lives

// ------------------ Global Variables ---------------------------------

char palette[768];           // where the palette lives
int width,depth;
int bytes,bits;
int b=0;
unsigned long Length = 0;

// ---------------------- Main Executive Program ---------------------
main()
  {
  printf("256 Gray-Scale to Color Conversion.\n");
  printf("Copyright 1993 by Mark Taylor, Highland, Illinois.\n");
  printf("\n");
  printf("Beginning conversion. \n");
  printf("Converting and dumping R.PCX. \n");
  zRPCXRead();              // Read R.PCX file
  printf("Converting and dumping G.PCX. \n");
  zGPCXRead();              // Read G.PCX file
  printf("Converting and dumping B.PCX. \n");
  zBPCXRead();              // Read B.PCX file
  printf("Creating 24 bit RGB.BMP output file. \n");
  zRGBBMPMake();            // Combine BIN files and make BMP file
  printf("Conversion completed. \n");
  exit(0);
  }

// ------ Read R.PCX ---------------------------------------------
void zRPCXRead(void)
{
FILE *fp;               // R.PCX
FILE *fp1;              // R.BIN
char *p;

// attempt to open R.PCX
if((fp=fopen("R.PCX","rb"))==NULL)
  {fprintf(stderr,"Can not find R.PCX.  Check subdirectory. \n");exit(1);}

// read in header
if(fread((char*)&Header,1,sizeof(PCXHEAD),fp) != sizeof(PCXHEAD))
  {fprintf(stderr,"Error reading the R.PCX header. \n");exit(1);}

// check that it's a picture
if(Header.manufacturer != 0x0a || Header.version != 5)
  {printf("The R.PCX is not a 256 color PCX file. \n");exit(1);}
if(Header.bits_per_pixel == 1) bits = Header.color_planes;
  else bits = Header.bits_per_pixel;
if(bits != 8)
  {fprintf(stderr,"The R.PCX has the wrong number of colors. \n");exit(1);}

// perform some housekeeping
width = (Header.xmax - Header.xmin) + 1;
depth = (Header.ymax - Header.ymin) + 1;
bytes = Header.bytes_per_line;

fp1=fopen("R.BIN","ab");

int i=0;
for(i=0; i<depth; i++)
  {
  int n=0,b,c;
  if ((p=(char *)malloc(bytes)) == NULL) {
    printf("Not enough memory for buffer.\n");exit(1);}
  {do
    { c=fgetc(fp) & 0xff;      // get a key byte
      if((c & 0xc0) == 0xc0)     // if it's a run of bytes
      { b=c & 0x3f;             // off the high bits
        c=fgetc(fp);          // get the run byte
        while(b--) {p[n++]=~c; fputc(c,fp1);}  // run the byte
       }
      else {fputc(c,fp1); p[n++]=~c;}
    }
  while (n < bytes);
  }
  free(p);
  }
fclose(fp);
fclose(fp1);
return;
}


// ------ Read G.PCX ---------------------------------------------
void zGPCXRead(void)
{
FILE *fp;               // R.PCX
FILE *fp1;              // R.BIN
char *p;

// attempt to open G.PCX
if((fp=fopen("G.PCX","rb"))==NULL)
  {fprintf(stderr,"Can not find G.PCX.  Check subdirectory. \n");exit(1);}

// read in header
if(fread((char*)&Header,1,sizeof(PCXHEAD),fp) != sizeof(PCXHEAD))
  {fprintf(stderr,"Error reading the G.PCX header. \n");exit(1);}

// check that it's a picture
if(Header.manufacturer != 0x0a || Header.version != 5)
  {printf("The G.PCX is not a 256 color PCX file. \n");exit(1);}
if(Header.bits_per_pixel == 1) bits = Header.color_planes;
  else bits = Header.bits_per_pixel;
if(bits != 8)
  {fprintf(stderr,"The G.PCX has the wrong number of colors. \n");exit(1);}

// perform some housekeeping
width = (Header.xmax - Header.xmin) + 1;
depth = (Header.ymax - Header.ymin) + 1;
bytes = Header.bytes_per_line;

fp1=fopen("G.BIN","ab");

int i=0;
for(i=0; i<depth; i++)
  {
  int n=0,b,c;
  if ((p=(char *)malloc(bytes)) == NULL) {
    printf("Not enough memory for buffer.\n");exit(1);}
  {do
    { c=fgetc(fp) & 0xff;      // get a key byte
      if((c & 0xc0) == 0xc0)     // if it's a run of bytes
      { b=c & 0x3f;             // off the high bits
        c=fgetc(fp);          // get the run byte
        while(b--) {p[n++]=~c; fputc(c,fp1);}  // run the byte
       }
      else {fputc(c,fp1); p[n++]=~c;}
    }
  while (n < bytes);
  }
  free(p);
  }
fclose(fp);
fclose(fp1);
return;
}

// ------ Read B.PCX ---------------------------------------------
void zBPCXRead(void)
{
FILE *fp;               // R.PCX
FILE *fp1;              // R.BIN
char *p;

// attempt to open B.PCX
if((fp=fopen("B.PCX","rb"))==NULL)
  {fprintf(stderr,"Can not find B.PCX.  Check subdirectory. \n");exit(1);}

// read in header
if(fread((char*)&Header,1,sizeof(PCXHEAD),fp) != sizeof(PCXHEAD))
  {fprintf(stderr,"Error reading the B.PCX header. \n");exit(1);}

// check that it's a picture
if(Header.manufacturer != 0x0a || Header.version != 5)
  {printf("The B.PCX is not a 256 color PCX file. \n");exit(1);}
if(Header.bits_per_pixel == 1) bits = Header.color_planes;
  else bits = Header.bits_per_pixel;
if(bits != 8)
  {fprintf(stderr,"The B.PCX has the wrong number of colors. \n");exit(1);}

// perform some housekeeping
width = (Header.xmax - Header.xmin) + 1;
depth = (Header.ymax - Header.ymin) + 1;
bytes = Header.bytes_per_line;

fp1=fopen("B.BIN","ab");

int i=0;
for(i=0; i<depth; i++)
  {
  int n=0,b,c;
  if ((p=(char *)malloc(bytes)) == NULL) {
    printf("Not enough memory for buffer.\n");exit(1);}

  {do
    { c=fgetc(fp) & 0xff;      // get a key byte
      if((c & 0xc0) == 0xc0)     // if it's a run of bytes
      { b=c & 0x3f;             // off the high bits
        c=fgetc(fp);          // get the run byte
        while(b--) {p[n++]=~c; fputc(c,fp1);}  // run the byte
       }
      else {fputc(c,fp1); p[n++]=~c;}
    }
  while (n < bytes);
  }
  free(p);
  }
fclose(fp);
fclose(fp1);

int Lwidth=width;
int Ldepth=depth;
((unsigned long)Length) = (((unsigned long)Lwidth) * ((unsigned long)Ldepth));
return;
}


// ---- Combine R.BIN/G.BIN/B.BIN to RGB.BMP --------------------------
void zRGBBMPMake(void)
{
FILE *fp1;        // R.BIN File
FILE *fp2;        // G.BIN File
FILE *fp3;        // B.BIN File
FILE *fp4;        // RGB.BMP File

char b;          // byte

typedef struct {
        char id[2];
        long FileSize;
        int Reserved[2];
        long HeaderSize;
        long InfoSize;
        long BMPWidth;
        long BMPDepth;
        int biPlanes;
        int Bits;
        long biCompression;
        long biSizeImage;
        long biXPelsPerMeter;
        long biYPelsPerMeter;
        long biClrUsed;
        long biClrImportant;
        }BMPHEAD;

BMPHEAD bmp;

if((fp1=fopen("R.BIN","rb")) == NULL)
  {fprintf(stderr,"Can not open R.BIN file. \n"); exit(1);}

if((fp2=fopen("G.BIN","rb")) == NULL)
  {fprintf(stderr,"Can not open G.BIN file. \n"); exit(1);}

if((fp3=fopen("B.BIN","rb")) == NULL)
  {fprintf(stderr,"Can not open B.BIN file. \n"); exit(1);}

if((fp4=fopen("RGB.BMP","ab")) == NULL)
  {fprintf(stderr,"Can not open RGB.BMP file. \n"); exit(1);}

// write the header to RGB.BMP
memset((char *)&bmp,0,sizeof(BMPHEAD));
memcpy(bmp.id,"BM",2);
bmp.InfoSize=0x28L;
bmp.HeaderSize=54L;
bmp.BMPWidth=(long)width;
bmp.BMPDepth=(long)depth;
bmp.biPlanes=1;
bmp.Bits=24;
bmp.biCompression=0L;
bmp.FileSize=(long)((width*depth*3)+54L);
bmp.biSizeImage=(long)(width*depth*3);
bmp.biClrUsed=0L;
bmp.biClrImportant=0L;
bmp.biXPelsPerMeter=0L;
bmp.biYPelsPerMeter=0L;

fwrite((char *)&bmp,1,sizeof(BMPHEAD),fp4);



unsigned long r=0;
for(r=0; r<(Length+depth); ++r)
  {
   b=fgetc(fp1);
   fputc(b,fp4);

   b=fgetc(fp2);
   fputc(b,fp4);

   b=fgetc(fp3);
   fputc(b,fp4);
  }

fclose(fp1);
fclose(fp2);
fclose(fp3);
fclose(fp4);
return;
}
