// USERINFO (1.3) will get all the good bindery info about a user.
// It will tell the users full name, groups,
// and security equivalences. (If possible)
// Wild cards (*,?) accepted.
//
// If the user is logged in, it tells connection num,
// network number, node number, login date & time
//
// By:		Douglas R. Cannon
// On:		6/11/1992
// email:  	dougc@bert.cs.byu.edu
//


#include <iostream.h>
#include <dos.h>
#include <conio.h>
#include "obs.h"


#define WILD 0xFF
#define MAX_GROUPS 30


struct {
  nw_long id;
  char name[48];
  char full_name[48];
  int num_groups;
  char groups[MAX_GROUPS][48];

  int num_security;
  struct {
    char object[48];
    nw_int type;
  } security[MAX_GROUPS];

} user;


nw_int user_type,user_group;
nw_long last_id;

void help();
int find_user(char *);
void get_info();
void print_info();
void print_id(unsigned char);
void print_connections(connections *);



void main(int argc, char *argv[])
{
  char c,temp[48],cmd[80];
  short continuous = 0,done=0,n=1,cm=2;

  if ((argc < 2) || (argc > 3)) help();

  if (argc == 3) {

    if (argv[1][0] == '/') {
      cm = 1;
      n = 2;
    }

    strcpy(cmd,argv[cm]);
    strupr(cmd);
    if (strcmp(cmd,"/C"))  help();
    else continuous = 1;

  }


  if ((argc == 2) || ((continuous) && (argc == 3))) {

    cout << "\n----------------------------------------\n";

    user_type.high_byte = 0x00;
    user_type.low_byte = 0x01;
    user_group.high_byte = 0x00;
    user_group.low_byte = 0x02;

    strcpy(temp,argv[n]);
    strupr(temp);

    last_id.highest_byte = WILD;
    last_id.higher_byte = WILD;
    last_id.lower_byte = WILD;
    last_id.lowest_byte = WILD;

    if (find_user(temp))
      cout << "\nUser: " << temp << " not found.\n";

    else do {

      get_info();
      cout << "----------------------------------------\n";
      done = find_user(temp);
      if (!done) {
	if (!continuous) {
	  cout << "More... press a key, or press 'C' for continuous.";
	  c = toupper(getch());
	  cout << '\r';
	  clreol();
	  if (c=='C') continuous = 1;
	  if (c=='Q') done = 1;
	}
      }

    } while (!done);


  }

}



void help()
{
  cout << "\n\n"
	   << "UserInfo (ver 1.3)\n"
	   << "By: Douglas R. Cannon (dougc@bert.cs.byu.edu)\n\n"
       << "Usage: UserInfo <user_name> </C (optional) for Continuous.>\n\n";

}




// find_user will look for a user.
// The nw_long last_id it uses is a global var.
// It must previously be set to WILD, or set to
// the last user found.  This enables wild card searches.
// if it finds one, it puts the name in user.name
// and the object_id in user.id, and sets last_id to
// the object_id.  Then it returns a 0
//
// if it can't find the user, it returns a 1

int find_user(char *name)
{
  int al;

  has_props buf;

  al = scan_for_object(last_id,name,user_type,&buf);

  if ((!al) && (buf.object_type.low_byte == user_type.low_byte)) {
    user.id = buf.object_id;
    strcpy(user.name,buf.object_name);

    last_id = buf.object_id;

    return 0;
  }

  else return 1;

}





// get_info gets the user's full name, groups, and security
// equivalences of the user (if the user running UserInfo is
// privilaged).
// get_info will then call print_info to print the info, then
// check to see if the user is logged in.  If yes, call
// print_connections to print login info.

void get_info()
{
  int x,err;
  nw_long zero,id;
  byte val[128];

  zero.highest_byte = 0x00;
  zero.higher_byte = 0x00;
  zero.lower_byte = 0x00;
  zero.lowest_byte = 0x00;

  err = read_property_value(user.name,user_type,1,"IDENTIFICATION",val);
  if (!err) strcpy(user.full_name,val);
  else user.full_name[0]=NULL;

  read_property_value(user.name,user_type,1,"GROUPS_I'M_IN",val);
  x=0;
  user.num_groups=0;
  do {

    id.highest_byte = val[x++];
    id.higher_byte = val[x++];
    id.lower_byte = val[x++];
    id.lowest_byte = val[x++];

    if (!nw_long_equal(id,zero)) {
      object_name temp;
      get_object_name(id,&temp);
      strcpy(user.groups[user.num_groups++],temp.object_name);
    }

  } while (!nw_long_equal(id,zero));

  user.num_security=0;
  if (!read_property_value(user.name,user_type,1,"SECURITY_EQUALS",val)) {
    x=0;
    do {

      id.highest_byte = val[x++];
      id.higher_byte = val[x++];
      id.lower_byte = val[x++];
      id.lowest_byte = val[x++];

      if (!nw_long_equal(id,zero)) {
	object_name temp;
	get_object_name(id,&temp);
	strcpy(user.security[user.num_security].object,temp.object_name);
	user.security[user.num_security++].type = temp.object_type;
      }

    } while (!nw_long_equal(id,zero));

  }

  print_info();

  connections cons;
  get_connection_numbers(user_type,user.name,&cons);
  if (cons.number_of_connections) print_connections(&cons);


}





// print_info prints all the info we just found about the
// user excluding any connection or login info.

void print_info()
{
  int x;

  cout << "Username:  " << user.name;

  printf("   (");
  print_id(user.id.highest_byte);
  print_id(user.id.higher_byte);
  print_id(user.id.lower_byte);
  print_id(user.id.lowest_byte);
  printf(")");

  cout <<   "\nFull Name: " << user.full_name;


  for (x=0; x<user.num_groups; x++) {

    if (!x) cout << "\nGroups:    ";
    else    cout << "\n           ";

    cout << user.groups[x];
  }

  if (user.num_security) {

    for (x=0; x<user.num_security; x++) {

      if (!x) cout << "\nSecurity:  ";
      else    cout << "\n           ";

      cout << user.security[x].object << " ";

      if (user.security[x].type.low_byte == 0x01)
	cout << "User";
      else if (user.security[x].type.low_byte == 0x02)
	cout << "Group";
	   else cout << "Type not defined here";
    }
  }

  cout << "\n";
}


void print_id(unsigned char x)
{
  if (x < 0x10u) printf("0");
  printf("%X",x);
}


// print_connections prints all connection numbers of the
// user including network,node,and login date and time info.
// print_connections will make sure that get_internet_address
// does not return an error.  If it does, print_connections
// prints 'Unknown' for node and network numbers.

void print_connections(connections *cons)
{
  int x,y;
  address addr;
  object_info stuff;
  enum {YEAR,MONTH,DAY,HOUR,MINUTE,SECOND,DOW};

  cout << "\n" << user.name << " is currently logged in:\n\n";

  for (x=0; x<cons->number_of_connections; x++) {
    cout << "  ";
    if (cons->connection_numbers[x] < 100) cout << ' ';
    if (cons->connection_numbers[x] < 10) cout << ' ';
    printf("%d    ",cons->connection_numbers[x]);

    for (y=0; y<14; y++) {
      if (y>=strlen(user.name)) cout << ' ';
      else cout << user.name[y];
    }
    cout << "  ";

    if(!get_internet_address(cons->connection_numbers[x],&addr)) {

      for (y=0; y<4; y++) {
	if (addr.network_number[y] < 0x10) cout << '0';
	printf("%X",addr.network_number[y]);
      }

      cout << "  ";

      for (y=0; y<6; y++) {
	if (addr.node_address[y] < 0x10) cout << '0';
	printf("%X",addr.node_address[y]);
      }

    }

    else cout << " Unknown       Unknown";

    cout << "   ";

    get_connection_information(cons->connection_numbers[x],&stuff);

    y=1900+stuff.login_time[YEAR];
    if (stuff.login_time[MONTH] < 10) cout << ' ';
    if (stuff.login_time[DAY] < 10) cout << ' ';
    printf("%d-%d-%d",stuff.login_time[MONTH],stuff.login_time[DAY],y);

    if (stuff.login_time[HOUR] < 10) cout << ' ';
    printf("  %d:",stuff.login_time[HOUR]);
    if (stuff.login_time[MINUTE] <10) cout << '0';
    printf("%d\n",stuff.login_time[MINUTE]);

  }

}







