@echo off
rem -- process a single upload file - for ProDOOR 3.4
rem -- %1-logfile, %2-testfile, %3-comport, %4-conference number

rem -- determing file type and branch to proper test case
testfile %2 arc zip pak lzh zoo gif
if errorlevel == 98 goto end
if errorlevel == 6 goto gif
if errorlevel == 5 goto zoo
if errorlevel == 4 goto lzh
if errorlevel == 3 goto pak
if errorlevel == 2 goto zip
if errorlevel == 1 goto arc
goto end

rem -- Check GIF, trim off extra bytes if found, delete if invalid or
rem -- incomplete GIF file.  Insert resolution into ProDoor description.
rem -- Redirect output to comport (will not showup on local screen).
:gif
proecho %3 ~~Checking GIF file...~
giftest %2 /T /E > %3
goto end

rem -- test ARC files -- first convert them to ZIP files
:arc
proecho %3 ~~Converting ARC file %2 to ZIP format.  Please wait...~
chkpath tozip %0 >>%1
if errorlevel 1 goto end
tozip %2 >>%1

rem -- dsz's $door.log is no longer valid after conversion, delete it.
if exist %DSZLOG% del %DSZLOG%
goto zip


rem -- test ZIP files
:zip
ptest %2
proecho %3 ~~ChkAv 2.2 - Courtesy of The Bard's Lair (718) 381-3651~
proecho %3 ~Checking for -AV~
chkav %2
if errorlevel == 2 av
goto end

rem -- Found AV
:av
proecho %3 ~~Found -AV in file, sending mail to SysOp to revue file... ~
echo User has uploaded the file: > mail
echo %2 >> mail
echo which contains an -AV in it, please revue file. >> mail
txt2msg f:\pro\main\msgs -tSYSOP -fPROUTEST -sAV_File mail
del mail
goto end

rem -- test ZOO files
:zoo
chkpath zoo %0 >>%1
if errorlevel 1 goto end
zoo -test >>%1 %2
if errorlevel 1 echo %2 has errors! >>%1
goto end

rem -- test LZH files
:lzh
chkpath lharc %0 >>%1
if errorlevel 1 goto end
rem lharc 1.12 or later required for test function to work
lharc t /v >>%1 %2
if errorlevel 1 echo %2 has errors! >>%1
goto end

rem -- test PAK files
:pak
chkpath pak %0 >>%1
if errorlevel 1 goto end
pak t >>%1 %2
if errorlevel 1 echo %2 has errors! >>%1
goto end


:end
