

/*
This program does 3 things:
  - Function -m marks the size of the specified log file
  - Function -s scans any addition to the log file for the specified string.
     If found, error level 1 is returned; otherwise, 0 is returned.
  - Function -p prints out the new part of the log.
*/


#define ERRORLEVEL_SUCCESS       0
#define ERRORLEVEL_SCAN_FAILED   1
#define ERRORLEVEL_BAD_PARAMETER 2

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>
#include <conio.h>
#include <time.h>
#include <dos.h>  /* Dos-specific functions are used to get date/time. */

#include "common.h"
#include "modem.h"

FILE *log_file_to_check,*mark_holding_file;
char temp_string[128],
     mark_holding_filespec[]="logcheck.dat",
     log_file_spec[64];
long file_size_marked,file_size_current;


/*------------------------- Subroutines ------------------------------*/
void print_header()
{
printf("LOGCHECK 1.0          Alton Moore\n");
printf("                      Fidonet 1:397/5264 (NEC)\n");
printf("                      WWIVnet 1@1042\n");
}

void print_help_message()
{
printf("?Illegal number of arguments; command line syntax:     \n\n");
printf("    LOGCHECK [function] [argument]                     \n\n");
printf("If [function] is -m then [argument] should be the      \n");
printf("log file specification; the size of this file will be  \n");
printf("marked down and its name remembered.                   \n\n");
printf("If [function] is -s then [argument] should be the      \n");
printf("string to look for in the new piece of the log         \n");
printf("file which was previously specified (with -m).         \n\n");
printf("If [function] is -p then the new part of the previously\n");
printf("marked file is printed to the screen.  After that, the \n");
printf("program waits for [argument] seconds.                  \n\n");
printf("<Return> to continue: ");
gets(temp_string);
}

int mark_file_size(char file_name[])
{
mark_holding_file = fopen(mark_holding_filespec,"wb");
if (mark_holding_file == NULL)
	return(ERRORLEVEL_BAD_PARAMETER);
log_file_to_check = fopen(file_name,"rb");
if (log_file_to_check == NULL)             /* Log file gone? */
  {                                        /*  Write out 0 as the filesize. */
  strcpy(temp_string,file_name);
  strcat(temp_string,CRLF_string);
  fwrite(temp_string,strlen(temp_string),1,mark_holding_file);
  strcpy(temp_string,"0");
  strcat(temp_string,CRLF_string);
  fwrite(temp_string,strlen(temp_string),1,mark_holding_file);
  fclose(mark_holding_file);
  return(ERRORLEVEL_BAD_PARAMETER);
  }
fseek(log_file_to_check,0,SEEK_END);
file_size_marked = ftell(log_file_to_check);
fclose(log_file_to_check);
strcpy(temp_string,file_name);      /* Write the filespec as the 1st line. */
strcat(temp_string,CRLF_string);
fwrite(temp_string,strlen(temp_string),1,mark_holding_file);
ltoa(file_size_marked,temp_string,10);  /* Now write out current filesize. */
strcat(temp_string,CRLF_string);
fwrite(temp_string,strlen(temp_string),1,mark_holding_file);
fclose(mark_holding_file);
return(ERRORLEVEL_SUCCESS);
}

int scan_file_for_string(char string_to_scan_for[])
{
char the_char;
mark_holding_file = fopen(mark_holding_filespec,"rt");
if (mark_holding_file == NULL)
	return(ERRORLEVEL_BAD_PARAMETER);
fgets(log_file_spec,sizeof(log_file_spec),mark_holding_file);
log_file_spec[strlen(log_file_spec)-1] = 0;
fgets(temp_string,sizeof(temp_string),mark_holding_file);
temp_string[strlen(temp_string)-1] = 0;  /* Cut off LF. */
file_size_marked = atol(temp_string);
fclose(mark_holding_file);
log_file_to_check = fopen(log_file_spec,"rb");
if (log_file_to_check == NULL)
	return(ERRORLEVEL_BAD_PARAMETER);
fseek(log_file_to_check,0,SEEK_END);
file_size_current = ftell(log_file_to_check);
if (file_size_current <= file_size_marked)
	return(ERRORLEVEL_SCAN_FAILED);
fseek(log_file_to_check,file_size_marked,SEEK_SET);
trace_start(string_to_scan_for);
while (ftell(log_file_to_check) < file_size_current)
	{
	fread(&the_char,1,1,log_file_to_check);  /* Read 1 character. */
	trace_process_received_character(the_char);
	if (trace_fired(string_to_scan_for))
		{
		trace_stop(string_to_scan_for,0);
		fclose(log_file_to_check);
		return(ERRORLEVEL_SUCCESS);
    }
  /* Go read next character. */
  }
fclose(log_file_to_check);
return(ERRORLEVEL_SCAN_FAILED);
}

int print_new_part_of_file(char wait_argument[])
{
char the_char;
int wait_time;
mark_holding_file = fopen(mark_holding_filespec,"rt");
if (mark_holding_file == NULL)
  return(ERRORLEVEL_BAD_PARAMETER);
fgets(log_file_spec,sizeof(log_file_spec),mark_holding_file);
log_file_spec[strlen(log_file_spec)-1] = 0;
fgets(temp_string,sizeof(temp_string),mark_holding_file);
temp_string[strlen(temp_string)-1] = 0;  /* Cut off LF. */
file_size_marked = atol(temp_string);
fclose(mark_holding_file);
log_file_to_check = fopen(log_file_spec,"rb");
if (log_file_to_check == NULL)
  {
  printf("?Log file %s not found.\n");
  return(ERRORLEVEL_BAD_PARAMETER);
  }
fseek(log_file_to_check,0,SEEK_END);
file_size_current = ftell(log_file_to_check);
if (file_size_current <= file_size_marked)
  return(ERRORLEVEL_SCAN_FAILED);
fseek(log_file_to_check,file_size_marked,SEEK_SET);
while (ftell(log_file_to_check) < file_size_current)
  {
  fread(&the_char,1,1,log_file_to_check);  /* Read 1 character. */
  printf("%c",the_char);
  }
fclose(log_file_to_check);
wait_time = atoi(wait_argument);  /* How long to wait after showing log. */
if (wait_time)
  wait(wait_time);
return(ERRORLEVEL_SUCCESS);
}


/*--------------------------- The Code -------------------------------------*/
int main(int argc, char *argv[])
{

if (argc != 3)
  {
  print_help_message();
  return(ERRORLEVEL_BAD_PARAMETER);
  }
if (!strcmp(argv[1],"-m"))
  {
  print_header();
  return(mark_file_size(argv[2]));
  }
if (!strcmp(argv[1],"-s"))
  {
  print_header();
  return(scan_file_for_string(argv[2]));
  }
if (!strcmp(argv[1],"-p"))
  return(print_new_part_of_file(argv[2]));
return(ERRORLEVEL_BAD_PARAMETER);
}

