*:*********************************************************************
*:
*:        Program: LANTEST.PRG
*:
*:         System: Lantest Program
*:         Author: Thomas D. Stubbs / Jeff B. Davis
*:      Copyright (c) 1992 Davis Consulting
*:  Last modified: 06/21/92     12:44
*:
*:  Procs & Fncts: READ_IT
*:               : MKWINDOW()
*:               : FILLSCRN()
*:               : KLWINDOW()
*:               : MSG()
*:               : ERR_MSG()
*:               : GET_UNAVAI()
*:               : GET_AVAIL()
*:
*:          Calls: READ_IT          (procedure in LANTEST.PRG)
*:
*:*********************************************************************
SET SCOREBOARD OFF
SET Cursor OFF

SET COLOR TO N/W
@  0,0 CLEAR TO  0,79
@  0,1 SAY 'LanLib v'+libversion()+' (c) Copyright 1992 Davis Consulting'
SET COLOR TO W+/B

fillscrn(1,0,23,79,'')
SET COLOR TO N/W
@ 24,0 CLEAR TO 24,79
@ 24,1 SAY 'Enter=Select Option  ESC=Exit  F1=Help'

save screen to mainscrn

IF .NOT. isredir()
   err_msg("REDIR.EXE not Loaded")
   do exit
ENDIF

SET COLOR TO N/W
@  0,64 SAY 'Lantastic v'+lanversion()
SET COLOR TO W+/B
mvar = mkwindow(18,33,21,69)
  @ 19,35 SAY iif(isserver(),'     Server','Workstation')+' ID = '+wsid()
  @ 20,35 SAY '  Machine Name = '+machine()

server   = SPACE(16)
uname    = SPACE(16)
Password = SPACE(16)
mdevice  = SPACE(4)
servdvc  = SPACE(16)

test_op=1

mvar = mkwindow(2, 2, 12, 37, 'D','Main Fuctions')

DO WHILE .T.
   @  5, 3 PROMPT " Network Disk Drives and Printers "
   @  6, 3 PROMPT " Print Queue Management           "
   @  7, 3 PROMPT " Mail Services                    "
   @  8, 3 PROMPT " Send a Message to another User   "
   @  9, 3 PROMPT " Login or Logout                  "
   @ 10, 3 PROMPT " User Account Management          "
   @ 11, 3 PROMPT " Display Server Activity          "
   MENU TO test_op
   
   DO CASE
   CASE test_op=1
      ret_val = Get_Dev()
      IF ret_val#0
         err_msg(lanerr(ret_val))
      ENDIF
      
   CASE test_op=2
      do Queue_mgr 
      
      
   CASE test_op=3
      do Mail_mgr 
      
   CASE test_op=4
      server= get_server()
      uname = get_user(server)
      message = get_msg()
      ret_val = sendmsg(trim(message),trim(server),'',trim(uname))
      IF ret_val=0
         msg("Message sent")
      ELSE
         err_msg(lanerr(ret_val))
      ENDIF
      
   CASE test_op=5
      Get_server()
      
   CASE test_op=6
      do account
      
   CASE test_op=7
      do activity
      
   CASE test_op=0
      do exit
      
   ENDCASE
ENDDO

*!*********************************************************************
*!
*!      Procedure: READ_IT
*!
*!      Called by: LANTEST.PRG    
*!
*!*********************************************************************
PROCEDURE read_it

SET Cursor ON
READ
CLEAR GETS
SET Cursor OFF

RETURN

*!*********************************************************************
*!
*!       Function: MKWINDOW()
*!
*!*********************************************************************
FUNCTION mkwindow
PARAM w_urow,w_ucol,w_lrow,w_lcol,w_boxtyp,w_title

if PCOUNT()<6
   w_title=''
endif

if PCOUNT()<5
   w_boxtyp='S'
endif

w_retval = savescreen(w_urow,w_ucol,w_lrow+1,w_lcol+2)
w_retval = CHR(w_urow)+CHR(w_ucol)+CHR(w_lrow+1)+CHR(w_lcol+2)+w_retval
windshdw(w_urow+1,w_ucol+2,w_lrow+1,w_lcol+2,iif(iscolor(),1,7))
@ w_urow,w_ucol CLEAR TO w_lrow,w_lcol
if w_boxtyp='D'
   @ w_urow,w_ucol TO w_lrow,w_lcol double
else
   @ w_urow,w_ucol TO w_lrow,w_lcol 
endif
if len(w_title)#0
   w_dchars = '͹'
   w_schars = 'Ĵ'
   @ w_urow+2,w_ucol say left(w_&w_boxtyp.chars,1)+replicate(substr(w_&w_boxtyp.chars,2,1),w_lcol-w_ucol-1)+right(w_&w_boxtyp.chars,1)
   @ w_urow+1,w_ucol+(w_lcol-w_ucol-len(w_title))/2 say w_title
endif

RETURN(w_retval)

*!*********************************************************************
*!
*!       Function: FILLSCRN()
*!
*!*********************************************************************
FUNCTION fillscrn
PARAM f_urow,f_ucol,f_lrow,f_lcol,f_char
FOR I=f_urow TO f_lrow
   @ I,f_ucol SAY REPLICATE(f_char,f_lcol-f_ucol+1)
NEXT
RETURN(.T.)

*!*********************************************************************
*!
*!       Function: KLWINDOW()
*!
*!*********************************************************************
FUNCTION klwindow
PARAM k_str
k_urow = ASC(SUBSTR(k_str,1,1))
k_ucol = ASC(SUBSTR(k_str,2,1))
k_lrow = ASC(SUBSTR(k_str,3,1))
k_lcol = ASC(SUBSTR(k_str,4,1))
k_scrn = SUBSTR(k_str,5)
restscreen(k_urow,k_ucol,k_lrow,k_lcol,k_scrn)
RETURN(.T.)

*!*********************************************************************
*!
*!       Function: MSG()
*!
*!*********************************************************************
FUNCTION msg
PARAM m_msg,m_head
m_width = IIF(LEN(m_msg)>19,LEN(m_msg),19)
m_ucol  = IIF(INT((80-m_width)/2)>30,30,INT((80-m_width)/2))
m_scrn = mkwindow(19,m_ucol-2,22,m_ucol+m_width+2)
IF TYPE('m_head')='C'
   @ 19, 39-INT(LEN(m_head)/2)-2 SAY ' '+m_head+' '
ENDIF
@ 20,m_ucol SAY m_msg
@ 21,30 SAY '** Press any key **'
INKEY(0)
klwindow(m_scrn)
RETURN(.T.)

*!*********************************************************************
*!
*!       Function: ERR_MSG()
*!
*!*********************************************************************
FUNCTION err_msg
PARAM e_msg
e_color = setcolor('w+/r')
tone( 300, .5 )
tone( 800, .5 )
msg(e_msg,'ERROR')
setcolor(e_color)
RETURN(.T.)


Procedure Exit
   restore screen from mainscrn

   SET COLOR TO N/W
   MkWindow(  5,  7, 13, 73)
   @  6,28 say "Thank You for using the:"
   @  8,25 say "Lantastic Library for Clipper Demo"
   @  9,15 say "(c) '1992 Davis Consulting.  All rights reserved."
   @ 10,18 say "Written by Thomas D. Stubbs / Jeff B. Davis."
   @ 12,23 say "Mail your order for $99.00 today!"

   Tone( 300, .1 )

   Inkey(0)

   Set Color to
   Clear

   Set Color to n/w  
   @  0,  0
   @  0,  2 say "LanLib v"+libversion()+" (c)1992 Davis Consulting.   All rights reserved"

   Set Color to
   @  2,  0 Say ""

   Set Curs ON
   Close ALL   
   Clear ALL

   Quit     

Function Get_Server
server = ''
s_color = setcolor('w+/r')
scount1 = srvcount()
scount2 = logcount()
declare servers[scount1+scount2]
for i=1 to scount1
   servers[i]='\\'+srvname(i)
next
for i=1 to scount2
   servers[i+scount1]='('+trim(logname(i))+')'
next
serv = mkwindow(2, 2, iif(scount1+scount2>12,12,scount1+scount2+6), 37, 'D','Server Connections')
schoice = achoice(5,3,iif(scount1+scount2>12,12,scount1+scount2+5), 36,servers,.t.,"AUDF",1,1)
if schoice = 0
   klwindow(serv)
   setcolor(s_color)
   return(server)
endif
if left(servers[schoice],2)='\\'
  server = trim(substr(servers[schoice],3))
  if lastkey()=22
     uname = get_name()
     password = get_pass()
     if get_time()
        setwsdate(serverdate(server))
        setwstime(servertime(server))
     endif
     ret_val = login(server,uname,Password)
     IF ret_val#0
        err_msg(lanerr(ret_val))
     ENDIF
  endif
else 
  server = substr(servers[schoice],2,len(servers[schoice])-2)
  uname = get_name()
  password = get_pass()
  if get_time()
     setwsdate(serverdate(server))
     setwstime(servertime(server))
  endif
  ret_val = login(server,uname,Password)
  IF ret_val#0
     err_msg(lanerr(ret_val))
  ENDIF
endif

if lastkey()=7
   n_color = setcolor('n/bg')
   mvar = mkwindow(11,15,13,62,'D')
   @ 12,17 say 'Press ENTER to logout, ESC to cancel logout'
   mkey = 0
   do while mkey # 27 .and. mkey # 13
      mkey = inkey(0)
   enddo
   setcolor(n_color)
   klwindow(mvar)
   klwindow(serv)
   setcolor(s_color)
   if mkey=13
      ret_val = logout(server)
      IF ret_val#0
         err_msg(lanerr(ret_val))
      ENDIF
      return('')
   endif
   return(server)
endif

klwindow(serv)
setcolor(s_color)

return(server)

Function Get_Name
n_color = setcolor('w+/r')
mvar = mkwindow(9,16,13,38,'D','Enter your USERNAME')
uname=space(16)
@ 12,17 get uname picture '@!'
do read_it
klwindow(mvar)
setcolor(n_color)
Return(trim(uname))

Function Get_time
n_color = setcolor('w+/r')
mvar = mkwindow(9,16,13,62,'D',"Set your TIME and DATE using server's clock?")
ans = 1
@ 12,35 prompt  'YES'
@ 12,40 prompt  'NO '
menu to ans
klwindow(mvar)
setcolor(n_color)
Return(iif(ans=1,.t.,.f.))

Function Get_Pass
n_color = setcolor('w+/r')
mvar = mkwindow(9,16,13,38,'D','Enter your PASSWORD')
password=space(16)
@ 12,17 get password picture '@!'
do read_it
klwindow(mvar)
setcolor(n_color)
Return(trim(password))

Function Get_file
n_color = setcolor('w+/r')
mvar = mkwindow(9,6,13,72,'D','Enter pathname of file for queue copy.')
mfile=space(60)
@ 12,7 get mfile picture '@!'
do read_it
klwindow(mvar)
setcolor(n_color)
Return(trim(mfile))

Function Get_Msg 
n_color = setcolor('w+/r')
mvar = mkwindow(9,6,13,72,'D','Enter Message to send to user.')
mfile=space(60)
@ 12,7 get mfile picture '@!'
do read_it
klwindow(mvar)
setcolor(n_color)
Return(trim(mfile))

Function Get_User
param server
   max_users = usercount(server)
   declare lines[max_users]
   VCID=-1
   for i=1 to max_users
       IF VCID=UserVCID(server,i)
          ADEL(lines,i)
          max_users=max_users-1
          i=i-1
       ELSE
          lines[i]=left(username(trim(server),i)+space(16),16)
          VCID=UserVCID(server,i)
       ENDIF
   next
n_color = setcolor('w+/r')
mvar = mkwindow(9,16,13+max_users,38,'D','Select a User')
mchoice = achoice(12,17,12+max_users,37,lines)
uname=iif(mchoice=0,space(16),lines[mchoice])
klwindow(mvar)
setcolor(n_color)
Return(trim(uname))


Function Get_Dev
d_color = setcolor('w+/r')
declare devices[32]
devices[1]='PRN'
devices[2]='LPT1'
devices[3]='LPT2'
devices[4]='LPT3'
devices[5]='COM1'
devices[6]='COM2'

num_device=dvccount()
IF num_device>0
   DECLARE DEV[NUM_DEVICE]
   FOR X=1 TO num_device
      DEV[X]= dvcname(X)+dvcpath(X)
   NEXT
endif
for i=7 to 32
   devices[i]=chr(58+i)+':'
   if devices[i] $ 'A: B: C:'
      devices[i]=devices[i]+'       (Physical)'
   endif
   if num_device>0
      if ascan(dev,devices[i])#0
         devices[i]=devices[i]+'       '+substr(dev[ascan(dev,devices[i])],3)
      endif
   endif
next

dev = mkwindow(2, 2, 20, 37, 'D','Drive and Printer Connections')
do while .t.
choice = achoice(5,3,19,36,devices,.t.,"AUDF",1,1)
if choice = 0
   klwindow(dev)
   setcolor(d_color)
   return(0)
endif

if lastkey()=13 .and. .not. '\\' $ devices[choice]
   device = left(devices[choice],iif(choice<8,4,2))
   server = get_server()
   servdvc = get_device(server,device)
   ret_val = dvcuse(trim(server),trim(servdvc),device)
   devices[choice]=devices[choice]+'       \\'+trim(server)+'\'+servdvc
   IF ret_val#0
      err_msg(lanerr(ret_val))
   ENDIF
   loop
endif

if lastkey()=7
   n_color = setcolor('n/bg')
   mvar = mkwindow(11,11,13,69,'D')
   @ 12,13 say 'Press ENTER to delete resource, ESC to cancel deletion'
   mkey = 0
   do while mkey # 27 .and. mkey # 13
      mkey = inkey(0)
   enddo
   setcolor(n_color)
   klwindow(mvar)
   klwindow(dev)
   setcolor(d_color)
   if mkey=13
      return(dvcunuse(left(devices[choice],4)))
   else
      return(0)
   endif
endif
enddo



Function Get_Device
param server,mdrv

dvcuse(server,'',mdrv)
declare mvar[1]
dcount = adir(mdrv+"*.*",'','','','',mvar)
declare file[dcount],attrib[dcount]
adir(mdrv+"*.*",file,'','','',attrib)
dvcunuse(mdrv)

i=1
do while i<=dcount
  if file[i]='.' .or. file[i]='..' .or. file[i]='@MAIL' .or. (left(file[i],1)<>"@" .AND. 'H' $ attrib[i] )  
    adel(file,i)
    adel(attrib,i)
    dcount=dcount-1
  else
    file[i]=left(file[i]+space(16),16)+dvcprivs(SERVER,file[i])+'  '+dvcdescrip(server,file[i])
    i=i+1
  endif
enddo

o_color = setcolor('w+/r')
mvar = mkwindow(2, 9, iif(len(file)+6>13,13,len(file)+6), 72, 'D',' ')
@ 3, 10 say 'Device          Acces Rights  Description'
dvc = achoice(5,10,iif(len(file)+5>12,12,len(file)+5),71,file)
klwindow(mvar)
setcolor(o_color)
return(iif(dvc=0,'',trim(left(file[dvc],16))))


Function AUDF
Parameters Stat_Msg, Element, Rel_Pos

Do Case
   
   
   * IDLE
Case Stat_Msg = 0
   Return(  2 )
   
   * PAST TOP
Case Stat_Msg = 1
   Tone( 100, .1 )
   Return(  2 )
   
   * PAST END
Case Stat_Msg = 2
   Tone( 100, .1 )
   Return(  2 )
   
   * KEYSTROKE
Case Stat_Msg = 3
   
   aLastKey = LastKey()
   
   Do Case
      
   Case aLastKey = 27	&& ESC
      Return( 0 )
      
   Case aLastKey = 13	&& ENTER - Select 
      Return( 1 )
      
   Case aLastKey = 9 	&& Tab
         Return( 1 )
      
   Case aLastKey = 22 	&& Ins - Add    
         Return( 1 )
      
   Case aLastKey =  7 	&& Del - Delete    
         Return( 1 )
      
   Otherwise
      Return( 3 )
      
   EndCase
   
   * NONE SELECTABLE
Case Stat_Msg = 4
   Return(  0 )
   
EndCase


Procedure Account
a_color = setcolor('w+/r')
server = get_server()
acctm = mkwindow(2, 2, 8, 31, 'D','User Account Management')
do while .t.
   @ 5, 3 Prompt ' Change Password            '
   @ 6, 3 Prompt ' Disable Account            '
   @ 7, 3 Prompt ' Show Account Status        '
   menu to choice

   do case 
   
      case choice=0
         klwindow(acctm)
         setcolor(a_color)
         return
   
      case choice=1
         n_color = setcolor('w+/r')
         mvar = mkwindow(9,16,13,58,'D','Enter your old PASSWORD')
         opassword=space(16)
         @ 12,17 get opassword picture '@!'
         do read_it
         klwindow(mvar)
         setcolor(n_color)

         n_color = setcolor('w+/r')
         mvar = mkwindow(9,16,13,58,'D','Enter your new PASSWORD')
         npassword=space(16)
         @ 12,17 get npassword picture '@!'
         do read_it
         klwindow(mvar)
         setcolor(n_color)

         n_color = setcolor('w+/r')
         mvar = mkwindow(9,16,13,58,'D','Enter your new PASSWORD again to confirm')
         cpassword=space(16)
         @ 12,17 get cpassword picture '@!'
         do read_it
         klwindow(mvar)
         setcolor(n_color)

         if cpassword=npassword
            ret_val = ChgPasswrd(server,opassword,npassword)
            IF ret_val#0
               err_msg(lanerr(ret_val))
            ENDIF
         endif
   
      case choice=3
         acct=MkWindow(1,10,22,72,'D','User Account Status for '+username(server)+' on Server \\'+server)
         @  4, 11 say '              Description: '+Fullname(server)
         @  5, 11 say '      Date Last Logged In: '+iif(empty(lastlogin(server)),'none',dtoc(lastlogin(server)))
         @  6, 11 say '  Account Expiration Date: '+iif(empty(AcctExpire(server)),'none',dtoc(AcctExpire(server)))
         @  7, 11 say ' Password Expiration Date: '+iif(empty(PassExpire(server)),'none',dtoc(PassExpire(server)))
         @  8, 11 say '     Renew Password Every: '+str(PassExtend(server),3)+' Days '
         @  9, 11 say '               Privileges: '+iif(Bypassacl(server),'A','-')+iif(Bypassque(server),'Q','-')+iif(Bypassmail(server),'M','-')+iif(isAudit(server),'U','-')+iif(isManager(server),'S','-')
         @ 10, 11 say ' Number Concurrent Logins: '+str(maxlogins(server),3)
         @ 11, 11 say 'Time of day Allowed Logins: = Login Allowed =Not Allowed'
         @ 12, 22 say ' am Ŀ pm Ŀ'
         @ 13, 22 say '12  2   4   6   8   10  12  2   4   6   8   10  '
         @ 14, 10 say ''+replicate('',61)+''
         @ 15, 11 say '    Sunday'+GetAllowed(SERVER,1,'')
         @ 16, 11 say '    Monday'+GetAllowed(SERVER,2,'')
         @ 17, 11 say '   Tuesday'+GetAllowed(SERVER,3,'')
         @ 18, 11 say ' Wednesday'+GetAllowed(SERVER,4,'')
         @ 19, 11 say '  Thursday'+GetAllowed(SERVER,5,'')
         @ 20, 11 say '    Friday'+GetAllowed(SERVER,6,'')
         @ 21, 11 say '  Saturday'+GetAllowed(SERVER,7,'')
         inkey(0)
         klwindow(acct)
   endcase
enddo


Procedure Activity

declare command[52]
command[ 1] = 'LOGIN          '  && Log in to a server
command[ 2] = 'TERMINATE      '  && Process termination
command[ 3] = 'OPEN           '  && Open a file
command[ 4] = 'CLOSE          '  && Close a file
command[ 5] = 'CREATE         '  && Create a file if it is there or not
command[ 6] = 'NEW            '  && Create a new file that is not there
command[ 7] = 'UNIQUE         '  && Create a unique file
command[ 8] = 'COMMIT         '  && Commit disk data to disk
command[ 9] = 'FILE READ      '  && REad from file
command[10] = 'WRITE          '  && Write to file
command[11] = 'DELETE         '  && Delete file
command[12] = 'SET ATTR       '  && Set file attributes
command[13] = 'LOCK           '  && Lock byte range
command[14] = 'UNLOCK         '  && Unlock byte range
command[15] = 'CREATE DIR     '  && Create a subdirectory
command[16] = 'DELETE DIR     '  && Delete a subdirectory
command[17] = 'RENAME FILE    '  && Rename a file
command[18] = 'FIND FIRST FILE'  && Find first matching file
command[19] = 'FIND NEXT      '  && Find the next matching file
command[20] = 'DISK FREE      '  && Get disk free space
command[21] = 'GET QUEUE      '  && Get a queue entry
command[22] = 'SET QUEUE      '  && Set a queue entry
command[23] = 'CONTROL QUEUE  '  && Control the queue
command[24] = 'USER STATUS    '  && Return login information
command[25] = 'GET LINK       '  && Return link description
command[26] = 'SEEK           '  && Seek to a file position
command[27] = 'GET TIME       '  && Get server's time
command[28] = 'AUDIT          '  && Create audit entry
command[29] = 'MULTI OPEN     '  && Open file in a multitude of modes
command[30] = 'CHG PASSWORD   '  && Change a password
command[31] = 'DISABLE ACCOUNT'  && Disable account from further log ins
command[32] = 'COPY FILE      '  && Local server file copy
command[33] = 'GET USERNAME   '  && Get a username from account file
command[34] = 'TRANSLATE PATH '  && Translate a server's logical path
command[35] = 'CREATE INDIRECT'  && Make indirect file
command[36] = 'GET INDIRECT   '  && Get indirect file text
command[37] = 'PRINTER STATUS '  && Printer status obtained
command[38] = 'GET STREAM     '  && Get logical print stream information
command[39] = 'SET STREAM     '  && Set logical print stream information
command[40] = 'GET ACCOUNT    '  && Get an account record
command[41] = 'SHUTDOWN       '  && Request server shutdown
command[42] = 'CANCEL SHUTDOWN'  && Cancel server shutdown
command[43] = 'STUFF          '  && Stuff server's keyboard
command[44] = 'WRITE W COMMIT '  && Write then commit data to disk
command[45] = 'SET QUEUE EXTEN'  && Same as set_queue_entry except can specify spooled filename
command[46] = 'TERMINATE USER '  && Kick user off server
command[47] = 'CONTROL SERVER '  && Enable/disable logins, etc.
command[48] = 'FLUSH CACHE    '  && Flush server caches
command[49] = 'CHANGE USERNAME'  && Change username
command[50] = 'GET QUEUE EXTD '  && Same as get_queu_entry except can return named fields blanked
command[51] = 'LAST           '  && Last SNB message

a_color = setcolor('w+/r')
server = get_server()
acctm = mkwindow(2, 0, 21, 77, 'D','ID# Username         Machine         Command        IO Bytes Requests Privs')
do while .t.
   n_color = setcolor('n/bg')
   mvar = mkwindow(11,27,13,50,'D')
   @ 12,29 say 'Working. Please wait'
   setcolor(n_color)
   max_users = usercount(server)
   declare lines[max_users]
   VCID=-1
   for i=1 to max_users
       IF VCID=UserVCID(server,i)
          ADEL(lines,i)
          max_users=max_users-1
          i=i-1
       ELSE
          mprivs = iif(Bypassacl(server,i),'A','-')+iif(Bypassque(server,i),'Q','-')+iif(Bypassmail(server,i),'M','-')+iif(isAudit(server,i),'U','-')+iif(isManager(server,i),'S','-')+iif(UserStat(server,i)=1,'L','-')
          lines[i]=right('000'+ltrim(str(UserVCID(server,i),3)),3)+' '+left(username(trim(server),i)+space(16),16)+' '+Machine(server,i)+' '+command[UserCmdn(server,i)]+' '+str(UserIO(server,i),7)+'K '+str(UserReq(server,i),7)+' '+mprivs
          VCID=UserVCID(server,i)
       ENDIF
   next
   klwindow(mvar)
   mchoice = achoice(5,1,20,76,lines)
   if mchoice=0
      exit
   else
      loop
   endif
enddo
klwindow(acctm)
setcolor(a_color)
return


Procedure Queue_mgr

declare status[9]

Status[ 1] = 'EMPTY       '
Status[ 2] = 'UPDATING    '
Status[ 3] = 'HELD        '
Status[ 4] = 'WAITING     '
Status[ 5] = 'DESPOOLING  '
Status[ 6] = 'DELETING    '
Status[ 7] = 'ERROR SPOOL '
Status[ 8] = 'ERROR DEST  '
Status[ 9] = '*RUSH*      '

a_color = setcolor('w+/r')
server = get_server()
acctm = mkwindow(1, 1, 13, 77, 'D','Sequence # Destination       Status       User             Comment        ')
acct2 = mkwindow(15, 1, 22, 27, 'D','Logical Streams  Status ')
@ 18, 2 say '0: @???????.??? Enabled'
@ 19, 2 say '1:'
@ 20, 2 say '2:'
@ 21, 2 say '3:'
acct3 = mkwindow(15,30, 22, 77, 'D','Device  Status         CPS             Copies')
ptr = 1
do while .t.
   n_color = setcolor('n/bg')
   mvar = mkwindow(11,27,13,50,'D')
   @ 12,29 say 'Working. Please wait'
   setcolor(n_color)
   max_users = 0
   for i=1 to QeCount(server)
       if qetype(server,i)# 2  && mail
          max_users = max_users + 1
       endif
   next
   if max_users=0
      max_users=1
   endif
   declare lines[max_users]
   max_users = 0
   for i=1 to QeCount(server)
       if qetype(server,i)# 2  && mail
          max_users = max_users + 1
          lines[max_users]=right('000'+ltrim(str(Qesequence(server,i),3)),3)+'        '+left(QeDestiny(trim(server),i)+space(16),16)+' '+status[QeStatus(server,i)]+' '+qeuser(server,i)+' '+qecomment(server,i)
       endif
   next
   if max_users=0
      lines[1]=space(74)
   endif
   klwindow(mvar)
   mchoice = achoice(4,2,12,76,lines,.t.,"AUDF",ptr,1)
   if mchoice=0
      exit
   else
      if lastkey()=9
      declare state[4]
      state[1]='DISABLED     '
      state[2]='HALT AT EOJ  '
      state[3]='MULTIPLE JOBS'
      state[4]='PAUSED       '

      declare devs[6]
      devs[1]='ALL                                           '
      devs[2]='LPT1    '+state[prnstate(server,0)]+' '+iif(prnindex(server,0)<1,'(NOT DESPOOLING)',' '+left(ltrim(str(prncps(server,0),15))+space(15),15))+' '+iif(prnindex(server,0)<1,' ',ltrim(str(prncopies(server,0),7)))
      devs[3]='LPT2    '+state[prnstate(server,1)]+' '+iif(prnindex(server,1)<1,'(NOT DESPOOLING)',' '+left(ltrim(str(prncps(server,1),15))+space(15),15))+' '+iif(prnindex(server,1)<1,' ',ltrim(str(prncopies(server,1),7)))
      devs[4]='LPT3    '+state[prnstate(server,2)]+' '+iif(prnindex(server,2)<1,'(NOT DESPOOLING)',' '+left(ltrim(str(prncps(server,2),15))+space(15),15))+' '+iif(prnindex(server,2)<1,' ',ltrim(str(prncopies(server,2),7)))
      devs[5]='COM1    '+state[prnstate(server,3)]+' '+iif(prnindex(server,3)<1,'(NOT DESPOOLING)',' '+left(ltrim(str(prncps(server,3),15))+space(15),15))+' '+iif(prnindex(server,3)<1,' ',ltrim(str(prncopies(server,3),7)))
      devs[6]='COM2    '+state[prnstate(server,4)]+' '+iif(prnindex(server,4)<1,'(NOT DESPOOLING)',' '+left(ltrim(str(prncps(server,4),15))+space(15),15))+' '+iif(prnindex(server,4)<1,' ',ltrim(str(prncopies(server,4),7)))
      mchoice = achoice(18,31,21,76,devs,.t.,"AUDF",1,1)

      if mchoice=0
         loop
      endif

      acct=MkWindow(6,15,15,63,'D','Printer Control For '+left(devs[mchoice],3))
      @  9, 16 prompt 'Halt     Halt all despooling                   '
      @ 10, 16 prompt 'Stop     Stop despooling at end of current job '
      @ 11, 16 prompt 'Pause    Temporarily suspend despooler         '
      @ 12, 16 prompt 'One-Job  One job is to be despooled, then Stop '
      @ 13, 16 prompt 'Start    Begin despooler if paused or stopped  '
      @ 14, 16 prompt 'Restart  Spool current entry from beginning    '
      menu to qsel
      klwindow(acct)
      if qsel = 0
         loop
      endif
      do case 
         case qsel = 1
            ret_val = controlprn(server,mchoice-2,2)
            IF ret_val#0
               err_msg(lanerr(ret_val))
            ENDIF

         case qsel = 2
            ret_val = controlprn(server,mchoice-2,3)
            IF ret_val#0
               err_msg(lanerr(ret_val))
            ENDIF

         case qsel = 3
            ret_val = controlprn(server,mchoice-2,4)
            IF ret_val#0
               err_msg(lanerr(ret_val))
            ENDIF

         case qsel = 4
            ret_val = controlprn(server,mchoice-2,5)
            IF ret_val#0
               err_msg(lanerr(ret_val))
            ENDIF

         case qsel = 5
            ret_val = controlprn(server,mchoice-2,1)
            IF ret_val#0
               err_msg(lanerr(ret_val))
            ENDIF

         case qsel = 6
            ret_val = controlprn(server,mchoice-2,6)
            IF ret_val#0
               err_msg(lanerr(ret_val))
            ENDIF
      endcase
      loop
      endif
      ptr=mchoice
      acct=MkWindow(6,15,16,63,'D','Queue Control')
      @  9, 16 prompt 'Show    More information about selected entry  '
      @ 10, 16 prompt 'Delete  Remove selected entry from queue       '
      @ 11, 16 prompt 'Hold    Suspend despooling of selected entry   '
      @ 12, 16 prompt 'Release Allow selected entry to be despooled   '
      @ 13, 16 prompt 'View    View contents of selected entry        '
      @ 14, 16 prompt 'Copy    Copy selected entry to file            '
      @ 15, 16 prompt 'Rush    Gives queue entry top priority         '
      menu to qsel
      klwindow(acct)
      if qsel = 0
         loop
      endif
      do case 

      case qsel = 1
      acct=MkWindow(4,10,17,65,'D','Detailed Queue Entry')
      @  7, 11 say '        Sequence Number: '+right('000'+ltrim(str(Qesequence(server,mchoice),3)),3)  
      @  8, 11 say '                Comment: '+left(qecomment(server,mchoice),29)
      @  9, 11 say '                Sent By: '+qeuser(server,mchoice)
      @ 10, 11 say '                Machine: '+qemachine(server,mchoice)
      @ 11, 11 say '            Destination: '+qedestiny(server,mchoice)
      @ 12, 11 say '    Date & Time Spooled: '+dtoc(qedate(server,mchoice))+' '+qetime(server,mchoice)
      @ 13, 11 say '          Size in Bytes: '+ltrim(str(qesize(server,mchoice),8))
      @ 14, 11 say '                 Copies: '+ltrim(str(qecopies(server,mchoice),5))
      @ 15, 11 say '                 Status: '+status[QeStatus(server,mchoice)+1]
      @ 16, 11 say 'Delete after despooling? '+iif(QECOntrol(server,mchoice)=0,'Yes','No')
      inkey(0)
      klwindow(acct)

      case qsel = 2
         ret_val = controlque(server,qesequence(server,mchoice),1)
         IF ret_val#0
            err_msg(lanerr(ret_val))
         ENDIF

      case qsel = 3
         ret_val = controlque(server,qesequence(server,mchoice),2)
         IF ret_val#0
            err_msg(lanerr(ret_val))
         ENDIF

      case qsel = 4
         ret_val = controlque(server,qesequence(server,mchoice),3)
         IF ret_val#0
            err_msg(lanerr(ret_val))
         ENDIF

      case qsel = 5
         acct=MkWindow(2,1,22,77,'D','View Queue Entry')
         mvar = memoread(getlanpath(server)+'\'+qefile(server,mchoice))
         memoedit(mvar,5,2,21,76,.f.)
         klwindow(acct)

      case qsel = 6
         mfile = get_file()
         ret_val = lancopy(getlanpath(server)+'\'+qefile(server,mchoice),mfile)
         IF ret_val#0
            err_msg(lanerr(ret_val))
         ENDIF

      case qsel = 7
         ret_val = controlque(server,qesequence(server,mchoice),4)
         IF ret_val#0
            err_msg(lanerr(ret_val))
         ENDIF

      endcase
      loop
   endif
enddo
klwindow(acctm)
klwindow(acct2)
klwindow(acct3)
setcolor(a_color)
return

Procedure Mail_mgr
a_color = setcolor('w+/r')
server = get_server()
acctm = mkwindow( 1, 1, 11, 77, 'D','INcoming Mail         From                 Comment                        ')
acct2 = mkwindow(13, 1, 22, 77, 'D','OUTgoing Mail         To                   Comment                        ')
ptr = 1
do while .t.
   n_color = setcolor('n/bg')
   mvar = mkwindow(11,27,13,50,'D')
   @ 12,29 say 'Working. Please wait'
   setcolor(n_color)
   max_users = 0
   for i=1 to QeCount(server)
       if qetype(server,i)= 2  && mail
          max_users = max_users + 1
       endif
   next
   if max_users=0
      max_users=1
   endif
   declare lines[max_users]
   max_users = 0
   for i=1 to QeCount(server)
       if qetype(server,i)= 2  && mail
          max_users = max_users + 1
          lines[max_users]=dtoc(qedate(server,i))+'  '+qetime(server,i)+'       '+qeuser(server,i)+' '+qecomment(server,i)
       endif
   next
   if max_users=0
      lines[1]=space(74)
   endif
   klwindow(mvar)
   mchoice = achoice(4,2,12,76,lines,.t.,"AUDF",ptr,1)
   if mchoice=0
      exit
   endif 
enddo   
klwindow(acctm)
klwindow(acct2)
setcolor(a_color)

Return
