/*
 * WMAIL        MicroWalt Extended Mail Agent.
 *              This module handles sending messages to other users
 *              or even other systems.
 *
 * Author:      Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 *              Copyright 1988-1992 MicroWalt Corporation
 */
#include "wmail.h"


static _PROTOTYPE( int  deliver, (char *, DRAFT *)                      );
static _PROTOTYPE( int  do_skip, (DRAFT *, char *)                      );
static _PROTOTYPE( void do_alias, (DRAFT *, char *, char *)             );
static _PROTOTYPE( void do_rcpt, (DRAFT *, char *)                      );


/* Deliver a message to all its recipients, using program 'path'. */
static int deliver(prog, draft)
char *prog;
DRAFT *draft;
{
  char *args[NR_RCPT + 16];
  register int i, j;
#if (NEW_UMAIL == 0)
  int st = 0;
#endif

  /* Build the RMAIL calling sequence. */
  st = 0;i = 0; j = 0;
  args[i++] = prog;

#if NEW_MAILERS
  /* Now, add the vector list. */
  for (j = 0; j < NR_RCPT; j++) {
	if (draft->rcpts[j] != (char *)NULL) args[i++] = draft->rcpts[j];
  }
  args[i] = (char *)NULL;
  st = vexec(args[0], args, draft->tpath);
#else
  for (j = 0; j < NR_RCPT; j++) {
	if (draft->rcpts[j] != (char *)NULL) {
		args[i] = draft->rcpts[j];
		args[i + 1] = (char *)NULL;
		st |= vexec(args[0], args, draft->tpath);
	}
  }
#endif	/* NEW_MAILERS */
  return(st);
}


/* See if 'text' is already in 'rcpt[]'. */
static int do_skip(draft, text)
DRAFT *draft;
register char *text;
{
  register int i;

  for (i = 0; i < NR_RCPT; i++) {
	if (draft->rcpt[i] != (char *)NULL) {
		if (!strcmp(draft->rcpt[i], text)) return(1);
	}
  }
  return(0);
}


/*
 * This function gets a string, and a pointer to an array in which
 * strings can be put.  The goal is, to check the alias database to
 * see if the address contained in 'text' is a valid alias.  If so,
 * the alias text is in turn used as a new list of addresses. If not,
 * the address itself is used.
 * NOTE: this function does not yet understand about multi-level
 *       aliasing.  This will require some work for which I haven't
 *       got the time right now...
 */
static void do_alias(draft, text, field)
DRAFT *draft;
char *text;
char *field;
{
  register char *sp;
  register char *bp;
  char *fieldp;
  register int i;

  /* First of all, find a free spot in the table. */
  for (i = 0; i < NR_RCPT; i++) {
	if (draft->rcpt[i] == (char *)NULL) break;
  }

  /* Try finding an alias for this address. */
  if ((bp = rc_alias(text)) == (char *)NULL) bp = text;

  /* The resulting text _may_ also be a multi-address line. */
  if ((fieldp = strrchr(field, '\t')) == (char *)NULL) fieldp = field;
    else fieldp++;
  do {
	while (*bp == ' ' || *bp == '\t' || *bp == ',') bp++;
	if ((sp = strchr(bp, ',')) != (char *)NULL) *sp++ = '\0';
	  else if ((sp = strchr(bp, ' ')) != (char *)NULL) *sp++ = '\0';

	/* Should we skip this addressee? */
	if (do_skip(draft, bp) == 1) {
		if (opt_v == 1) fprintf(stderr,
			"alias: skipping duplicate addressee \"%s\"\n", bp);
		bp = sp;
		continue;
	}

	/* We found an address.  Does it fit? */
	if (i >= NR_RCPT) {
		fprintf(stderr, "alias: ignoring excess \"%s\"\n", bp);
		bp = sp;
		continue;
	}

	/* Yes. Allocate space for it. */
	if ((draft->rcpt[i] = (char *)malloc(strlen(bp) + 1)) == (char *)NULL) {
		fprintf(stderr, "alias: out of memory for \"%s\"\n", bp);
		bp = sp;
		continue;
	}
	strcpy(draft->rcpt[i++], bp);

	/* Update the header field, and watch its length! */
	if ((strlen(fieldp) + strlen(bp) + 2) > 70) {
		strcat(field, "\n\t");
		fieldp = strrchr(field, '\t') + 1;
	}
	strcat(field, bp);
	strcat(field, ", ");
	bp = sp;
  } while(bp != (char *)NULL);
}


/*
 * Take a complete header field, and expand all addresses into
 * the 'rcpts' array.  We make sure that this array only con-
 * tains dynamically allocated strings, so we can free the
 * entire array at a later time.
 */
static void do_rcpt(draft, text)
DRAFT *draft;
char *text;
{
  char buff[1024];
  register char *sp;
  register char *bp;

  if (*text == '\0') return;
  strcpy(buff, text);
  strcpy(text, "");
  bp = buff;
    do {
	while (*bp == ' ' || *bp == '\t') bp++;
	if ((sp = strchr(bp, ',')) != (char *)NULL) *sp++ = '\0';
	  else if ((sp = strchr(bp, ' ')) != (char *)NULL) *sp++ = '\0';

	do_alias(draft, bp, text);
	bp = sp;
  } while(bp != (char *)NULL);
  if ((sp = strrchr(text, ',')) != (char *)NULL) *sp = '\0';
}


/*
 * This is a rather tricky job, since the addresses may be aliases,
 * which may expand to multiple users in turn!
 * Return 1 if an error ocurred, otherwise return 0.
 */
int do_send(draft)
DRAFT *draft;
{
#if USE_LMAIL
  char *locals[NR_RCPT + 1];
  char *remotes[NR_RCPT + 1];
  register char *sp;
  register int l, r;
#endif
  register int i;
  int st;

  /* Clear the recipient tables. */
  for(i = 0; i <= NR_RCPT; i++) draft->rcpt[i] = (char *)NULL;

  /* Create the recipient list. */
  do_rcpt(draft, draft->to);
  do_rcpt(draft, draft->cc);
  do_rcpt(draft, draft->bcc);

  /*
   * All dirty work has been done.  We have expanded all possible
   * addresses, and the message header fields have been correctly
   * updated.  Create the message temporary file that we ultimately
   * hand over to the real mailer program.
   */
  (void) cp_draft(draft);

  /*
   * We now have a message which has to be delivered.
   * If we are allowed to use the local mailer, call it for all
   * recipients that have 'local' addresses, and call the remote
   * mailer for the remote recipients.  Otherwise, we will call
   * the remote mailer for _all_ of the work...
   */
  st = 0;
#if USE_LMAIL
  for (l = 0; l < NR_RCPT; l++) {
	locals[l] = (char *)NULL;
	remotes[l] = (char *)NULL;
  }
  l = 0; r = 0;
  for (i = 0; i < NR_RCPT; i++) {
	if (draft->rcpt[i] != (char *)NULL) {
		sp = draft->rcpt[i];
		if (strchr(sp, '@') || strchr(sp, '%') ||
		    strchr(sp, '!') || strchr(sp, ':')) remotes[r++] = sp;
		  else locals[l++] = sp;
	}
  }

  /* Now, deliver to all local recipients. */
  draft->rcpts = locals;
  l = deliver(LMAIL, draft);

  /* Deliver to all remote recipients. */
  draft->rcpts = remotes;
  r = deliver(RMAIL, draft);
  if ((l < 0) || (r < 0)) st = -1;
#else
  draft->rcpts = draft->rcpt;
  st = deliver(RMAIL, draft);
#endif
  
  /* The message has been delivered; clear all recipients. */
  for(i = 0; i < NR_RCPT; i++) {
	if (draft->rcpt[i] != (char *)NULL) free(draft->rcpt[i]);
  }

  /* Do we have to dump the letter? */
#if 0
  if (st != 0) dead_letter(draft);
#endif
  return(st);
}
