/*
 * W-MAIL       MicroWalt Extended Mail Agent.
 *              The W-MAIL program is an extended user-interface for sending
 *              and receiving mail on UNIX, MINIX, Coherent and MS-DOS systems.
 *
 * Usage:       wmail [-Qepqrv] [-f file]
 *              wmail [-Qbctv] [-i file] [-s subject] user ...
 *              lmail [-Qbclv] [-i file] user ...
 *              alias user ...
 *
 * Author:      Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 *		Copyright 1988-1992 MicroWalt Corporation
 */
#define GLOBAL
#include "wmail.h"
#include <sys/stat.h>
#ifdef MSDOS
#   include <io.h>
#   include <process.h>
#else
#   include <sys/wait.h>
#endif


#ifdef COH3
_PROTOTYPE( char *getenv, (char *varname)                                   );
#endif


static _PROTOTYPE( void var_init, (void)                                    );
static _PROTOTYPE( void usage, (void)                                       );


/* Create a decent time-string. Ctime(3) is lousy at this... */
char *xtime(timep)
time_t *timep;
{
  static char *months[] = {
        "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul",
        "Aug", "Sep", "Oct", "Nov", "Dec"
  };
  static char *days[] = {
        "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"
  };
  static char buff[30];
  struct tm *tim;

  tim = localtime(timep);

  /* Generate output in ASCII in xtmbuf. */
  sprintf(buff, "%s, %2.2d %s %2.2d %02d:%02d:%02d",
        days[tim->tm_wday], tim->tm_mday, months[tim->tm_mon],
            tim->tm_year, tim->tm_hour, tim->tm_min, tim->tm_sec);
/* FIXME:   ^^^^^^^^^^^^ ook onder DOS? */
  return(buff);
}


/* Execute another program as a child. */
int vexec(path, vec, ipath)
char *path;
char *vec[];
char *ipath;
{
  int st;
#if _UNIX
  int status, pid;

  if ((pid = fork()) == 0) {
	if (ipath != (char *)NULL) {
		(void) close(0);
		if (open(ipath, O_RDONLY) != 0) {
			fprintf(stderr, "%s: cannot setup as stdin!\n", ipath);
			exit(-errno);
		}
	}
        (void) umask(u_mask);
        st = execvp(path, vec);
        fprintf(stderr, "%s: Cannot execute!\n", path);
        exit(st);
  } else {
        if (pid > 0) {
                while (wait(&status) != pid)
                            ;
                st = WEXITSTATUS(status);
        } else {
                st = -errno;
                fprintf(stderr, "%s: cannot fork! (%d).\n", path, st);
        }
  }
#else
  int ofd;

  if (ipath != (char *)NULL) {
	ofd = dup(0);
	(void) close(0);
	if (open(ipath, O_RDONLY) != 0) {
		fprintf(stderr, "%s: cannot setup as stdin!\n", ipath);
		return(-errno);
	}
  }
  st = spawnvp(P_WAIT, path, vec);
  if (ipath != (char *)NULL) {
	(void) close(0);
	(void) dup(ofd);
	(void) close(ofd);
  }
#endif
  return(st);
}


/* Execute a shell (or a command only). */
int do_shell(command)
char *command;
{
  char *args[16];
  register int i;

  i = 0;
  args[i++] = rc_shell;
  if (*command != '\0') {
#ifdef MSDOS
        args[i++] = "/C";
#else
        args[i++] = "-c";
#endif
        args[i++] = command;
  }
  args[i] = (char *)NULL;

  i = vexec(rc_shell, args, (char *)NULL);
  return(i);
}


/* Initialize all variables. */
static void var_init()
{
#ifdef MSDOS
  register char *sp;
#else
  struct passwd *pw;
#endif

  /* Set the default option flags. */
  strcpy(opt_b, "");
  strcpy(opt_c, "");
  opt_e = 0;
  opt_f = 0;
  opt_p = 0;
  opt_q = 0;
  strcpy(opt_s, "");
  opt_t = 1;
  opt_v = 0;

  /* Set the default config flags. */
  rc_date = 0;
  rc_asksub = 0;
  rc_askcc = 0;
  rc_askbcc = 0;
  rc_autosig = 0;
  rc_copies = 0;
  rc_folder = (char *)NULL;
  rc_mbox = (char *)NULL;
  rc_record = (char *)NULL;
  rc_shell = (char *)NULL;
  rc_prompt = PROMPT;
  rc_eedit = EEDITOR;
  rc_vedit = VEDITOR;
  rc_pager = (char *)NULL;
  rc_reply_to = (char *)NULL;

  /* Fetch our system and user info. */
#if _UNIX
  u_mask = umask(006);
  if ((pw = getpwuid(getuid())) != (struct passwd *)NULL) {
        strcpy(u_name, pw->pw_name);
        strcpy(u_home, pw->pw_dir);
  } else {
        perror("getpwuid");
        exit(-1);
  }
#else
  if ((sp = getenv("USER")) != (char *)NULL) strcpy(u_name, sp);
    else strcpy(u_name, "MS-DOS");
  if ((sp = getenv("HOME")) != (char *)NULL) strcpy(u_home, sp);
    else strcpy(u_home, "C:\\.");
#endif
}


static void usage()
{
  fprintf(stderr, "Usage: wmail [-epqrv] [-f file]\n");
  fprintf(stderr, "       wmail [-bctv] [-i file] [-s subject] user ...\n");
  exit(-1);
}


void main(argc, argv)
int argc;
char *argv[];
{
  char buff[PATH_MAX];
  DRAFT *draft;
  MBOX *mbox;
  char *mailbox, *infile;
  register int i;
  extern int getopt(), optind;
  extern char *optarg;
#ifndef COHERENT
  extern int opterr;
#endif

  /* Go process the CONFIG file. */
  mailbox = (char *)NULL;
  infile = (char *)NULL;
  var_init();

  /* Check the commandline for arguments. */
#ifndef COHERENT
  opterr = 0;
#endif
 while ((i = getopt(argc, argv, "b:c:ef:i:pqrs:tv")) != EOF) switch(i) {
	case 'b':       /* Bcc: */
        	if (optarg == (char *)NULL) usage();
                strcpy(opt_b, optarg);
                break;
        case 'c':       /* Cc: */
                if (optarg == (char *)NULL) usage();
                strcpy(opt_c, optarg);
                break;
        case 'e':       /* only check for mail, do not read it */
                opt_e = 1 - opt_e;
                break;
        case 'f':       /* use another mailbox; "mbox" default */
                opt_f = 1 - opt_f;
                if (opt_f == 1) {
                        if (optarg == (char *)NULL) optarg = SAVEFILE;
                        mailbox = optarg;
                }
                break;
        case 'i':       /* use another input-file */
                if (optarg == (char *)NULL) usage();
                infile = optarg;
                break;
	case 'p':       /* print all messages and exit */
                opt_p = 1 - opt_p;
                break;
        case 'q':       /* abort if SIGINT received */
                opt_q = 1 - opt_q;
                break;
        case 'r':       /* show messages in reverse order */
                /*IGNORED*/
                break;
        case 's':       /* specify "subject" line */
                if (optarg == (char *)NULL) usage();
                strcpy(opt_s, optarg);
                break;
        case 't':       /* show all addressees in "To:" line */
                opt_t = 1 - opt_t;
                break;
        case 'v':       /* turn on debugging */
                opt_v = 1 - opt_v;
                break;
        default:
                usage();
  }

  /* Read the System Mail Config File. */
  rc_read(SMAILRC);

  /* Read the User Mail Config File. */
  sprintf(buff, MAILRC, u_home);
  rc_read(buff);

  /* If these weren't defined in .mailrc, check the environment. */
  if (rc_vedit == (char *)NULL) rc_pager = getenv("VISUAL");
  if (rc_eedit == (char *)NULL) rc_pager = getenv("EDITOR");
  if (rc_pager == (char *)NULL) rc_pager = getenv("PAGER");
#ifdef MSDOS
  if (rc_shell == (char *)NULL) rc_shell = getenv("COMSPEC");
#else
  if (rc_shell == (char *)NULL) rc_shell = getenv("SHELL");
#endif

  /* Do we have to SEND a message? */
  if (optind < argc) {
        draft = mk_draft(1, infile, &argv[optind], opt_b, opt_c, opt_s);
        if ((i = ed_draft(draft)) == 0) i = do_send(draft);
	rm_draft(draft);
        exit(i);
  }

  /* Check for any presence of mail? */
  if (opt_e == 1) {
        i = mb_check(mailbox);
        exit(i);
  }

  /* Read the mailbox. */
  if ((mbox = mb_read(mailbox)) == (MBOX *)NULL) exit(1);

  /* No, so we must either go into command mode or print all letters. */
  if (opt_p == 1) i = do_prall(mbox);
    else i = do_cmd(mbox);

  /* Purge the mailbox if needed. */
  (void) mb_purge(mbox);

  exit(i);
}
