/*
 * W-MAIL       MicroWalt Extended Mail Agent.
 *              This module takes care of the creation of a message, also
 *              known as a "draft".  If needed, it handles message editing
 *              by calling the "EDIT" module.
 *
 * Author:      Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 *		Copyright 1988-1992 MicroWalt Corporation
 */
#include "wmail.h"
#ifdef MSDOS
#   include <io.h>
#endif


static _PROTOTYPE( void ask_one, (DRAFT *, char *, char *, char *, int)	    );


/*
 * Set up the value of a single header field.
 * Perhaps this function should be in the "command" module,
 * to allow for a "visual" mode?
 */
static void ask_one(draft, name, dflt, hdr, ask)
DRAFT *draft;
char *name;
char *dflt;
char *hdr;
int ask;
{
  char buff[512];
  register char *sp;

  if (dflt[0] == '\0') {
	if ((ask == 1) && isatty(fileno(draft->fp))) {
		fprintf(stderr, name);
		(void) fflush(stderr);
		(void) fgets(buff, 512, stdin);
		strcpy(hdr, buff);
		sp = strrchr(hdr, '\n');
		if (sp != (char *)NULL) *sp = '\0';
	} else strcpy(hdr, "");
  } else strcpy(hdr, dflt);
}


/* Create a message draft header. */
DRAFT *mk_draft(askit, path, rcpts, bcc, cc, subj)
int askit;
char *path;
char **rcpts;
char *bcc;
char *cc;
char *subj;
{
  DRAFT *hdr;
  time_t now;
  register char *sp;

  /* Allocate a message header. */
  if ((hdr = (DRAFT *)malloc(sizeof(DRAFT))) == (DRAFT *)NULL) {
        fprintf(stderr, "mk_draft: Out of memory!\n");
        return((DRAFT *)NULL);
  }

  /* Set the name of the input ("data") file. */
  if (path != (char *)NULL) {
	strcpy(hdr->ipath, path);
	hdr->fp = fopen(hdr->ipath, "r");
	if (hdr->fp == (FILE *)NULL) {
		perror(hdr->ipath);
		free(hdr);
		return((DRAFT *)NULL);
	}
  } else {
	strcpy(hdr->ipath, "");
	hdr->fp = stdin;
  }

  /* Create the names for the temporary files. */
  (void) time(&now);
#if _UNIX
  sprintf(hdr->dpath, ED_DRAFT, getpid());
  sprintf(hdr->tpath, CP_DRAFT, getpid());
#else
  sprintf(hdr->dpath, ED_DRAFT, (int) (now & 0xFFFFL));
  sprintf(hdr->tpath, CP_DRAFT, (int) (now & 0xFFFFL));
#endif

  /* First of all, create a postmark. */
  (void) time(&now);
  sprintf(hdr->from, "%s %-24.24s", u_name, ctime(&now));

  /* Tell the viewers what program we are. */
  sprintf(hdr->ver, "W-MAIL %s", VERSION);
  sprintf(hdr->date, "%s", xtime(&now));
  strcpy(hdr->subject, "");
  strcpy(hdr->cc, "");
  strcpy(hdr->bcc, "");
  strcpy(hdr->to, "");

  /* Ask for the values of some other fields, if needed. */
  if ((askit == 1) && (hdr->fp == stdin)) {
        ask_one(hdr, "Subject: ", subj, hdr->subject, rc_asksub);
        ask_one(hdr, "Cc: ", cc, hdr->cc, rc_askcc);
        ask_one(hdr, "Bcc: ", bcc, hdr->bcc, rc_askbcc);
  }

  /* Now prepare a To: list. */
  strcpy(hdr->to, "");
  while (*rcpts != (char *)NULL) {
	strcat(hdr->to, *rcpts++);
	strcat(hdr->to, ", ");
  }
  if ((sp = strrchr(hdr->to, ',')) != (char *)NULL) *sp = '\0';
  return(hdr);
}


/* Create a final message text. */
int cp_draft(draft)
DRAFT *draft;
{
  char buff[1024];
  register FILE *ifp;
  register FILE *ofp;

  /* Open the data file. */
  if (draft->fp == stdin) {
	ifp = draft->fp;
        if (isatty(fileno(draft->fp))) {
		if ((ifp = fopen(draft->dpath, "r")) == (FILE *)NULL) {
			perror(draft->dpath);
			return(-1);
		}
	}
  } else {
	if (draft->fp != (FILE *)NULL) (void) fclose(draft->fp);
	if ((ifp = fopen(draft->ipath, "r")) == (FILE *)NULL) {
		perror(draft->ipath);
		return(-1);
	}
  }

  /* Create the message file. */
  if ((ofp = fopen(draft->tpath, "w")) == (FILE *)NULL) {
        perror(draft->tpath);
        return(-1);
  }

  /* Write out the message header. */
  fprintf(ofp, "From %s\n", draft->from);
  fprintf(ofp, "To: %s\n", draft->to);
  if (draft->cc[0] != '\0') fprintf(ofp, "Cc: %s\n", draft->cc);
#ifdef notdef
  if (draft->bcc[0] != '\0') fprintf(ofp, "Bcc: %s\n", draft->bcc);
#endif
  if (draft->subject[0] != '\0') fprintf(ofp, "Subject: %s\n", draft->subject);
  fprintf(ofp, "X-Mailer: %s\n", draft->ver);
  if (rc_date == 1) fprintf(ofp, "Date: %s\n", draft->date);
  fprintf(ofp, "\n");

  /* Perform fast file copy. */
  while(fgets(buff, 1024, ifp) != (char *)NULL) {
        fprintf(ofp, "%s", buff);
  }
  (void) fflush(ofp); (void) fclose(ofp);
  return(0);
}


/* Edit the contents of a draft message. */
int ed_draft(draft)
DRAFT *draft;
{
  char buff[1024];
  FILE *ofp;
  char *sp;
  int i;

  /* If interactive, create a "draft" message file first. */
  if (isatty(fileno(draft->fp))) {
	if (access(draft->dpath, 0) < 0) {
		ofp = fopen(draft->dpath, "w");
		if (ofp != (FILE *)NULL) (void) fclose(ofp);
	}
	if ((ofp = fopen(draft->dpath, "r+")) == (FILE *)NULL) {
        	perror(draft->dpath);
        	return(-1);
	} else {
        	if (fseek(ofp, 0, SEEK_END) < 0) {
                	perror(draft->dpath);
                	(void) fclose(ofp);
                	return(-1);
        	}
	}

	/* Start the editor mode. */
	i = 1;
        while (i == 1) {
            if ((sp = fgets(buff, 1024, draft->fp)) == (char *)NULL) break;
            if ((sp = strchr(buff, '\n')) != (char *)NULL) *sp = '\0';
            switch(buff[0]) {
#if 1   /* END if DOT */
                    case '.':
                            if (buff[1] == '\0') i = 0;
                            break;
#endif
                    case '~':
                            if (buff[1] == '~') fprintf(ofp, "~");
                                    i = do_tilde(draft, &ofp, &buff[1]);
                            break;
                    default:
                            fprintf(ofp, "%s\n", buff);
            }
        }
        (void) fflush(ofp);
        if (ferror(ofp)) i = -1;

	/* Did all go well enough to continue? */
	if (i < 0) {
        	perror(draft->dpath);
		fprintf(stderr, "\n[ Message Aborted ]\n");
        	(void) fclose(ofp);
        	return(-1);
	}

	/* Add signature if needed. */
        if (rc_autosig == 1) signature(ofp);

	/* Flush and close files. */
	if (ferror(ofp) || fclose(ofp)) {
        	perror(draft->dpath);
        	return(-1);
	}
  }
  return(0);
}


/* Clean up the remains of a draft selector. */
void rm_draft(draft)
register DRAFT *draft;
{
  if (draft == (DRAFT *)NULL) return;

  if (draft->fp != stdin) (void) fclose(draft->fp);
  if (draft->dpath[0] != '\0') (void) unlink(draft->dpath);
  if (draft->tpath[0] != '\0') (void) unlink(draft->tpath);
}
