/*
 * W-MAIL       MicroWalt Extended Mail Agent.
 *              The paging-code (for paging letters on the screen)
 *              was taken from "more.c", by Brandon Allbery.
 *
 * Author:      Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 *		Copyright 1988-1992 MicroWalt Corporation
 */
#include "wmail.h"
#if (TTYIO == TTY_SGTTY)
#   include <sgtty.h>
#   define TTY	struct sgttyb
#endif
#if (TTYIO == TTY_TERMIO)
#   include <termio.h>
#   define TTY	struct termio
#endif
#if (TTYIO == TTY_TERMIOS)
#   include <sys/ioctl.h>
#   include <termios.h>
#   define TTY	struct termios
#endif
#include <signal.h>
#if _UNIX
#   ifdef MINIX
#       include <sys/wait.h>
#       include <termcap.h>
#   endif
#   ifdef LINUX
#	include <sys/wait.h>
#	include <termcap.h>
#   else
#       include <curses.h>
#   endif
#else
#   include <conio.h>
#   include <dos.h>
#   include <io.h>
#endif


static int pg_line;                     /* current terminal line            */
static int pg_col;                      /* current terminal column          */
static int pg_CO;                       /* # of chars on screen line        */
static int pg_LI;                       /* # of lines on screen             */
static char *pg_SO;                     /* StandOUT (reverse) mode          */
static char *pg_SE;                     /* StandIN (normal) mode            */
static char *pg_CE;                     /* ClearToEndOfLine                 */
static char *pg_TERM = (char *)NULL;    /* terminal name/identifier         */
#if _UNIX
static char pg_tcaps[256];              /* termcap capability buffer        */
static TTY ttymode;                     /* terminal parameters              */
#endif


static _PROTOTYPE( void pg_cbreak, (void)                                   );
static _PROTOTYPE( void pg_cooked, (void)                                   );
static _PROTOTYPE( char pg_getc, (void)                                     );
static _PROTOTYPE( int  pg_puts, (char *)                                   );
static _PROTOTYPE( void pg_init, (void)                                     );
static _PROTOTYPE( void pg_page, (char *, MSG *)                            );


#ifdef MINIX
_PROTOTYPE( FILE *popen, (char *path, char *mode)                           );
#endif


/* Put the terminal in CBREAK mode, no echo. */
static void pg_cbreak()
{
#if (TTYIO == TTY_SGTTY)
  (void) ioctl(0, TIOCGETP, &ttymode);
  ttymode.sg_flags |= CBREAK;
  ttymode.sg_flags &= ~ECHO;
  (void) ioctl(0, TIOCSETP, &ttymode);
#endif
#if (TTYIO == TTY_TERMIO)
  (void) ioctl(0, TCGETA, &ttymode);
  ttymode.c_lflag &= ~(ICANON | OPOST | ECHO);
  (void) ioctl(0, TCSETA, &ttymode);
#endif
#if (TTYIO == TTY_TERMIOS)
  (void) ioctl(0, TCGETS, &ttymode);
  ttymode.c_lflag &= ~(ICANON | OPOST | ECHO);
  (void) ioctl(0, TCSETS, &ttymode);
#endif
}


/* Put the terminal in COOKED mode, echo enabled. */
static void pg_cooked()
{
#if (TTYIO == TTY_SGTTY)
  (void) ioctl(0, TIOCGETP, &ttymode);
  ttymode.sg_flags &= ~CBREAK;
  ttymode.sg_flags |= ECHO;
  (void) ioctl(0, TIOCSETP, &ttymode);
#endif
#if (TTYIO == TTY_TERMIO)
  (void) ioctl(0, TCGETA, &ttymode);
  ttymode.c_lflag |= (ICANON | OPOST | ECHO);
  (void) ioctl(0, TCSETA, &ttymode);
#endif
#if (TTYIO == TTY_TERMIOS)
  (void) ioctl(0, TCGETS, &ttymode);
  ttymode.c_lflag |= (ICANON | OPOST | ECHO);
  (void) ioctl(0, TCSETS, &ttymode);
#endif
}


/* Read ONE keystroke from the keyboard. */
static char pg_getc()
{
  char c;

  pg_cbreak();
#if _UNIX
  (void) read(0, &c, 1);
#else
  c = (char) getch();
#endif
  pg_cooked();
  return(c);
}


/* Write one line of text to the screen. */
static int pg_puts(buf)
register char *buf;
{
  char cmd;
  int done;

  done = 0;
  cmd = '?';
  while(done == 0) {
    switch (*buf) {
        case '\0':
        case '\n':
        case '\r':
                putchar('\n');
                pg_col = 0;
                done = 1;
                if (++pg_line == pg_LI) {
                        (void) fflush(stdout);
                        fprintf(stderr, "%s--More--%s", pg_SO, pg_SE);
			(void) fflush(stderr);
                        do {
                                cmd = pg_getc();
                        } while (strchr(" \r\nqQ'nN", cmd) == (char *)NULL);
                        fprintf(stderr, "\r%s", pg_CE);
			(void) fflush(stderr);
                        pg_line = 0;
                }
                break;
        case '\b':
                if (pg_col == 0) {
                        pg_line--;
                        pg_col = pg_CO - 1;
                } else pg_col--;
                printf("\b \b");
                cmd = '\0';
                break;
        case '\t':
                do {
                        pg_col++;
                } while (pg_col & 7);
                putchar(*buf);
                cmd = '\0';
                break;
        default:
                if ((*buf < ' ') || (*buf & 0x80)) *buf = '?';
                putchar(*buf);
                cmd = '\0';
                if (++pg_col == pg_CO) {
                        pg_col = 0;
                        if (++pg_line == pg_LI) {
                                (void) fflush(stdout);
                                fprintf(stderr, "%s--More--%s",pg_SO, pg_SE);
				(void) fflush(stderr);
                                do {
                                        cmd = pg_getc();
                                } while (strchr(" \r\nqQ'nN", cmd)
                                                        == (char*)NULL);
                                fprintf(stderr, "\r%s", pg_CE);
				(void) fflush(stderr);
                                pg_line = 0;
                        }
                }
    }
    buf++;
    switch (cmd) {
        case '\0':
                break;
        case ' ':
                pg_line = 0;
                break;
        case '\r':
        case '\n':
                pg_line = pg_LI - 1;
                break;
        case 'q':
        case 'Q':
                return(1);
        case 'n':
        case 'N':
                return(1);
        default:
                break;
    }

    if (done == 1) break;
  }
  (void) fflush(stdout);
  (void) fflush(stderr);
  return(0);
}


/* Initialize the internal pager. */
static void pg_init()
{
#ifdef MSDOS
  pg_CO = 80;
  pg_LI = 25;
  pg_SO = "\033[7m";
  pg_SE = "\033[0m";
  pg_CE = "\033[K";
  pg_TERM = "MS-DOS";
#else
  char buf[1024];
  char *tbufp;

  tbufp = pg_tcaps;

  if ((pg_TERM = getenv("TERM")) == (char *)NULL) {
        fprintf(stderr, "TERM not defined, using \"vt100\"\n");
        pg_TERM = "vt100";
  }
  switch(tgetent(buf, pg_TERM)) {
        case -1:
                fprintf(stderr, "No /etc/termcap present!\n");
                exit(-1);
                /*NOTREACHED*/
        case 0:
                fprintf(stderr, "No termcap definition for $TERM\n");
                exit(-1);
                /*NOTREACHED*/
        default:
                break;
  }
  if ((pg_SO = tgetstr("so", &tbufp)) == (char *)NULL) {
        fprintf(stderr, "Termcap: \"so\" not defined!\n");
        exit(-1);
        /*NOTREACHED*/
  }
  if ((pg_SE = tgetstr("se", &tbufp)) == (char *)NULL) {
        fprintf(stderr, "Termcap: \"se\" not defined!\n");
        exit(-1);
        /*NOTREACHED*/
  }
  if ((pg_CE = tgetstr("ce", &tbufp)) == (char *)NULL) {
        fprintf(stderr, "Termcap: \"ce\" not defined!\n");
        exit(-1);
        /*NOTREACHED*/
  }
  pg_LI = tgetnum("li");
  pg_CO = tgetnum("co");
#endif
  pg_LI--;                                  /* "Message NN:" counts!        */
  pg_LI--;                                  /* "--More--" counts!           */
}


/*
 * Start up an external pager for some message.
 * Under UNIX, we can do this by setting up a pipe, and have the
 * "pager" program read from that pipe (as a child process), while
 * we stuff our message bytes into the pipe.
 * Under MS-DOS, we have to create a temporary file, and invoke
 * the "command.com" interpreter with the pager program as command,
 * and with the temporary file as redirected standard input...
 */
static void pg_page(prg, msg)
char *prg;
MSG *msg;
{
  char buff[1024];
#ifdef MSDOS
  char temp[PATH_MAX];
  char *args[16];
  register FILE *fp;
  time_t now;

  (void) time(&now);
  sprintf(temp, MO_MTEMP, (int) (now & 0xFFFFL));
  if ((fp = fopen(temp, "w")) == (FILE *)NULL) {
        perror(temp);
        return;
  }

  /* Now, copy the message into the temp file. */
  msg->curr = msg->start;
  while(mb_rdline(msg, buff) > 0) fprintf(fp, "%s\n", buff);
  (void) fflush(fp);
  (void) fclose(fp);

  /* We now have the temp file.  Create a command line. */
  args[0] = "command.com";
  args[1] = "-c";
  args[2] = prg;
  args[3] = "<";
  args[4] = temp;
  args[5] = (char *)NULL;

  /* Execute the command. */
  (void) vexec(prg, args);

  /* Remove the temp file and we're done! */
  (void) unlink(temp);
#else
  register FILE *fp;
  int pid, status;

  if ((pid = fork()) == 0) {
        (void) signal(SIGPIPE, SIG_IGN);
        if ((fp = popen(rc_pager, "w")) == (FILE *)NULL) {
                perror(prg);
                return;
        }
        (void) fflush(stdout);
        msg->curr = msg->start;
        while (mb_rdline(msg, buff) > 0) fprintf(fp, "%s\n", buff);
        (void) fflush(fp);
        (void) pclose(fp);
        (void) fflush(stdout);
        exit(0);
  } else {
        if (pid > 0) {
                while (wait(&status) != pid)
                            ;
        }
  }
#endif
}


/* Display the given letter on the screen. */
void pg_msg(msg)
MSG *msg;
{
  char buff[1024];
  int st;

  if (rc_pager != (char *)NULL) {
        pg_page(rc_pager, msg);
        return;
  }

  /* Initialize the internal pager. */
  if (pg_TERM == (char *)NULL) pg_init();
  pg_line = 0;
  pg_col = 0;
  st = 0;

  msg->curr = msg->start;
  while ((mb_rdline(msg, buff) > 0) && (st == 0)) st = pg_puts(buff);
  (void) fflush(stdout);
}
