/*
 * W-MAIL       MicroWalt Extended Mail Agent.
 *              This module reads and processes the W-MAIL startup
 *              files.  It is usually called twice: once for the
 *              system-wide startup file (/usr/lib/mailrc), and once
 *              for the file in a user's home directory (.mailrc).
 *
 * Author:      Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 *		Copyright 1988-1992 MicroWalt Corporation
 */
#include "wmail.h"


typedef struct _alias_ {
  struct _alias_ *next;
  char           *alias;
  char           *expand;
} ALIAS;


static ALIAS *rc_alist = (ALIAS *)NULL;    /* alias list                    */


#define isterm(c) ((c) == ' ' || (c) == '\t' || (c) == '#' || (c) == '=')


static _PROTOTYPE( void do_set, (char *, char *, int)                       );
static _PROTOTYPE( void do_alias, (char *, char *)                          );


/* Assign a "set" variable. */
static void do_set(var, val, assign)
char *var;
char *val;
int assign;
{
  char *sp;

  if (assign == 0) {
	if (!strcmp(var, "date")) rc_date = 1;
	  else if (!strcmp(var, "nodate")) rc_date = 0;
          else if (!strcmp(var, "asksub")) rc_asksub = 1;
          else if (!strcmp(var, "noasksub")) rc_asksub = 0;
          else if (!strcmp(var, "askcc")) rc_askcc = 1;
          else if (!strcmp(var, "noaskcc")) rc_askcc = 0;
          else if (!strcmp(var, "askbcc")) rc_askbcc = 1;
          else if (!strcmp(var, "noaskbcc")) rc_askbcc = 0;
          else if (!strcmp(var, "autosig")) rc_autosig = 1;
          else if (!strcmp(var, "noautosig")) rc_autosig = 0;
          else if (!strcmp(var, "copies")) rc_copies = 1;
          else if (!strcmp(var, "nocopies")) rc_copies = 0;
          else fprintf(stderr, ".mailrc: unknown boolean \"%s\"\n", var);
  } else {
        sp = (char *)malloc(strlen(val) + 1);
        if (sp == (char *)NULL) {
                fprintf(stderr, ".mailrc: out of memory for \"%s\"\n", var);
                return;
        } else strcpy(sp, val);
        if (!strcmp(var, "eeditor")) rc_eedit = sp;
          else if (!strcmp(var, "veditor")) rc_vedit = sp;
          else if (!strcmp(var, "pager")) rc_pager = sp;
          else if (!strcmp(var, "shell")) rc_shell = sp;
          else if (!strcmp(var, "prompt")) rc_prompt = sp;
          else if (!strcmp(var, "folder")) rc_folder = sp;
          else if (!strcmp(var, "record")) rc_record = sp;
          else if (!strcmp(var, "mailsave")) rc_mbox = sp;
          else if (!strcmp(var, "reply-to")) rc_reply_to = sp;
          else {
                fprintf(stderr, ".mailrc: unknown variable \"%s\"\n", var);
                free(sp);
        }
  }
}


/* Add an "alias" or "group" alias to the list. */
static void do_alias(name, expand)
char *name;
char *expand;
{
  register ALIAS *ap, *xp;

  if ((xp = (ALIAS *)malloc(sizeof(ALIAS))) == (ALIAS *)NULL) {
        fprintf(stderr, ".mailrc: out of memory for alias \"%s\"\n", name);
        return;
  }
  xp->alias = (char *)malloc(strlen(name) + 1);
  xp->expand = (char *)malloc(strlen(expand) + 1);
  if (xp->alias == (char *)NULL || xp->expand == (char *)NULL) {
        fprintf(stderr, ".mailrc: out of memory for expansion \"%s\"\n",
                                                                expand);
        return;
  }
  strcpy(xp->alias, name);
  strcpy(xp->expand, expand);
  if (rc_alist == (ALIAS *)NULL) {
        rc_alist = xp;
        xp->next = (ALIAS *)NULL;
  } else {
        ap = rc_alist;
        while (ap->next != (ALIAS *)NULL) ap = ap->next;
        ap->next = xp;
        xp->next = (ALIAS *)NULL;
  }
}


/* Read the mailer configuration file (".mailrc"). */
void rc_read(path)
char *path;
{
  char buff[1024], val[1024];
  char cmd[40], var[40];
  int assign, quote, line;
  FILE *fp;
  register char *sp, *bp;

  if ((fp = fopen(path, "r")) == (FILE *)NULL) return;
  line = 0;
  while(1) {
        line++;
        if ((sp = fgets(buff, 1024, fp)) == (char *)NULL) break;
        if ((bp = strchr(sp, '\n')) != (char *)NULL) *bp = '\0';
        if (*sp == '#' || *sp == '\0') continue;
        while (*sp == ' ' || *sp == '\t') sp++;
        bp = cmd;
        while (*sp && !isterm(*sp)) {
                if (*sp >= 'A' && *sp <= 'Z') *bp++ = *sp - 'A' + 'a';
                  else *bp++ = *sp;
                sp++;
        }
        *bp = '\0';
        while (*sp == ' ' || *sp == '\t') sp++;
        bp = var;
        while (*sp && !isterm(*sp)) {
                if (*sp >= 'A' && *sp <= 'Z') *bp++ = *sp - 'A' + 'a';
                  else *bp++ = *sp;
                sp++;
        }
        *bp = '\0';
        while (*sp == ' ' || *sp == '\t') sp++;
        bp = val;
        quote = 0;
        if (*sp == '=') {
                sp++;
                while (*sp == ' ' || *sp == '\t') sp++;
                assign = 1;
        } else assign = 0;
        while (*sp && *sp != '#') switch(*sp) {
                case '"':
                        quote = 1 - quote;
                        sp++;
                        continue;
                case ' ':
                case '\t':
                        if (quote == 1) *bp++ = *sp;
                        sp++;
                        continue;
                case '#':
                        if (quote == 1) *bp++ = *sp++;
                          else *sp = '\0';
                        continue;
                default:
                        *bp++ = *sp++;
                        continue;
        }
        *bp = '\0';
        if (!strcmp(cmd, "set")) do_set(var, val, assign);
          else if (!strcmp(cmd, "alias") ||
                   !strcmp(cmd, "group")) do_alias(var, val);
          else fprintf(stderr, "%s: syntax error in line %d\n", path, line);
  }
  (void) fclose(fp);
}


/*
 * Fetch the definition of an alias-to-be.
 * We do this with a routine instead of a global alias list,
 * to keep the ALIAS structure separated from the rest.
 */
char *rc_alias(name)
char *name;
{
  register ALIAS *ap;

  ap = rc_alist;
  while (ap != (ALIAS *)NULL) {
        if (!strcmp(ap->alias, name)) return(ap->expand);
        ap = ap->next;
  }
  return((char *)NULL);
}
