/*
 * W-MAIL       MicroWalt Extended Mail Agent.
 *              This module takes care of the creation of a message.
 *              It has a builtin editor that lets users compose their
 *              message, possibly with help of an ASCII text editor.
 *
 * Author:      Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 *		Copyright 1988-1992 MicroWalt Corporation
 */
#include "wmail.h"
#ifdef MSDOS
#   include <io.h>
#endif


static _PROTOTYPE( void msg_fetch, (char *, int, int, FILE *)               );
static _PROTOTYPE( void do_help, (void)                                     );


/* Fetch the contents of message or file 'name'. */
static void msg_fetch(name, isfile, quote, ofp)
char *name;
int isfile;
int quote;
FILE *ofp;
{
  char buff[1024];
  long chars;
  int lines, i;
  register FILE *ifp;
  MSG *msg;

  chars = 0L;
  lines = 0;

  /* Is this a message or a file? */
  if (isfile == 0) {
        msg = mb_select(atoi(name));
        if ((msg == (MSG *)NULL) || (msg->status == MS_DELETED)) {
                fprintf(stderr, "%s: inapropriate message!\n", name);
                return;
        }
        printf("Message %s", name);
        msg->curr = msg->start;
        while((i = mb_rdline(msg, buff)) > 0) {
                chars += (long) i;
                lines++;
                if (quote || !strncmp(buff, "From ", 5))
                                    fprintf(ofp, ">%s\n", buff);
                  else fprintf(ofp, "%s\n", buff);
        }
  } else {
        if ((ifp = fopen(name, "r")) == (FILE *)NULL) {
                perror(name);
                return;
        }
        printf("\"%s\"", name);
        while(fgets(buff, 1024, ifp) != (char *)NULL) {
                chars += (long) strlen(buff);
                lines++;
                if (quote || !strncmp(buff, "From ", 5))
                                    fprintf(ofp, ">%s", buff);
                  else fprintf(ofp, "%s", buff);
        }
  }
  (void) fflush(ofp);
  if (quote) printf(" [quoted]");
  printf(": %lu/%u\n", chars, lines);
}


static void do_help()
{
  printf("\n\t*** W-MAIL Editor Help ***\n\n");
  printf("~?\t\tThis Help Screen\n");
  printf("~!\t\tEscape into Shell\n");
  printf("~a\t\tAppend .signature to message\n");
  printf("~b name(s)\tChange the Bcc: field\n");
  printf("~c name(s)\tChange the Cc: field\n");
  printf("~e\t\tInvoke line editor on current msg\n");
  printf("~m msgno\tInsert msg from the current mailbox\n");
  printf("~q\t\tQuit (with save) sending this msg\n");
  printf("~r filename\tInsert file into current msg\n");
  printf("~R filename\tInsert quoted file into current msg\n");
  printf("~s text\tChange the Subject: of the msg\n");
  printf("~t name(s)\tChange the To: field\n");
  printf("~v\t\tInvoke visual editor on current msg\n");
  printf("~x\t\tExit (abort) sending this msg\n");
  printf("\n");
}


/* Perform a "tilde" action, like in "mailx" style. */
int do_tilde(draft, fpp, cmd)
register DRAFT *draft;
FILE **fpp;
char *cmd;
{
  char *args[4];
  register char *sp;

  /* Get next part of the command line, if any. */
  if (*cmd != '\0') {
        sp = (cmd + 1);
        while (*sp == ' ' || *sp == '\t') sp++;
  } else sp = cmd;

  switch(*cmd) {
        case '?':       /* editor help */
                do_help();
                break;
        case '!':       /* shell escape */
                (void) do_shell(sp);
                printf("\n[continue]\n");
                break;
	case '.':	/* quit msg */
		return(0);
		/*NOTREACHED*/
        case 'a':       /* append SIGNATURE */
                signature(*fpp);
                printf("[continue]\n");
                break;
        case 'b':       /* change the Bcc: field */
		if (*sp != '\0') {
                        strcpy(draft->bcc, sp);
                        printf("Bcc: %s\n", draft->bcc);
                } else {
                        strcpy(draft->bcc, "");
                        printf("Bcc: <NONE>\n");
                }
                break;
        case 'c':       /* change Cc: field */
		if (*sp != '\0') {
                        strcpy(draft->cc, sp);
                        printf("Cc: %s\n", draft->cc);
                } else {
                        strcpy(draft->cc, "");
                        printf("Cc: <NONE>\n");
                }
                break;
        case 'e':       /* invoke Line Editor (ED) */
                (void) fclose(*fpp);
                args[1] = draft->dpath;
                args[2] = (char *)NULL;
                (void) vexec(rc_eedit, args, (char *)NULL);
                *fpp = fopen(draft->dpath, "a");
                printf("[continue]\n");
                break;
        case 'm':       /* input "mailbox" message */
                msg_fetch(sp, 0, 1, *fpp);
                printf("[continue]\n");
                break;
        case 'q':       /* quit (abort) sending message (save message) */
                (void) fclose(*fpp);
                dead_letter(draft);
                /* FALL_THROUGH */
        case 'x':       /* exit this message (no save) */
		errno = EINTR;
                return(-1);
        case 'r':       /* read and insert File */
                msg_fetch(sp, 1, 0, *fpp);
                printf("[continue]\n");
                break;
        case 'R':       /* read and insert Quoted File */
                msg_fetch(sp, 1, 1, *fpp);
                printf("[continue]\n");
                break;
        case 's':       /* change Subject: */
		if (*sp != '\0') {
                        strcpy(draft->subject, sp);
                        printf("Subject: %s\n", draft->subject);
                } else {
                        strcpy(draft->subject, "");
                        printf("Subject: <NONE>\n");
                }
                break;
        case 't':       /* change To: field */
		printf("*** Changing To: is not yet implemented!\n");
                break;
        case 'v':       /* invoke Visual Editor (VI) */
                (void) fclose(*fpp);
                args[1] = draft->dpath;
                args[2] = (char *)NULL;
                (void) vexec(rc_vedit, args, (char *)NULL);
                *fpp = fopen(draft->dpath, "a");
                printf("[continue]\n");
                break;
        default:
                printf("*** Unknown escape.  Please use ~? for help.\n");
                break;
  }
  return(1);
}
