/*
 * W-MAIL       MicroWalt Extended Mail Agent.
 *              Configuration file.  This file holds all the definitions
 *              that can be altered by users at compile time.
 *
 * Author:      Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 *		Copyright 1988-1992 MicroWalt Corporation
 */
#ifndef _WMAIL_CONFIG_H
#define _WMAIL_CONFIG_H

#define TTY_NONE	0		/* no terminal control (MSDOS)	*/
#define TTY_SGTTY	1		/* struct sgttyb control (V7)	*/
#define TTY_TERMIO	2		/* struct termio control (SysV)	*/
#define TTY_TERMIOS	3		/* struct termios, POSIX	*/


/* MINIX 1.5 or up, with Smail or UMAIL installed. */
#ifdef MINIX
#   define VERSION      "4.0.1C/MINIX (02/08/93)"
#   define MAILBOX      "/usr/spool/mail/%s"
#   define ED_DRAFT     "/tmp/draft.%06u"
#   define CP_DRAFT     "/tmp/wmail.%06u"
#   define CP_MTEMP     "/tmp/mcpy%06u"
#   define RE_MTEMP     "/tmp/merr%06u"
#   define MO_MTEMP     "/tmp/more%06u"
#   define SMAILRC      "/usr/lib/wmailrc"
#   define MAILRC       "%s/.mailrc"
#   define DEADLETTER   "%s/dead.letter"
#   define SIGNATURE    "%s/.signature"
#   define POSTMASTER   "postmaster"
#   define SAVEFILE     "mbox"
#   define RMAIL        "/usr/bin/rmail"
#   define LMAIL        "/usr/bin/lmail"
#   define EEDITOR      "/bin/ed"
#   define VEDITOR      "/usr/bin/mined"
#   define TTYIO	TTY_SGTTY
#   define NEW_MAILERS	0
#   define USE_LMAIL	1
#endif

/* LINUX 0.98 or up, with Sendmail, Smail or U-MAIL installed. */
#ifdef LINUX
#   define VERSION      "4.0.1C/LINUX (02/08/93)"
#   define MAILBOX      "/usr/spool/mail/%s"
#   define ED_DRAFT     "/tmp/draft.%06u"
#   define CP_DRAFT     "/tmp/wmail.%06u"
#   define CP_MTEMP     "/tmp/mcpy%06u"
#   define RE_MTEMP     "/tmp/merr%06u"
#   define MO_MTEMP     "/tmp/more%06u"
#   define SMAILRC      "/usr/lib/wmailrc"
#   define MAILRC       "%s/.mailrc"
#   define DEADLETTER   "%s/dead.letter"
#   define SIGNATURE    "%s/.signature"
#   define POSTMASTER   "postmaster"
#   define SAVEFILE     "mbox"
#   define RMAIL        "/usr/bin/rmail"
#   define LMAIL        "/usr/bin/lmail"
#   define EEDITOR      "/bin/ed"
#   define VEDITOR      "/usr/bin/vi"
#   define TTYIO	TTY_TERMIOS
#   define NEW_MAILERS	0
#   define USE_LMAIL	0
#endif

/* Coherent 3.X.Y. */
#ifdef COH3
#   define VERSION      "4.0.1C/Coherent 286 (02/08/93)"
#   define MAILBOX      "/usr/spool/mail/%s"
#   define ED_DRAFT     "/tmp/draft.%06u"
#   define CP_DRAFT     "/tmp/wmail.%06u"
#   define CP_MTEMP     "/tmp/mcpy%06u"
#   define RE_MTEMP     "/tmp/merr%06u"
#   define MO_MTEMP     "/tmp/more%06u"
#   define SMAILRC      "/usr/lib/wmailrc"
#   define MAILRC       "%s/.mailrc"
#   define DEADLETTER   "%s/dead.letter"
#   define SIGNATURE    "%s/.signature"
#   define POSTMASTER   "postmaster"
#   define SAVEFILE     "mbox"
#   define RMAIL        "/usr/bin/rmail"
#   define LMAIL        "/usr/bin/lmail"
#   define EEDITOR      "/bin/ed"
#   define VEDITOR      "/usr/bin/me"
#   define TTYIO	TTY_SGTTY
#   define NEW_MAILERS	0
#   define USE_LMAIL	0
#   define COHERENT	1
#endif

/* Coherent 4.X.Y. */
#ifdef COH4
#   define VERSION      "4.0.1C/Coherent 386 (02/08/93)"
#   define MAILBOX      "%s/mailbox"
#   define ED_DRAFT     "/tmp/draft.%06u"
#   define CP_DRAFT     "/tmp/wmail.%06u"
#   define CP_MTEMP     "/tmp/mcpy%06u"
#   define RE_MTEMP     "/tmp/merr%06u"
#   define MO_MTEMP     "/tmp/more%06u"
#   define SMAILRC      "/usr/lib/wmailrc"
#   define MAILRC       "%s/.mailrc"
#   define DEADLETTER   "%s/dead.letter"
#   define SIGNATURE    "%s/.signature"
#   define POSTMASTER   "postmaster"
#   define SAVEFILE     "mbox"
#   define RMAIL        "/usr/bin/rmail"
#   define LMAIL        "/usr/bin/lmail"
#   define EEDITOR      "/bin/ed"
#   define VEDITOR      "/usr/bin/me"
#   define TTYIO	TTY_TERMIO
#   define NEW_MAILERS	0
#   define USE_LMAIL	0
#   define COHERENT	1
#endif

/* SunOS 4.1.2 running MMDF. */
#ifdef SUNOS
#   define VERSION      "4.0.1C/SunOS (02/08/93)"
#   define MAILBOX      "%s/mailbox"
#   define ED_DRAFT     "/tmp/draft.%06u"
#   define CP_DRAFT     "/tmp/wmail.%06u"
#   define CP_MTEMP     "/tmp/mcpy%06u"
#   define RE_MTEMP     "/tmp/merr%06u"
#   define MO_MTEMP     "/tmp/more%06u"
#   define SMAILRC      "/usr/lib/mailrc"
#   define MAILRC       "%s/.mailrc"
#   define DEADLETTER   "%s/dead.letter"
#   define SIGNATURE    "%s/.signature"
#   define POSTMASTER   "postmaster"
#   define SAVEFILE     "mbox"
#   define RMAIL        "/usr/bin/rmail"
#   define LMAIL        "/usr/bin/lmail"
#   define EEDITOR      "/bin/ed"
#   define VEDITOR      "/bin/vi"
#   define TTYIO	TTY_TERMIOS
#   define NEW_MAILERS	0
#   define USE_LMAIL	0
#endif

/* UNIX.  Let us say "standard" UNIX... :-) */
#ifdef UNIX
#   define VERSION      "4.0.1C/UNIX (02/08/93)"
#   define MAILBOX      "/usr/mail/%s"
#   define ED_DRAFT     "/tmp/draft.%06u"
#   define CP_DRAFT     "/tmp/wmail.%06u"
#   define CP_MTEMP     "/tmp/mcpy%06u"
#   define RE_MTEMP     "/tmp/merr%06u"
#   define MO_MTEMP     "/tmp/more%06u"
#   define SMAILRC      "/usr/lib/mailrc"
#   define MAILRC       "%s/.mailrc"
#   define DEADLETTER   "%s/dead.letter"
#   define SIGNATURE    "%s/.signature"
#   define POSTMASTER   "postmaster"
#   define SAVEFILE     "mbox"
#   define RMAIL        "/usr/bin/rmail"
#   define LMAIL        "/usr/bin/lmail"
#   define EEDITOR      "/bin/ed"
#   define VEDITOR      "/bin/vi"
#   define TTYIO	TTY_TERMIO
#   define NEW_MAILERS	0
#   define USE_LMAIL	0
#endif

/* MS-DOS 3.X, 4.X or 5.X. */
#ifdef MSDOS
#   define VERSION      "4.0.1C/MS-DOS (02/08/93)"
#   define MAILBOX      "C:\\USR\\SPOOL\\MAIL\\%s"
#   define ED_DRAFT     "C:\\TMP\\WM%06u.DFT"
#   define CP_DRAFT     "C:\\TMP\\WM%06u.TMP"
#   define CP_MTEMP     "C:\\TMP\\WM%06u.CPY"
#   define RE_MTEMP     "C:\\TMP\\WM%06u.ERR"
#   define MO_MTEMP     "C:\\TMP\\WM%06u.PGR"
#   define SMAILRC      "C:\\USR\\LIB\\MAILRC"
#   define MAILRC       "%s\\_MAILRC"
#   define DEADLETTER   "%s\\DEAD_LET.TER"
#   define SIGNATURE    "%s\\_SIGNATU.RE"
#   define POSTMASTER   "postmast"
#   define SAVEFILE     "MBOX"
#   define RMAIL        "RMAIL.EXE"
#   define LMAIL        "LMAIL.EXE"
#   define EEDITOR      "EDLIN.EXE"
#   define VEDITOR      "EDIT.EXE"
#   define TTYIO	TTY_NONE
#   define NEW_MAILERS	0
#   define USE_LMAIL	0
#endif

#endif  /* _WMAIL_CONFIG_H */
