/*
 * W-MAIL       MicroWalt Extended Mail Agent.
 *              D E F I N I T I O N S
 *
 * Author:      Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 *              Copyright 1988-1992 MicroWalt Corporation
 */
#ifndef _WMAIL_H
#define _WMAIL_H

/* Target Operating System selection. */
#ifdef MINIX                            /* MINIX 1.5.10, or equiv           */
#   define _UNIX        1
#endif
#ifdef UNIX                             /* general UNIX, prob not BSD       */
#   define _UNIX        1
#endif
#ifdef COH3                             /* Coherent 3.X.Y                   */
#   define _UNIX        1
#endif
#ifdef COH4                             /* Coherent 4.X.Y                   */
#   define _UNIX        1
#endif
#ifdef MSDOS                            /* MS-DOS 3.X, 4.X or 5.X           */
#   define _UNIX        0
#endif
#ifdef LINUX
#   define _UNIX        1               /* LINUX 0.98 and up                */
#endif

/* The master INCLUDE section.  What a mess... */
#include <sys/types.h>
#ifndef MINIX                           /* MINIX wants this as the last     */
#   include <stdio.h>
#endif
#include <ctype.h>
#include <errno.h>
#ifndef COH3                            /* Coherent 3.X does not have this  */
#   include <fcntl.h>
#endif
#ifdef COH3                             /* ... but uses this instead        */
#   include <sys/fcntl.h>
#endif
#ifndef COH3                            /* Coherent 3.X does not have this  */
#   include <limits.h>
#endif
#if _UNIX                               /* not in MS-DOS                    */
#   include <pwd.h>
#endif
#include <string.h>
#ifdef COH3
#   include <stddef.h>                  /* what's this good for??           */
#endif
#include <stdlib.h>
#if _UNIX                               /* not in MS-DOS                    */
#   include <unistd.h>
#else
#   include <io.h>                      /* similar to <unistd.h>            */
#endif
#include <time.h>
#ifdef MINIX
#   include <stdio.h>                   /* MINIX wants this to be last      */
#endif

#ifndef PATH_MAX
#   define PATH_MAX     128             /* we _really_ need this!           */
#endif

/*
 * Mailbox types.
 * The oldest and simplest one is the way UNIX version 6 did it: a
 * simple ASCII mailbox, with only lines containing a "From user date"
 * (the so-called POSTMARK) separating messages. UNIX version 7 used
 * the same type of message separation,  but it handled "forwarding"
 * a bit different. UNIX SystemV separates messages by lines containing
 * four SOH characters ("binary mailbox").
 */
#define BOX_V6          1               /* UNIX V6-style mailboxes          */
#define BOX_V7          2               /* UNIX V7-style mailboxes          */
#define BOX_SYSV        3               /* UNIX SystemV mailboxes           */

/* Fetch the CONFIG file. */
#include "config.h"

/* Various stuff. */
#define NR_RCPT         100             /* maximum # recipients             */
#define TEXT_MAX        1024            /* max.length of a header field     */
#define PROMPT          "[%d]& "

#ifdef COH3
typedef long off_t;                     /* this should not be!              */
#endif
#ifdef MSDOS
typedef long off_t;                     /* this should not be!              */
#endif

/* Define a mailbox-entry. */
typedef struct _msg_ {
  struct _msg_  *prev;                  /* linked list: prev message        */
  struct _msg_  *next;                  /* linked list: next message        */
  int           seq;                    /* message number in mailbox        */
  int           status;                 /* message status                   */
  off_t         start;                  /* location mailbox file            */
  off_t         curr;                   /* current position in messge       */
  off_t         chars;                  /* number of characters in msg      */
  int           lines;                  /* number of lines in message       */
  int           padding;                /* for 4-byte padding!              */
  char          *subject;               /* Subject: field                   */
  char          *from;                  /* From: field                      */
  char          *reply;                 /* Reply-To: or From: field         */
  char          *realname;              /* Fullname: field, if any          */
  char          date[30];               /* Date: field                      */
} MSG;
#define MS_NEW          1               /* message NOT READ status          */
#define MS_DELETED      2               /* message DELETED status           */
#define MS_READ         3               /* message READ status              */

/* Define the MBOX type. */
typedef struct {
  char          path[PATH_MAX];         /* path name of mailbox file        */
  FILE          *mbox;                  /* file pointer of mailbox file     */
  MSG           *first;                 /* address of first message in box  */
  MSG           *last;                  /* address of last message in box   */
  int           entries;                /* number of message in mailbox     */
  int           update;                 /* we need to update on exit!       */
} MBOX;

/* This structure defines the in-core "draft" message. */
typedef struct {
  char          dpath[PATH_MAX];        /* path name of draft file          */
  char          ipath[PATH_MAX];        /* path name of input file          */
  char          tpath[PATH_MAX];        /* path name of temp file           */
  char          date[30];               /* date of message creation         */
  char          from[TEXT_MAX];         /* who sent the message?            */
  char          ver[128];               /* mailer version ID                */
  char          to[TEXT_MAX];           /* (primnary) recipients            */
  char          cc[TEXT_MAX];           /* (secondairy) recipients          */
  char          bcc[TEXT_MAX];          /* (secret) recipients              */
  char          subject[TEXT_MAX];      /* what is it all about?            */
  FILE          *fp;                    /* handle of input data file        */
  char		*rcpt[NR_RCPT + 1];	/* list with final recipients	    */
  char		**rcpts;		/* pointer to delivery addresses    */
} DRAFT;


/* Global variables. Keep them minimal! */
#ifndef GLOBAL
#   define      GLOBAL  extern
#endif
GLOBAL char opt_b[PATH_MAX];            /* Bcc: field value                 */
GLOBAL char opt_c[PATH_MAX];            /* Cc: field value                  */
GLOBAL int  opt_e;                      /* only check if there is mail      */
GLOBAL int  opt_f;                      /* the "-f" flag was used           */
GLOBAL int  opt_p;                      /* print-and-exit mode              */
GLOBAL int  opt_q;                      /* take interrupts                  */
GLOBAL char opt_s[PATH_MAX];            /* Subject: field value             */
GLOBAL int  opt_t;                      /* To: field value flag             */
GLOBAL int  opt_v;                      /* enter debugging mode             */
GLOBAL char u_name[PATH_MAX];           /* user's login name                */
GLOBAL char u_home[PATH_MAX];           /* user's home directory            */
#if _UNIX
GLOBAL unsigned u_mask;                 /* saved umask()                    */
#endif

/* W-MAIL Configuration Variables (.mailrc). */
GLOBAL int  rc_date;                    /* BOOL: include our Date: line     */
GLOBAL int  rc_asksub;                  /* BOOL: ask for Subject: line      */
GLOBAL int  rc_autosig;                 /* BOOL: always add signature       */
GLOBAL int  rc_askcc;                   /* BOOL: ask for Cc: line           */
GLOBAL int  rc_askbcc;                  /* BOOL: ask for Bcc: line          */
GLOBAL int  rc_copies;                  /* number of copies to record       */
GLOBAL char *rc_folder;                 /* mail folder                      */
GLOBAL char *rc_record;                 /* traffic recording file           */
GLOBAL char *rc_mbox;                   /* file for dumping messages        */
GLOBAL char *rc_shell;                  /* shell program                    */
GLOBAL char *rc_prompt;                 /* WMAIL prompt                     */
GLOBAL char *rc_eedit;                  /* LINE editor                      */
GLOBAL char *rc_vedit;                  /* VISUAL editor                    */
GLOBAL char *rc_pager;                  /* pager                            */
GLOBAL char *rc_reply_to;               /* Reply-To                         */


/* Function Prototypes. Yuck! */
#ifdef _MINIX
#   include <ansi.h>
#else
#   ifdef _ANSI
#       undef _ANSI
#   endif
#   define _ANSI            0           /* say "not ANSI" at this point     */
#   ifdef __BORLANDC__
#       undef  _ANSI
#       define _ANSI        1           /* Borland C++ is "ANSI" alright..  */
#   endif
#   ifdef __TURBOC__
#       undef  _ANSI
#       define _ANSI        1           /* Borland Turbo C is also "ANSI"   */
#   endif
#   ifdef __STDC__                      /* looks like ANSI...               */
#       if (__STDC__ == 1)
#           undef  _ANSI
#           define _ANSI    1           /* yes, it is ANSI                  */
#       endif
#   endif
#   if _ANSI
#       define _PROTOTYPE(f, p)    f p  /* full ANSI prototyping            */
#   else
#       define _PROTOTYPE(f, p)    f () /* only return-value checking       */
#   endif
#endif

/* In main.c: */
_PROTOTYPE( char *xtime, (time_t *timep)                                    );
_PROTOTYPE( int  vexec, (char *path, char **vec, char *ipath)               );
_PROTOTYPE( int  do_shell, (char *)                                         );

/* In mailrc.c: */
_PROTOTYPE( void rc_read, (char *rc_name)                                   );
_PROTOTYPE( char *rc_alias, (char *name)                                    );

/* In mailbox.c: */
_PROTOTYPE( MSG  *mb_select, (int msgnum)                                   );
_PROTOTYPE( int  mb_rdline, (MSG *msg, char *bufp)                          );
_PROTOTYPE( MBOX *mb_read, (char *name);                                    );
_PROTOTYPE( int  mb_check, (char *name)                                     );
_PROTOTYPE( int  mb_purge, (MBOX *)                                         );

/* In command.c: */
_PROTOTYPE( int  do_cmd, (MBOX *mbox)                                       );
_PROTOTYPE( int  do_prall, (MBOX *mbox)                                     );

/* In signature.c: */
_PROTOTYPE( void signature, (FILE *outfp)                                   );

/* In deadlet.c: */
_PROTOTYPE( void dead_letter, (DRAFT *draft)                                );

/* In pager.c: */
_PROTOTYPE( void pg_msg, (MSG *msg)                                         );

/* In draft.c: */
_PROTOTYPE( DRAFT *mk_draft, (int ask, char *path, char *rcpts[],	    \
			      char *bcc, char *cc, char *sub)               );
_PROTOTYPE( int   ed_draft, (DRAFT *draft)                                  );
_PROTOTYPE( void  rm_draft, (DRAFT *draft)                                  );
_PROTOTYPE( int   cp_draft, (DRAFT *draft)                                  );

/* In edit.c: */
_PROTOTYPE( int do_tilde, (DRAFT *, FILE **, char *)                        );

/* In send.c: */
_PROTOTYPE( int do_send, (DRAFT *draft)                                     );

#endif  /* _WMAIL_H */
