/*
 * W-MAIL       MicroWalt Extended Mail Agent.
 *              This module reads and processes a user's ".signature"
 *		file when sending a message.
 *
 * Author:      Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 *		Copyright 1988-1992 MicroWalt Corporation
 */
#include "wmail.h"


/* Add the ".signature" file to the current message. */
void signature(ofp)
FILE *ofp;
{
  char path[PATH_MAX];
  register FILE *fp;
  register int c;
  char *sp;

  /* See which signature file we must use. */
  if ((sp = getenv("SIGNATURE")) != (char *)NULL) strncpy(path, sp, PATH_MAX);
    else sprintf(path, SIGNATURE, u_home);

  /* Check if the file exists at all. */
  if (access(path, 0) < 0) return;

  /* Open the signature file. */
  if ((fp = fopen(path, "r")) == (FILE *)NULL) {
        perror(path);
        return;
  }

  /* Copy its contents to the message. */
  while ((c = fgetc(fp)) != EOF) fputc(c, ofp);

  /* Close up and return. */
  (void) fflush(ofp);
  (void) fclose(fp);
}
