/*
 * WMAIL        MicroWalt Extended Mail Agent.
 *              Save the current message to file 'dead.letter'.
 *              If the environmental variable "DEADLETTER" is defined,
 *              use its value as the file name. Otherwise, use DEADLETTER
 *              in the current directory. Check if we may write to that file!
 *
 * Author:      Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 *		Copyright 1988-1992 MicroWalt Corporation
 */
#include "wmail.h"


void dead_letter(draft)
DRAFT *draft;
{
  char fname[PATH_MAX];
  register FILE *ifp, *ofp;
  char *sp;
  register int i;

  if ((sp = getenv("DEADLETTER")) != (char *)NULL) strcpy(fname, sp);
    else sprintf(fname, DEADLETTER, u_home);

  /* Open the message file. */
  if ((ifp = fopen(draft->tpath, "r")) == (FILE *)NULL) {
        perror(draft->tpath);
        return;
  }

  /* Create the dump file. */
  if ((ofp = fopen(fname, "a")) == (FILE *)NULL) {
        perror(fname);
        (void) fclose(ifp);
        return;
  }

  /* Copy temporary file to dead.letter. */
  while ((i = fgetc(ifp)) != EOF) fputc(i, ofp);

  (void) fflush(ofp); (void) fclose(ifp);
  (void) fclose(ofp);

  fprintf(stderr, "Dumped message on file \"%s\"\n", fname);
}
