// MSGOBJMS.CPP: module to handle messages

#include <ctype.h>
#include <dos.h>
#include <io.h>
#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef __WINDOWS__
#include <windows.h>
#endif
#include "config.h"
#include "msgobj.h"


// Public functions

int message_frame::post(void)
{
  lasterror=MSGERR_NOERR;
  if(!text)
    {
      lasterror=MSGERR_ENOBUFFER;
      return -1;
    }
  if(open_area()) return -1;
  switch(AREATYPE(area))
    {
      case 0:
        if(pip_msg_post(text,from,to,subject,attributes,fromaddr,toaddr,-1,TEARLINE,ORIGIN(area)))
          return -1;
        break;
      default:
        lasterror=MSGERR_NOTIMPL;
        return -1;
    }
  current_msg=msg_number;
  return 0;
}

int message_frame::modify(void)
{
  lasterror=MSGERR_NOERR;
  if(!text)
    {
      lasterror=MSGERR_ENOBUFFER;
      return -1;
    }
  if(open_area()) return -1;
  if(msg_number<0 || msg_number>this->highest_message())
    {
      lasterror=MSGERR_ENOMSG;
      return -1;
    }
  switch(AREATYPE(area))
    {
      case 0:
        if(pip_msg_post(text,from,to,subject,attributes,fromaddr,toaddr,msg_number,TEARLINE,ORIGIN(area)))
          return -1;
        break;
      default:
        lasterror=MSGERR_NOTIMPL;
        return -1;
    }
  current_msg=msg_number;
  return 0;
}

int message_frame::del(void)
{
  MSGPTR hdr;
  lasterror=MSGERR_NOERR;
  if(msg_number<0 || msg_number>this->highest_message())
    {
      lasterror=MSGERR_ENOMSG;
      return -1;
    }
  if(area==-1)
    {
      lasterror=MSGERR_ENOMSG;
      return -1;
    }
  if(open_area()) return -1;
  switch(AREATYPE(area))
    {
      case 0:
        lseek(fileptr,sizeof(hdr)*msg_number,SEEK_SET);
        ::read(fileptr,&hdr,sizeof(hdr));
        hdr.status|=SET_MPTR_DEL;
        lseek(fileptr,sizeof(hdr)*msg_number,SEEK_SET);
        if (write(fileptr,&hdr,sizeof(hdr))==-1)
          {
            lasterror=MSGERR_ENOWRITE;
            return -1;
          }
        break;
      default:
        lasterror=MSGERR_NOTIMPL;
        return -1;
    }
  return 0;
}

int message_frame::read(int forced)
{
  char dstring[25],huge*z,huge*z2;
  lasterror=MSGERR_NOERR;
  if(msg_number<0 || msg_number>this->highest_message())
    {
      lasterror=MSGERR_ENOMSG;
      return -1;
    }
  if(area==-1)
    {
      lasterror=MSGERR_ENOMSG;
      return -1;
    }
  if(open_area())
    return -1;
  if(current_msg==msg_number && !forced) return 0;
  #ifdef DEBUG
    cout << "Reading message " << msg_number << "\n";
  #endif
  switch(AREATYPE(area))
    {
      case 0:
        if (lseek(fileptr,sizeof(hdr)*msg_number,SEEK_SET)==-1)
          {
            lasterror=MSGERR_ENOSEEK;
            return -1;
          }
        if (::read(fileptr,&hdr,sizeof(hdr))<=0)
          {
            lasterror=MSGERR_ENOREAD;
            return -1;
          }
        lseek(filepkt,hdr.pos,SEEK_SET); 
        ::read(filepkt,&mpkt,sizeof(mpkt));
        read0((unsigned char*)dstring,filepkt,20,1);
        date.parse(dstring);
        read0((unsigned char*)to,filepkt,36,1);
        read0((unsigned char*)from,filepkt,36,1);
        read0((unsigned char*)subject,filepkt,72,1);
        status=hdr.status;
        attributes=mpkt.attribute;
        previous=hdr.prev;
        next=hdr.next;
        current_msg=msg_number;
        cost=times=0; // NOT IMPLEMENTED !!!!!!!!!!!!!!!!!!!!
        if(text)
          {
            switch(mpkt.pktype)
              {
                case 2:
                read0((unsigned char*)text,filepkt,textsize-256,1);
                break;
              case 10:
                unpipfile((unsigned char*)text,filepkt);
                break;
              default:
                return -1;
              }
            if(*AREATAG(area)=='#')
              {
                if(stricmp(AREATAG(area),"#NETMAIL"))
                  {
                    fromaddr.zone=toaddr.zone=MYZONE;
                    fromaddr.net=toaddr.net=MYNET;
                    fromaddr.node=toaddr.node=MYNODE;
                    fromaddr.point=toaddr.point=MYPOINT;
                    strcpy(fromaddr.domain,MYDOMAIN);
                    strcpy(toaddr.domain,MYDOMAIN);
                    strcpy(fromaddr.uucp,"");
                    strcpy(toaddr.uucp,"");
                  }
                else
                  {
                    fromaddr.net=mpkt.fromnet;
                    fromaddr.node=mpkt.fromnode;
                    toaddr.net=mpkt.tonet;
                    toaddr.node=mpkt.tonode;
                    strcpy(fromaddr.domain,MYDOMAIN);
                    strcpy(toaddr.domain,MYDOMAIN);
                    strcpy(fromaddr.uucp,"");
                    strcpy(toaddr.uucp,"");
                    if((z=strstr(text,"\1TOPT "))!=NULL)
                      toaddr.point=atoi(z+6);
                    else
                      toaddr.point=0;
                    if((z=strstr(text,"\1FMPT "))!=NULL)
                      fromaddr.point=atoi(z+6);
                    else
                      fromaddr.point=0;
                    if((z=strstr(text,"\1INTL "))!=NULL)
                      {
                        fromaddr.zone=atoi(strstr(z+6," ")+1);
                        toaddr.zone=atoi(z+6);
                      }
                    else
                      fromaddr.zone=toaddr.zone=MYZONE;
                    if(!stricmp(from,"UUCP"))
                      fromaddr.parse_uucp(text,from,"From: ");
                    if(!stricmp(to,"UUCP"))
                      toaddr.parse_uucp(text,to,"To: ");
                  }
              }
            else
              {
                fromaddr.zone=toaddr.zone=MYZONE;
                fromaddr.net=toaddr.net=MYNET;
                fromaddr.node=toaddr.node=MYNODE;
                fromaddr.point=toaddr.point=MYPOINT;
                strcpy(fromaddr.domain,MYDOMAIN);
                strcpy(toaddr.domain,MYDOMAIN);
                strcpy(fromaddr.uucp,"");
                strcpy(toaddr.uucp,"");
                if((z=strchr(text,'('))!=NULL)
                  {
                    while((z2=strchr(z,'('))!=NULL)
                      z=z2+1;
                    z2=z;
                    while(!isdigit(*z) && (*z!='@')) z++;
                    if(isdigit(*z))
                      fromaddr.parse(z);
                  }
              }
          }  
        break;
      default:
        lasterror=MSGERR_NOTIMPL;
        return -1;
    }
  #ifdef DEBUG
    cout << "Message read\n";
  #endif
  return 0;
}

int message_frame::allocate_text(long l)
{
  lasterror=MSGERR_NOERR;
  if(text) return 0;
  #ifdef __WINDOWS__
    {
      textSelector=GlobalAlloc(GMEM_FIXED,l);
      if(textSelector==NULL)
        text=NULL;
      else
        text=GlobalLock(textSelector);
    }
  #else
    text=(char huge*)malloc(l);
  #endif
  if(text)
    {
      textsize=l;
      return 0;
    }
  textsize=0;
  lasterror=MSGERR_ENOMEM;
  return -1;
}

int message_frame::deallocate_text(void)
{
  lasterror=MSGERR_NOERR;
  if(!text)
    {
      lasterror=MSGERR_ENOBUFFER;
      return -1;
    }
  #ifdef __WINDOWS__
    GlobalUnlock(textSelector);
    GlobalFree(textSelector);
  #else
    free(text);
  #endif
  textsize=0;
  return 0;
}

int message_frame::isolate_seen_by(AUDIT*seen_by,int&ns,int tots,AUDIT*path,int&np,int totp)
{
  if(open_area()) return -1;
  int i;
  char huge*p,huge*p2;
  uint t;
  memset(seen_by,0,tots*sizeof(AUDIT));
  i=0; ns=0; np=0;
  p2=find_origin(text);
  if(p2==NULL)
    {
      strcat(text,TEARLINE);
      strcat(text,"\r");
      sprintf(fn," * Origin: Origin not found: Abort? Retry? Ignore? (%d:%d/%d.%d)\r",
              MYZONE,MYNET,MYNODE,MYPOINT);
      strcat(text,fn);
      return 0;
    }
  if((p=strstr(p2,"SEEN-BY:"))!=NULL)
    {
      i=0;
      *p=0; // elimina seen-by e path per l'export
      p+=8;
      if(*p==' ') p++;
      while (p)
        {
          if (*p=='.')
            {
              if (i)
                {seen_by[i].net=seen_by[i-1].net; seen_by[i].node=seen_by[i-1].node;}
              else
                {seen_by[i].net=MYNET; seen_by[i].node=MYNODE;}
              seen_by[i].point=atoi(p+1);
              ns++; i++;
            }
          else
            if (*p>32)
              {
                t=atoi(p); while (isdigit(*p)) p++;
                if (*p=='/')
                  {seen_by[i].net=t; seen_by[i].node=atoi(++p); while(isdigit(*p)) p++;}
                else
                  {seen_by[i].net=seen_by[i-1].net; seen_by[i].node=t; while(isdigit(*p)) p++;}
                if (*p=='.')
                  seen_by[i].point=atoi(p);
                else
                  seen_by[i].point=0;
                ns++; i++;
              }
          p=strchr(p,' '); if (p) p++;
        }
    }
  memset(path,0,totp*sizeof(AUDIT));
  i=0;
  if ((p=strstr((signed char*)p2,"\1PATH:"))!=NULL)
    {
      p+=6;
      if(*p==' ') p++;
      while (p)
        {
          if (*p=='.')
            {
              if (i)
                {path[i].net=path[i-1].net; path[i].node=path[i-1].node;}
              else
                {path[i].net=MYNET; path[i].node=MYNODE;}
              path[i].point=atoi(p+1);
            }
          else
            if (*p>32)
              {
                t=atoi(p); while (isdigit(*p)) p++;
                if (*p=='/')
                  {path[i].net=t; path[i].node=atoi(++p); while(isdigit(*p)) p++;}
                else
                  {path[i].net=path[i-1].net; path[i].node=t; while(isdigit(*p)) p++;}
                if (*p=='.')
                  path[i].point=atoi(p);
                else
                  path[i].point=0;
              }
          p=strchr(p,' '); if (p) p++;
          i++;
        }
    }
  np=i;
  if(!cfg.fakenet)
    {
      if (not_in_seen_by(seen_by,MYNET,MYNODE,MYPOINT,tots))
        {
          seen_by[ns].net=MYNET;
          seen_by[ns].node=MYNODE;
          seen_by[ns].point=MYPOINT;
          ns++;
        }
      path[np].net=MYNET;
      path[np].node=MYNODE;
      path[np].point=MYPOINT;
    }
  else
    {
      if (not_in_seen_by(seen_by,MYFAKENET,MYPOINT,0,tots))
        {
          seen_by[ns].net=MYFAKENET;
          seen_by[ns].node=MYPOINT;
          seen_by[ns].point=0;
          ns++;
        }
      path[np].net=MYFAKENET;
      path[np].node=MYPOINT;
      path[np].point=0;
    }
  np++;
  return 0;
}

int message_frame::highest_message(void)
{
  lasterror=MSGERR_NOERR;
  open_area();
  if(current_area==-1)
    return -1;
  else
    switch(AREATYPE(area))
      {
        case 0:
          return filelength(fileptr)/sizeof(MSGPTR)-1;
        default:
          lasterror=MSGERR_NOTIMPL;
          return -1;
      }
}

int message_frame::total_messages(void)
{
  open_area();
  lasterror=MSGERR_NOERR;
  if(current_area==-1)
    return -1;
  else
    switch(AREATYPE(area))
      {
        case 0:
          return filelength(fileptr)/sizeof(MSGPTR);
        default:
          lasterror=MSGERR_NOTIMPL;
          return -1;
      }
}

message_frame::message_frame(void)
{
  current_area=area=-1;
  current_msg=msg_number=-1;
  attributes=status=0;
  cost=times=0;
  previous=next=0;
  text=NULL;
  textsize=0;
  lasterror=MSGERR_NOERR;
  // other fields are automatically zeroed by their constructors
}

message_frame::~message_frame(void)
{
  if(text)
    #ifdef __WINDOWS__
      GlobalDosFree(textSelector);
    #else
      free(text);
    #endif
  close_area();
}
