// SMALLPOS.CPP: a little message sender

#include <conio.h>
#include <ctype.h>
#include <fstream.h>
#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define MAIN
#include "pipbase.h"
#include "pipreply.h"
#include "pipext.h"
#include "config.h"
#include "msgobj.h"


void main(int argc,char *argv[])
{
  FILE *f;
  int msgnum,k,i;
  char fn[72],*p;
  char huge*o;
  if(argc!=9 && argc!=5)
    {
      cerr << "usage: SMALLPOST area# filename.ext \"destname\" \"subject\" zone net node point\n";
      exit(1);
    }
  // reads PIP* 2.00 configuration files
  f=fopen("NodeInfo.Cfg","rb");
  if(!f)
    {
      cerr << "I cannot find NodeInfo.Cfg\nplease create it with PIP SET\n";
      exit(1);
    }
  fread(&cfg,sizeof cfg,1,f);
  fclose(f);
  sprintf(fn,"%sOrigins.Pip",cfg.pipdir); f=fopen(fn,"rb");
  if (f==NULL)
    {
      cerr << "I cannot locate the PipBase files; please check for " << fn << "\n";
      exit(1);
    }
  o=(char*)malloc(60*256);
  if(o==NULL)
    {
      cerr << "Not enough memory!\n";
      exit(1);
    }
  fread(o,60*256,1,f); fclose(f);
  for(i=0; i!=256;i++) origins[i]=o+60*i;
  // allocate MessageObject
  message_frame msg;
  // operations to be done if you want to send a message:
  // set message area
  msg.area=atoi(argv[1]);
  // allocate text
  if(msg.allocate_text(BUFSIZE))
    {
      cerr << "Allocation error\n";
      exit(1);
    }
  // readfile is only an useful function, generally, you'll have to place
  // your message text in the buffer pointed by msg.text
  if(msg.readfile((unsigned char huge*)msg.text,argv[2]))
    {
      cerr << "input file not found!\n";
      exit(1);
    }
  // load header informations
  strcpy(msg.from,cfg.usernames[0]);
  strcpy(msg.to,argv[3]);
  strcpy(msg.subject,argv[4]);
  *msg.fromaddr.uucp=0;
  *msg.toaddr.uucp=0;
  strcpy(msg.fromaddr.domain,cfg.address[0].domain);
  msg.fromaddr.zone=cfg.address[0].zone;
  msg.fromaddr.net=cfg.address[0].net;
  msg.fromaddr.node=cfg.address[0].node;
  msg.fromaddr.point=cfg.address[0].point;
  strcpy(msg.toaddr.domain,cfg.address[0].domain);
  if(argc==9)
    {
      msg.toaddr.zone=atoi(argv[5]);
      msg.toaddr.net=atoi(argv[6]);
      msg.toaddr.node=atoi(argv[7]);
      msg.toaddr.point=atoi(argv[8]);
    }
  else
    msg.toaddr=msg.fromaddr;
  // finally, call msg.post();
  msg.post();
}
