// SMALLPIP.CPP: a little message reader

#include <conio.h>
#include <ctype.h>
#include <fstream.h>
#include <iostream.h>
#include <alloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define MAIN
#include "pipbase.h"
#include "pipreply.h"
#include "pipext.h"
#include "config.h"
#include "msgobj.h"


void main(int argc,char *argv[])
{
  FILE *f;
  int msgnum,k;
  char fn[72],*p;
  if(argc!=2)
    {
      cerr << "usage: SMALLPIP area#\n";
      exit(1);
    }
  // reads configuration files created by PipBase/Gimme-a-Point/PipSetup/Pip*
  f=fopen("NodeInfo.Cfg","rb");
  if(!f)
    {
      cerr << "I cannot find NodeInfo.Cfg\nplease create it with PIP SET\n";
      exit(1);
    }
  fread(&cfg,sizeof cfg,1,f);
  fclose(f);
  // allocates a message object
  message_frame msg;
  // sets message area
  msg.area=atoi(argv[1]);
  // allocates a buffer for message text
  if (coreleft()<24000)
    {
      cerr << "Not enough memory!\n";
      exit(1);
    }
  if(msg.allocate_text((coreleft()>BUFSIZE+20000)?BUFSIZE:(coreleft()-20000)))
    {
      cerr << "Allocation error\n";
      exit(1);
    }
  cout << "Message buffer: " << msg.textsize << " bytes\n";
  // opens lastread pointers (this operation is not currently implemented in
  // MessageObject
  sprintf(fn,"%sLastRead.Pip",cfg.pipdir);
  f=fopen(fn,"rb");
  fseek(f,msg.area*sizeof(msgnum),SEEK_SET);
  fread(&msgnum,sizeof msgnum,1,f);
  fclose(f);
  cout << "lastread=" << msgnum << "\n";
  k=0;
  while(k!=27)
    {
      // to read a message, assign msg.area and msg.msg_number...
      msg.msg_number=msgnum;
      // ... and then issue a msg.read();
      if(msg.read())
        {
          cout << "Problems in accessing message #" << msgnum << " (" << msg.lasterror << ")\n";
          cout << "msg.area=" << msg.area << " msg.msg_number=" << msg.msg_number << "\n";
        }
      else
        {
          // prints message header
          cout << "Message # " << msgnum << "\n";
          msg.fromaddr.pack(fn);
          cout << "From: " << msg.from << " (" << fn << ")\n";
          msg.toaddr.pack(fn);
          cout << "To:   " << msg.to << " (" << fn << ")\n";
          cout << "Subj: " << msg.subject << "\n";
          // msg.text is stored as-is: a little operations are required to
          // restore LineFeeds, skip kludges, etc.
          p=msg.text;
          while(*p)
            {
              switch((unsigned char)*p)
                {
                  case 1:
                    while(*(p+1) && (*(p+1)!=10) && (*(p+1)!=13) && ((unsigned char)*(p+1)!=141))
                      p++;
                    break;
                  case 10:
                  case 13:
                  case 141:
                    cout << "\n";
                    break;
                  default:
                    cout << *p;
                }
              p++;
            }
        }
      // nothing particular...
      cout << "Command? Esc=quit; -=previous; +=Next; R=repeat >";
      k=toupper(getch());
      cout << "\n";
      switch(k)
        {
          case '+':
            if(msgnum<msg.highest_message())
              msgnum++;
            else
              {
                cout << "Messages ended.\n";
                k=27;
              }
            break;
          case '-':
            if(msgnum) msgnum--;
            break;
          case 'R':
            break;
        }
    }
  sprintf(fn,"%sLastRead.Pip",cfg.pipdir);
  f=fopen(fn,"rb+");
  fseek(f,msg.area*sizeof(msgnum),SEEK_SET);
  fwrite(&msgnum,sizeof msgnum,1,f);
  fclose(f);
  // files used by MessageObject are closed automatically by
  // message_frame::~message_frame (the destructor)
}
