/* PipBase.H: this file contains all data structure definition and 
notes on how to manage them. All PipBase-compatible programs have to 
refer to these informations */

/* data alignment is on bytes */
/* int (and uint) are 16 bits integers, LSB first */

#pragma pack(1)

/* something about file names and location:

In your main directory there is the file NODEINFO.CFG, that holds all
general informations: it's an unique record of type NODEINFO.

In another directory (well, it may be the same of NodeInfo.Cfg), the
so-called pipbase directory, there are:

ORIGINS.PIP:  a file containing 256 char[60] null-terminated strings: your
              origins. (*)

BASEDESC.PIP: a file of records of the type AREASTRUCT, containing the area
              definitions. (*)

DESTPTR.PIP:  a file of DESTPTR type records. (*)

LASTREAD.PIP: a file of 8 or more tables of <cfg.model> integers each.
              First 8 records are for the sysops indicated in NODEINFO.CFG;
              following entries can be used for BBS users. (*)

MPTRxxxx.PIP, where xxxx is an hexadecimal number: a file of records of type
              MSGPTR, indexing area xxxx. (*)

MPKTxxxx.PIP, where xxxx is an hexadecimal number: a file of packed
              messages, each formed by a MSGPKTHDR record and five
              null-terminated strings; the file is terminated by a double
              null (that, with the terminator of the last string, forms a
              three-zeroes sequence); it contains area xxxx texts;
              the five null'terminated strings are the to, from, subj,
              date and text fields of the standard FTS-0001 packets. (*)

FRIENDND.PIP: a file of FRIENDND type records, each of whom has an entry in
              the forward_to bitmap of BASEDESC.PIP.
              Notice that not all forward_to entries has to be assigned to a
              record: a point does not need a large FRIENDND!

ROUTE.PIP:    a file of ROUTE records, containing informations on how to
              route netmail 

Only files marked with an (*) are the pipbase standard. Other files are used
by PipBase.Exe and PipSetup, but you may change them (and, if possible, inform
the authors of these changes).

*/


typedef unsigned int uint;


typedef struct /* structure of the message headers in MPKTxxxx.PIP files */
               { uint pktype; /* 2= not compressed; 10=compressed with PIP */
                 uint fromnode,tonode,fromnet,tonet; /* for netmail */
                 uint attribute; /* bit 0=private as for SeaDog,
                                        1=crash as for SeaDog,
                                        2=received as for SeaDog,
                                        3=sent as for SeaDog,
                                        4=fileattach as for SeaDog,
                                        5=in transit as for SeaDog,
                                        7=kill/sent as for SeaDog,
                                        8=local as for SeaDog,
                                        9=hold as for SeaDog,
                                        10=locked,
                                        11=filerequest as for SeaDog,
                                        12=Return Receipt request,
                                        13=Is Return Receipt,
                                        14=Audit Request,
                                        15=fileupdaterequest as for SeaDog */
                                /* when echomail, bit 3=1 means "processed"; */
                 uint point; /* FMPT for inbound messages, TOPT for outbound messages */
               } MSGPKTHDR;

#define SET_PKT_PRIV 1
#define SET_PKT_CRASH 2
#define SET_PKT_RCVD 4
#define SET_PKT_SENT 8
#define SET_PKT_ATTACH 16
#define SET_PKT_TRANSIT 32
#define SET_PKT_KILL 128
#define SET_PKT_LOCAL 256
#define SET_PKT_HOLD 512
#define SET_PKT_LOCK 1024
#define SET_PKT_REQUEST 2048
#define SET_PKT_RRRQ 4096
#define SET_PKT_ISRR 8192
#define SET_PKT_AUDIT 16384
#define SET_PKT_UPDATE 32768
#define RESET_PKT_PRIV 0xfffe
#define RESET_PKT_CRASH 0xfffd
#define RESET_PKT_RCVD 0xfffb
#define RESET_PKT_SENT 0xfff7
#define RESET_PKT_ATTACH 0xffef
#define RESET_PKT_TRANSIT 0xffdf
#define RESET_PKT_KILL 0xff7f
#define RESET_PKT_LOCAL 0xfeff
#define RESET_PKT_HOLD 0xfdff
#define RESET_PKT_LOCK 0xfbff
#define RESET_PKT_REQUEST 0xf7ff
#define RESET_PKT_RRRQ 0xefff
#define RESET_PKT_ISRR 0xdff
#define RESET_PKT_AUDIT 0xbfff
#define RESET_PKT_UPDATE 0x7fff

#define SEADOG_MASK 0x7413


typedef struct /* structure of each record in MPTRxxxx.PIP files */
               { long pos;       /* pointer to MPKTxxxx.PIP */
                 uint prev,next;  /* pointers to other records in MPTRxxxx */
                 uint status;     /* bit 0=deleted 1=received 2=sent */
                                  /* 3=fromus(1)/tous(0) 4=Locked (Undeletable) */
               } MSGPTR;

#define SET_MPTR_DEL 1
#define SET_MPTR_RCVD 2
#define SET_MPTR_SENT 4
#define SET_MPTR_FROMUS 8
#define SET_MPTR_LOCK 16
#define RESET_MPTR_DEL 0xfffe
#define RESET_MPTR_RECV 0xfffd
#define RESET_MPTR_SENT 0xfffb
#define RESET_MPTR_FROMUS 0xfff7
#define RESET_MPTR_LOCK 0xfffef


typedef struct /* structure of each record in DESTPTR.PIP */
               { char to[36]; /* addressee name */
                 uint area,msg; /* pointers to MPTRarea.PIP records */
                 long next; /* to speed up search (in future: NOT YET IMPLEMENTED) */
               } DESTPTR;


typedef struct /* structure of addresses in NODEINFO.CFG */
               { uint zone,net,node,point;
                 char domain[20];
               } NODEADDR;


typedef struct /* structure of the unique record NODEINFO.CFG */
               { NODEADDR address[10]; /* network addresses */
                 uint fakenet; /* pointnet address, DON'T USE IT IF POSSIBLE */
                 char logfilename[64], /* Location of log file, NUL for none */
                      loglevel, /* 0...3, from less to more detailed */
                      logtype; /* 0: Opus/Binkley; 1: Frodo/D'Bridge */
                 char pipdir[64]; /* where PIPbase files are located, slash terminated */
                 uint pipsize; /* how many messages areas have you? */
                               /* 256=SMALL, 1024=MEDIUM, 4096=LARGE, 32768=EXTRA-LARGE */
                 char usernames[8][35]; /* names of sysops accessing the system */
                 char inbound[64],outbound[64]; /* inbound and outbound directories */
                 char packerdir[64],tempdir[64];
                 char compact; /* bit 0: remove unuseful kludges 
                                  bit 1: remove Re:
                                  bit 2: remove 4D-informations
                                  bit 3: kill robot received messages
                                  bit 4: kill sent robot messages 
                                  bit 5: don't put ^aREPLY 
                                  bit 6: don't put domain in MSGIDs */
                 char packer[13],packerparms[40]; /* default packer */
                 char attaches[64]; /* where Netmail fileattaches are stored */
                 char attachstyle; /* 0=Pip!, 1=Frodo/D'B, 2=Bink/TrapDoor */
                 char pack_matrix; /* 0=dynamic packing; 1=matrix is packed but not compressed; 2= matrix is packed and compressed */
                                   /* with Binkley and Pip! mode 0 is illegal */
                 char addtear[20]; /* add this string to the regular tearline */
                 char receipt[64]; /* file for return receipt */
                 char ghost[35];   /* name for Ghost Writer */
                 char use_uucp;    /* use UUCP gateway to access internet */
                 uint uucp_out_zone, /* bit 0: gateway enabled */
                      uucp_out_net,  /* bit 1: use ghostwriter also in UUCP */
                      uucp_out_node,
                      uucp_in_zone,
                      uucp_in_net,
                      uucp_in_node;
                 char create_new_areas; /* create new areas if this is 1 */
                 char compat_box[13]; /* to be compatible with precedent versions */
                 char fast_export; /* to flag as sent just imported messages */
                 char route_crash_via_boss; /* to route crashmail addressed to points */
                 char key[22];     /* THE REGISTRATION KEY; leave 0 if not used */
                 char jolly[13],jollyparms[40]; /* The jolly unpacker */
               } NODEINFO;

#define SET_COMPACT_REMOVE_KLUDGES 1
#define RESET_COMPACT_REMOVE_KLUDGES 0xfffe
#define SET_COMPACT_REMOVE_REPLY 2
#define RESET_COMPACT_REMOVE_REPLY 0xfffd
#define SET_COMPACT_REMOVE_4D 4
#define RESET_COMPACT_REMOVE_4D 0xfffb
#define SET_COMPACT_KILLROBOTRQ 8
#define RESET_COMPACT_KILLROBOTRQ 0xfff7
#define SET_COMPACT_KILLROBOTASW 16
#define RESET_COMPACT_KILLROBOTASW 0xffef
#define SET_COMPACT_NOREPLY 32
#define RESET_COMPACT_NOREPLY 0xffdf
#define SET_COMPACT_NODOMAIN_MSGID 64
#define RESET_COMPACT_NODOMAIN_MSGID 0xffbf

#define SET_UUCP 1
#define SET_UUCP_GHOST 2


typedef struct /* structure for each record of BASEDESC.PIP */
               { char descr[40], /* description of the area */
                      tag[30]; /* echomail tag, #LOCAL, #BAD,#DUPES or #NETMAIL */
                 uint nrmsgs,days; /* to perform PURGE; nrmsgs=0: passthru area */
                 unsigned char killrcv, /* kill received messages? */
                      readlevel,readflags[4],writelevel,writeflags[4], /* for Remote Access style access control */
                      origin, address, /* index for the appropriate table */
                      note[80], /* whatever you want */
                      forward_to[32]; /* this is a bitmap on FRIENDND.PIP's 256 records */
                 char origmode; /* 0=fixed origin; 1=random system; 2=cyclic system */
                 int startorig,endorig; /* for random or cyclic origin selection */
                 long inmsgmonth,inmsgyear; /* for statistics */
                 long outmsgmonth,outmsgyear; /* for statistics */
                 char expansion_box[36]; /* please apply to define this */
               } AREASTRUCT;


typedef struct /* structure for each record in FRIENDND.PIP */
               { uint zone,net,node,point; /* address */
                 char packer[13], /* the .exe or .com file to run packer */
                      packerparms[40], /* parameters to be passed */
                      packet_pw[8]; /* packet password */
                 long inmsgmonth,inmsgyear; /* for statistics */
                 long outmsgmonth,outmsgyear; /* for statistics */
                 char unused; /* reserved for future use */
                 char areafix_pw[25]; /* Areafix Password */
                 uint areafix_lev;
                 uint flags; /* bit 0=uses PipMail; 
                                bit 1=active(1)/inactive(0);
                                bit 2=deleted;
                                bit 3=hold 
                                bit 4=crash */
                 char notes[80]; /* whatever you want */
               } FRIENDND;

#define FRI_SET_PIPMAIL 1
#define FRI_RESET_PIPMAIL 0xfffe
#define FRI_SET_ACTIVE 2
#define FRI_RESET_ACTIVE 0xfffd
#define FRI_SET_DEL 4
#define FRI_RESET_DEL 0xfffb
#define FRI_SET_HOLD 8
#define FRI_RESET_HOLD 0xfff7
#define FRI_SET_CRASH 16
#define FRI_RESET_CRASH 0xffef


typedef struct {
                 unsigned int
                      orig_node,               /* originating node */
                      dest_node,               /* destination node */
                      year,                    /* 1990 - nnnn */
                      month,                   /* month -1 */
                      day,                     
                      hour,
                      minute,
                      second,
                      rate,                    /* unused */
                      ver,                     /* 2 */
                      orig_net,                /* originating net */
                      dest_net;                /* destination net */
                 unsigned char
                      product,                 /* product code */
                      rev_lev,                 /* revision level */
                      password[8];
                 unsigned int
                      qm_orig_zone,            /* QMail orig.zone */
                      qm_dest_zone,            /* QMail dest.zone */
                      wm_orig_point,           /* Wmail orig.point */
                      wm_dest_point;           /* Wmail dest.point */
                 unsigned char
                      TRASH[4];                /* junk[4] */
                 unsigned int
                      orig_zone,               /* originating zone */
                      dest_zone,               /* destination zone */
                      orig_point,              /* originating point */
                      dest_point;              /* destination point */
                 unsigned long
                      pr_data;
                 } MAILPKT;


typedef struct {
                 unsigned char fromwho[36],towho[36],subj[72],date[20];
                 uint times,
                      destnode,orignode,
                      cost,
                      orignet,destnet,
                      destzone,origzone,
                      destpoint,origpoint,
                      reply,attr,nextreply;
               } FIDOMSG;


typedef struct /* structure of each record in ROUTE.PIP */
               {
                 unsigned char mode; /* see table below */
                 unsigned char via; /* pointer to a friend node */
                 uint zone,net,node,point;
               } ROUTE;
/* mode can be one of following values:
0: route all exported matrix via the specified friend
   (zone,net,node and point fields are ignored)
1: route all the specified zone via the friend
   (net,node and point fields are ignored)
2: route all the specified region via the friend
   (last digit of net number, node and point fields are ignored)
3: route all the specified net via the friend
   (node and point fields are ignored)
4: route all the hub via the friend
   (last two digits of the node field and the point field are ignored)
5: route the node and all his points via the friend
   (point field is ignored)
6: route that point via that friend

If not specified:
- a point routes all his mail via his boss
- a boss routes all his mail via his hub (we maded the asumption that
  the hub of BBS xxx/yyzz has always node number xxx/yy00) or directly
  to his points.
- a hub (or a node without a hub) routes all his mail via the network
  coordinator, or sends it directly to his subnodes
- a host routes all his mail via the other network coordinators, or
  via the hubs if they're defined, or via a zonegate, or to his
  subnodes
- all mail for points is always routed via their boss
- all mail for defined friends is sent directly
*/

#define ROUTE_ALL 0
#define ROUTE_ZONE 1
#define ROUTE_REGION 2
#define ROUTE_NET 3
#define ROUTE_HUB 4
#define ROUTE_NODE 5
#define ROUTE_POINT 6


typedef struct { /* an unique record in SYSTEM.CFG */
                 unsigned char port, /* modem port, following fossil, 0-based, 
                                        numbering; 255=no modem (useful for 
                                        testing, demonstration, LAN, floppynet,
                                        and if you're using Pip! only for 
                                        making coffee, with the proper 
                                        hardware) */
                               speed; /* bit 7=lockbaud; bit 6=MX5 is used;
                                         bit 5=null-modem link;
                                         others=speed, following fossil coding */
                 char okstring[20], /* default= OK; in all strings, | means cr and ~ means wait */
                      nocarrier[20], /* default=NO CARRIER */
                      busy[20], /* default is BUSY used only with ATX4 responses */
                      voice[20], /* default=VOICE used only with ATX4 responses */
                      init[3][40], /* including AT, but not the final CR; default is "ATS0=1Q0V1X1","",""*/
                      deinit[40], /* default=ATS0=0 */
                      answer[40], /* default=ATA */
                      ringing[20], /* default=RING; R.I. signal on line is not monitored */
                      reliable[3][20], /* when line is reliable; defaults are "MNP","REL" and "HST" */
                      halfduplex[3][20], /* when bidirectional protocols are not avaible; defaults are "HST","1275" and "7512" */
                      connect[10][20], /* defaults are CONNECT\r, CONNECT 1200, CONNECT 2400, CONNECT 9600, CONNECT 14400, CONNECT 19200, CONNECT 38K, CONNECT 1275, CONNECT 7512 */
                      error[20], /* default is ERROR */
                      busy_in[40], /* default is ATH1 */
                      busy_out[40], /* ATH0 */
                      whenbusy, /* bit 0=busy when shelling (deafult 0), 1=DTR off when shelling(1); 2=busy when exiting(0), 3=DTR off when exiting(1)*/
                      answer_timeout, /* in seconds; default=40 */
                      busy_retries, voice_retries, nocarrier_retries, /* number of retries alloweed; default=2 for voice, 10 for nocarrier and 20 for busy */
                      retry_timeout, /* default=12 tens of seconds */                      
                      dial_prefix[20], /* usually ATD */
                      dial_suffix[20], /* usually "" */
                      pre_dial[20], /* usually "" */
                      terminit[40], /* usually ATS0=0E1 */
                      modem_expansion[300],
                      scrlines, /* lines on screen; usually 25, it may be 25 (CGA/Hercules), 43 (EGA) or 50 (VGA) */ 
                      monitor, /* bit 0=no snow; bit 1=monochrome monitor */
                      screen_expansion[100],
                      system_name[40], /* site info: BBS Name */
                      location[40], /* location */
                      telephone[40], /* telephone number */
                      site_exp[500],
                      banner[80], /* this is sent, follwed by a \r\n, when the
                                     modem answers the call; You may place a #
                                     followed by a complete filename to have
                                     that text file sent */
                      human[80], /* This is displayed when passing to BBS (you
                                    may use the # also here */
                      mailonly[80]; /* sent to the user when in mail only event */
               } MAILERCFG;  

typedef struct {uint net,node,point;} AUDIT;

#ifndef BUFSIZE
  #define BUFSIZE 30000
#endif

#define NODEADDRDEF
