// MSGOBJ: classes for message handling
#ifndef NODEADDRDEF
  #include "pipbase.h"
#endif

// You need the following macros defined for interfacing MessageObject
// with your configuration files
// AREATYPE(area_number)  : 0 for Pip, 1 for Quick, 2 for fido
// AREAPATH(area_number)  : msgbase (or area) path; backslash terminated
// AREATAG(area_number)   : char* to the area echotag (#NETMAIL for netmail
//                          or #LOCAL for local)
// MYZONE   : address of the node where MSGOBJ is running
// MYNET    :
// MYNODE   :
// MYDOMAIN :
// MYFAKENET: (0 if no fakenet is used
// BUFSIZE  : the size of your text buffer, in bytes (30000 is good)
// TEARLINE : your tearline

// default definitions are for Pip* 2.0

#ifndef AREATYPE
  #define AREATYPE(a) 0
#endif

#ifndef AREAPATH
  #ifndef PIPVARS
    #include "pipext.h"
  #endif
  #define AREAPATH(a) cfg.pipdir
#endif

#ifndef AREATAG
  #ifndef VIRTUAL_AREAS
    #include "areas.h"
  #endif
  #define AREATAG(a) (areas(a)->tag)
#endif

#ifndef MYZONE
  #ifndef PIPVARS
    #include "pipext.h"
  #endif
  #ifndef VIRTUAL_AREAS
    #include "areas.h"
  #endif
  #define MYZONE (cfg.address[areas(area)->address].zone)
#endif

#ifndef MYNET
  #ifndef PIPVARS
    #include "pipext.h"
  #endif
  #ifndef VIRTUAL_AREAS
    #include "areas.h"
  #endif
  #define MYNET (cfg.address[areas(area)->address].net)
#endif

#ifndef MYNODE
  #ifndef PIPVARS
    #include "pipext.h"
  #endif
  #ifndef VIRTUAL_AREAS
    #include "areas.h"
  #endif
  #define MYNODE (cfg.address[areas(area)->address].node)
#endif

#ifndef MYPOINT
  #ifndef PIPVARS
    #include "pipext.h"
  #endif
  #ifndef VIRTUAL_AREAS
    #include "areas.h"
  #endif
  #define MYPOINT (cfg.address[areas(area)->address].point)
#endif

#ifndef MYDOMAIN
  #ifndef PIPVARS
    #include "pipext.h"
  #endif
  #ifndef VIRTUAL_AREAS
    #include "areas.h"
  #endif
  #define MYDOMAIN (cfg.address[areas(area)->address].domain)
#endif

#ifndef MYFAKENET
  #ifndef PIPVARS
    #include "pipext.h"
  #endif
  #define MYFAKENET (cfg.fakenet)
#endif

#ifndef UUCPZONE
  #ifndef PIPVARS
    #include "pipext.h"
  #endif
  #define UUCPZONE (cfg.uucp_out_zone)
#endif
  

#ifndef UUCPNET
  #ifndef PIPVARS
    #include "pipext.h"
  #endif
  #define UUCPNET (cfg.uucp_out_net)
#endif
  

#ifndef UUCPNODE
  #ifndef PIPVARS
    #include "pipext.h"
  #endif
  #define UUCPNODE (cfg.uucp_out_node)
#endif
  

#ifndef TEARLINE
  #ifndef PIPVERSION
    #include "version.h"
  #endif
  #define TEARLINE "Pip*"
#endif


#ifndef ORIGIN
  #ifndef PIPVARS
    #include "pipext.h"
  #endif
  #ifndef VIRTUAL_AREAS
    #include "areas.h"
  #endif
  #define ORIGIN(a) (origins[areas(a)->origin])
#endif


#ifndef BUFSIZE
  #define BUFSIZE 30000
#endif

// address_class is a class for fidonet and internet addresses

class address_class
  {
    friend message_frame;
    public:
      // finds an UUCP address in a netmail message
      int parse_uucp(char*,char*,char*);
      // datas for fidonet addresses
      // zeroes if the address is a pure internet address
      int zone,net,node,point;
      char domain[20];
      // string for uucp addresses; blank if address is pure fidonet
      char uucp[80];
      // parses the string and unpacks it into address fields;
      // returns 0 if successful or -1 otherwise
      int parse(char*);
      // packs the address into a string;
      // returns 0 if successful or -1 otherwise
      int pack(char*);
      address_class(void);
      ~address_class(void);
  };


class date_time_class
  {
    friend message_frame;
    public:
      // date fields: day, month, year
      int day,month,year;
      // time values: hour, minute, seconds
      int hour,minutes,seconds;
      // parses a  fidonet date (expressed as a string)
      // the date string contains also an hour
      int parse(char*);
      // packs the fields into a FTS-0001 date time
      // returns 0 if successful or -1 otherwise
      int pack(char*);
      date_time_class(void);
      ~date_time_class(void);
  };

// IMPORTANT NOTICE: all pointers to message test are huge, to handle 
// messages longer than 64 Kb

class message_frame
  {
    // these values are used to handle buffers and dynamic file opening
    int current_area,current_msg;
    // internally used functions
    int open_area(void);
    int close_area(void);
    int pip_msg_post(char huge *,char*,char*,char*,unsigned int,address_class,address_class,int,char*,char*);
    int not_in_seen_by(AUDIT *,unsigned int,unsigned int,unsigned int,int);
    int fileptr,filepkt,filedest;
    char fname[72];
    MSGPKTHDR mpkt;
    MSGPTR hdr;
    #ifdef WIN
      unsigned int textSelector;
    #endif
    public:
      // error code of the last operation
      int lasterror;
      // compresses a string to a file
      // the file has to be opened in binary modeo
      void pipstring(unsigned char huge*,int);
      // decompresses a compressed string to a file, using the first char
      // parameter as CR
      void unpipstring(char,unsigned char huge*,int);
      // decompresses a file to a string
      // the file has to be opened in binary mode
      void unpipfile(unsigned char huge*,int);
      // reads a null terminated string
      int read0(unsigned char huge*,int,unsigned int,char);
      // reads a file (the second pointer is to the file name) into the
      // message buffer pointed by the first parameter, removing LFs
      int readfile(unsigned char huge*,char*);
      // writes a string, null terminated (the NUL is also written to
      // the file)
      void write0(unsigned char huge*,int);
      // writes a text to a file; the third parameter is a character to be
      // used instead of fidonet escape character ^a
      void writemex(unsigned char huge*,int,char);
      // returns a pointer to the origin in the text pointed, or
      // NULL if no origin is found
      char huge*find_origin(char huge*);
      // area number; -1 for no area open
      int area;
      // message number; -1 for no message loaded
      int msg_number;
      // message buffer
      address_class fromaddr,toaddr;
      unsigned int attributes,status;
      unsigned int cost,times;
      char huge*text;
      long textsize; // warning: it's the dimension of the allocated buffer
      char from[36],to[36],subject[72];
      date_time_class date;
      int previous,next; // reply_links
      // all procedures return 0 if successful or -1 otherwise
      // adds the message into the specified area; alters msg_number
      int post(void);
      // modifies the message; if area is changed, the message is
      // forwarded, but the original message is not deleted
      int modify(void);
      // deletes the message pointed by (area,msg_number)
      int del(void);
      // reads into the buffer the message pointed by (area,msg_number);
      // if text==NULL, only the header is loaded;
      // if the parameter is 0 (or if no parameters are passed), message will
      // not be read unless msg_number has changed; pass a nonzero value to
      // force a message reread
      int read(int=0);
      // allocates a buffer in the heap for message text
      int allocate_text(long=BUFSIZE);
      //frees the message in the heap
      int deallocate_text(void);
      // copies seen-bys and path into the specified arrays
      int isolate_seen_by(AUDIT*,int&,int,AUDIT*,int&,int);
      // highest message number in this area; -1 if no area is defined
      int highest_message(void);
      // total number of messages in this area; -1 if no area is defined
      int total_messages(void);
      message_frame(void);
      ~message_frame(void);
  };

// error codes returned in lasterror
// no errors
#define MSGERR_NOERR 0
// out of memory
#define MSGERR_ENOMEM -1
// unable to open file
#define MSGERR_ENOFILE -2
// area not selected
#define MSGERR_ENOAREASEL -3
// message not selected 
#define MSGERR_ENOMSGSEL -4
// area not open
#define MSGERR_ENOAREAOPEN -5
// text buffer not allocated
#define MSGERR_ENOBUFFER -6
// msg_number bad: unexisting message
#define MSGERR_ENOMSG -7
// could not write
#define MSGERR_ENOWRITE -8
// could not read
#define MSGERR_ENOREAD -9
// could not reach message
#define MSGERR_ENOSEEK -10

// not implemented (in definitive version this code will never be returned)
#define MSGERR_NOTIMPL -128
