/* areas.c gestione della matrice delle aree in modo virtuale */

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#ifdef __WINDOWS__
  #include <windows.h>
#endif

#define AREAS
#include "pipbase.h"
#include "areas.h"
extern NODEINFO cfg;
static AREASTRUCT *ac;
static FILE *fa=NULL;
static int fromarea,toarea;
#ifdef __WINDOWS__
  HANDLE areaSelector;
#endif


void flush_areas(void)
{
  fseek(fa,fromarea*sizeof(AREASTRUCT),SEEK_SET);
  fwrite(ac,64*sizeof(AREASTRUCT),1,fa);
  changed_areas=0;
}


void discard_area_changes(void)
{
  changed_areas=0;
}


void init_areas()
{
  char fn[80];
  int i;
  sprintf(fn,"%sBaseDesc.Pip",cfg.pipdir);
#ifdef __WINDOWS__
  {
    if((areaSelector=GlobalAlloc(GMEM_FIXED,64*sizeof(AREASTRUCT)))==NULL)
      {MessageBox(NULL,"Error in area management\nNo meory","Pip* area manager",MB_OK|MB_ICONHAND); exit(14);} 
    ac=(AREASTRUCT*)GlobalLock(areaSelector);
  }
#else
  if((ac=(AREASTRUCT*)malloc(64*sizeof(AREASTRUCT)))==NULL)
    {fprintf(stderr,"Error in area management (no memory)\7\n"); exit(14);} 
#endif
  if((fa=fopen(fn,"rb+"))==NULL)
    {
      fa=fopen(fn,"wb");
      *ac[0].tag=*ac[0].descr=0;
      for(i=0; i!=cfg.pipsize; i++)
        fwrite(ac,sizeof(AREASTRUCT),1,fa);
      rewind(fa);
    }
  fread(ac,64*sizeof(AREASTRUCT),1,fa);
  fromarea=0; toarea=63;
}


AREASTRUCT*areas(int area)
{
  if(!fa)
    init_areas();
  if((area>=fromarea) && (area<=toarea))
    return &ac[area-fromarea];
  if(changed_areas) flush_areas();
  fromarea=area/64;
  fromarea*=64;
  toarea=fromarea+63;
  if(fseek(fa,fromarea*sizeof(AREASTRUCT),SEEK_SET))
    {fprintf(stderr,"Error in area management\7\n"); exit(15);}
  if(fread(ac,64*sizeof(AREASTRUCT),1,fa)==0)
    {fprintf(stderr,"Error in reading area datas\7\n"); exit(16);}
  return &ac[area-fromarea];
}


void close_areas()
{
  if(changed_areas) flush_areas();
  fclose(fa);
  fa=NULL;
  #ifdef __WINDOWS__
    GlobalUnlock(areaSelector);
    GlobalFree(areaSelector);
  #else
    free(ac);
  #endif
}
