;Echodor.Ctl
;
;Parameter file and area table for the message reader
;
;
;Parameters follow below.
;
;   Put your full zone, net, node, and point address in the line that follows.
;
ADDRESS 1:116/1000.0
;
;             Change this line to your origin line as it appears
;             in your areas.bbs file.
;
;             Also, don't include your net/node number at the end of
;             the ORIGIN line.  EchoDor will automatically append a
;             space followed by the NET/NODE number in the form:
;
;             (1:116/1000.0)
;
ORIGIN The NEW WorkBench BBS - 615-333-1458 -
; The above will appear as:
;  * ORIGIN: The NEW WorkBench BBS - 615-333-1458 - (1:116/1000.0)
;
;             set this parameter to limit the maximum minutes
;             allowed per session
MAXUSERTIME 45
;
;             This is the command string that will be displayed at the
;             bottom of the main menu.  You are allowed up to 80 characters.
COMMANDSTRING Main Command ?
;
;             Uncomment the mono command if you are using a monochrome system
;             and still wish for your users to see ansi color.
;MONO
;
;Ansi screen colors:
;
;MsgTextColor  - Color set when displaying/entering message text
;ScanBarColor  - Set on the top bar of the scan command (Msg#.....From....To...)
;ScanLinecolor - Set on each line displayed with scan
;
PROMPTCOLOR 10
MSGTEXTCOLOR 14
HILIGHTCOLOR 15
SCANBARCOLOR 14
SCANLINECOLOR 13
;
;                This is the 8 letter file name (without extension!)
;                for the main menu files.  This is what is displayed to
;                users that do not run in Expert mode.
MENUFILE ECHOMEN
;
;                This is the 8 letter file name (without extension!)
;                for the "user setup" menu files.  This is what is displayed
;                to users that select [U] from the main menu.
USERMENU USERMENU
;
;                Help Files. The echomail door allows you to set up a
;                help system to inform your users of the commands
;                available to them as well as information on how echomail
;                works, what it's good for, etc. There are two types of
;                help files:
;
;                1) the help menu. The help menu is a sort of table-of-contents
;                   of all of the help files
;                2) the actual help files. The help menu is simply the help
;                   path/prefix and the help files are the path\prefix with a
;                   number added on. (i.e. if the prefix was c:\binkley\echohlp)
;                   then help menu would be "C:\binkley\echohlp" and the help
;                   files would be "C:\binkley\echohlp1",
;                   "C:\binkley\echohlp2", etc.
;
;HelpFilePrefix - The help file path/prefix (do not include extension)
;NumHelpFiles   - Number of help files (not including menu)
;
HELPFILEPREFIX ECHOHLP
NUMHELPFILES 5
;
;Sysopname -   Enter one statement for each person who you wish to have access
;              to the sysop conference. For more than one sysop, enter multiple
;              statements. There was a problem in prior versions of EchoDor
;              where the sysop name here and that generated when running as a
;              door could be different.  This has been corrected.
;
;Commentname - Enter one and only one name for the person who will receive
;              comments to the sysop.
;
;Commentarea - This is the area where the comments will go.
;
;NoComment   - Disables the comment feature (useful for rbbs sysops)
;
SYSOPNAME Robert McCullough
COMMENTNAME Robert McCullough
COMMENTAREA 99
;NOCOMMENT
;
;NoIgnore   - This will disable the ignore command. The ignore command is used
;             to exclude certain areas from the message check. This is useful
;             if you have a lot of echos in which checking all of them may take
;             a very long time.
;
;NoSetNational - On Default, echodor will set everyones ignore status to
;                ignore the national echos. This option will disable that.
;NOIGNORE
NOSETNATIONAL
;
;Welcome - The name of the welcome file that is to be displayed every time a
;          user accesses the echomail door. The filename should be 7
;          characters with no extension. A "G" or "C" will be appeneded to the
;          end of the name if the user is using graphics or ansi modes. If the
;          graphics version of the file does not exist, then it will default
;          to the non-graphics file.
;
WELCOME ECHOWEL
;
;NODELISTPATH - This is the location of the node list files.  The files may
;               be either version 6 node list files (NodeList.IDX and
;               NodeList.Dat), or if your running a registered version of
;               EchoDor, it may be the EchoNlCp compiled node list files.
;
;               The "V6" option specifies a version 6 nodelist.
;
;               Replace "V6" with "ED" to run the EchoDor EchoNLCP compiled
;               node lists.
;
;               The second parameter is the directory where the node list
;               files can be found.
;
NODELISTPATH V6 G:\Nodelist\
;
;NEWQUOTE - This turns on the "Fast" quote option in the visual editor.
;
NEWQUOTE
;
;VISUALESC - This makes the visual editor display the <ESC> menu when
;            any of the listed characters are typed as the first character
;            of a line.
;
VISUALESC ./\
;
;SCANLOGNAME - This is the name of the file created by EchoDor to indicate
;              the names of the echos which have new messages entered.  If
;              the user enters a message only in a net mail area, the file
;              will be created but will contain no entries.
;
SCANLOGNAME scanlog.ctl
;
;Area table follows. Each area must be listed one per line, in the order
;you wish them to be displayed.
;
;Here is a listing of the parameters that must be present on the line:
;
;Num: This field is used to specify the number that will be assigned to the
;     conference. Each conference should be assigned a different number. The
;     area number is used to keep track of the user's last-read pointer and
;     to keep track of the area membership if it is to be a private area and
;     you wish to use the sigop utility. The numbers can be in any order you
;     want. I usually set 1 as my main base, 2-20 as my bbs-only confernces,
;     50-55 as my local echos, and 60-100 as my echos. Do not exceed 255 for
;     the number.
;
;Area tag: This is that tag that is used to identify what will be put into
;          the "AREA:" statement of your message. currently, it is done by
;          confmail/QM/TossScan for you, so it has no real use here.
;
;Listed tag: This tag is listed on each command line in the door. It may
;            be anything you like and need not be the same as the "area tag".
;            it is used simply to inform the user of which area he is in.
;
;Path: This is a dos path telling where messages for this area are to be
;      stored. It should include a drive specifier and path with no trailing
;      backslash (i.e. C:\binkley\messages)
;
;T: This is the type of the area and is VERY important to the door. It is used
;   determine weather the area is echomail, netmail, or local.  Type codes are
;   as stated below:
;
;          E - an echomail area              N - The netmail area (only 1)
;          B - a local message area          I - An national echo area
;          A - automessage (read the docs)
;
;M: This determines the types of messages that the user will be able to enter
;   into the area.  This is expanded from the older versions of EchoDor which
;   used this field to allow private messages.  The following message type
;   codes are available:
;
;          P - allow private messages
;          Y - allow private messages (for compability with older versions)
;          N - do not allow private messages
;          A - allow alias names in area (this can be combined with P/Y/N/A/G)
;          F - anonynous messages (user name not listed, can be combined
;              with P/Y/N/A/G)
;          G - GT-Style ANSI messages (can be combined with P/Y/N/A/F).
;
;F: File transfers - this is a new feature that will soon be developed
;   allowing users to upload a file, attach it to a message, and send it
;   to another user. The file will be deleted after it has been sent.
;
;   If the F flag is set to Y in a NetMail section, EchoDor will ask if the
;   user wants to do a file request or file attach when sending netmail.
;
;S: Security.  This is the security level required to access the conference
;   this information is retrieved from DORINFOx.DEF file or from the user
;   record.  This field can also contain a Y to indicate SYSOP ONLY or a N
;   to indicate an open area.
;
;WRACC: Access level required to write a message
;
;DO NOT ENTER SPACES IN ANY OF THE FIELDS. You must enter spaces to seperate
;the fields, but you cannot enter them in the middle of any field.
;
;It is usually preferable to enter the sysop areas at the end of the list in
;order to make sure the numbers in the num column of the area table area the
;same as the numbers in the desctable.
;
AREATABLE
;
;Num Area Tag          Listed tag          Path              T   M  F  S  WRACC
;--- -----------       -------------       ----------------- -  --- -  -  -----
   1 GAMING            Gaming              G:\CONF\GAMING    B   N  N  1   1
   2 HUMOR             Jokes               G:\CONF\HUMOR     I   N  N  1   1
   3 POLITICS          Politics            G:\CONF\POLITICS  I   N  N  1   1
   4 RBBS_DEV          Rbbs-Dev            G:\CONF\RBBS_DEV  I   N  N  1   1
   5 RBBS-NET          Rbbs-net            G:\CONF\RBBS-NET  I   N  N  10  1
   6 RBBS-SYSOP        RBBS-Sysops         G:\CONF\RBBS-SYS  I   N  N  1   1
   7 RBBS-PC           RBBS-Pc             G:\CONF\RBBS-PC   I   N  N  1   1
   8 DOORWARE          Doors               G:\CONF\DOORS     I   N  N  1   1
   9 DBASE             dbase               G:\CONF\DBASE     I   N  N  1   1
  10 ADULT             Adult_Area          G:\CONF\ADULT     I  YFA N  1   1
  11 GT-ANSI           GT-ANSI_Area        G:\CONF\ANSI      E  NG  N  5   5
  99 PRIVATE           NETMAIL             G:\BINKLEY\MSGS   N   Y  N  10  1
;
ENDAREATABLE
;
;This area contains the descriptions used for each echo area.  These desc-
;riptions will be used only if there is no UserAreaList and/or SysopAreaList.
;Each description is a one line entry.  The first part must be the area number.
;The number must be followed by a space.  Next comes the description.  The
;desciption must be less than 70 characters long.  You might also want to
;include the area name in the description in case the user wants to use that
;in place of a number.
;
DESCTABLE
1 GAMING - Gamers Echo
2 HUMOR - Humor Echo
3 POLITICS - Politics Echo
4 RBBS_DEV - RBBS Development Echo
5 RBBS-NET - RBBS Net Echo
6 RBBS-SYSOP - RBBS Sysop Echo
7 RBBS-PC - RBBS-PC Users Echo
8 DOORWARE - Sysop Door Ware Echo
9 DBASE - Dbase Users Echo
10 ADULT - Adults only area
11 GT-ANSI - Messages that contain ANSI artwork
99 PRIVATE - Netmail
ENDDESCTABLE
;
;UserArealist - A text file that will be output when the user seletcs
;               the list areas feature.  If the UserAreaList parameter
;               is not specified, the descriptions from the AREADESC
;               table will be shown to the user.
;
;SysopAreaList - A text file that will be output when the sysop selects
;                the list areas feature.  If the SysopAreaList parameter
;                is not specified, the descriptions from the AREADESC
;                table will be shown to the user.
;
;Uncomment the following to use the text files instead of the desctable.
;USERAREALIST USEAREA
;SYSOPAREALIST SYSAREA
;
;Deleteuser - The number of days of inactivity before a user will be removed
;             from the door's lastread pointer list.  This parameter is used
;             by EchoUtil.
;
DELETEUSER 90
;
;NodoorMode - Disables/enables certain features if you are using the door
;             as your PRIMARY message system (i.e. in Scottbbs systems)
;             instead of as a door. Your bbs should, when the message
;             system is invoked, drop to dos and run the door in remote
;             mode if you wish to have echodor as your primary message system.
;             As far as I know, Today, scottbbs is the only system that
;             allows this feature.
;
;CLOSINGSTRING - This is displayed to the user as EchoDor exits
CLOSINGSTRING Bye Bye Y'all
;
;---------------------------------------------------------------------------
;  The next options are for the download mail option. These options will
;will allow your users to pack up mail in an area either To them, From them,
;Public, or all. The mail is put into a text file specified by the MAILFILE
;option. Users may download the text file from your bbs's files section
;(you should enter it into your file directory for one of the areas).  You
;can also enable the built in download functions so the users can download
;their mail within EchoDor.
;
;You may also wish to arcrive this into .ARC or .ZIP file to speed downloading.
;
;Mailfile - The filename (and path) of where you wish mail packed for
;           download to be placed. It should be in a directory that your
;           files section can access. You will also have to enter the file
;           names into your bbs file directory for that area.
;
;           If you use the built in download function you should place the
;           file where the download functions can find them.
;
;           If you run multiple nodes, you should name this file differently
;           in each echodor.ctl file so that the different nodes won't bump
;           into each other.
;
MAILFILE Usermail.txt
;
;PackMailText - This is a name of a file that is displayed to the user
;               when he/she finishes packing the mail.  You can tell them
;               the file is available from the files section, or you can
;               tell them to use the [D] command to download the mail.
;
PACKMAILTEXT PackMail
;
;PackMailMenu - This is the name of the Pack Mail Menu file.  This is much
;               like the main menu file except it is displayed when the user
;               selects the [P] option on the main menu.
;
PACKMENUFILE PackMenu
;
;Nopackmail - Disables the packmail feature
;NOPACKMAIL
;
;Always put "end of script" at the end of the script or you may experience
;problems.
;
End of script
