;-----------------------------------------------------------------------------
;
;  This file is given as an example of the commands that should be added
;  to the EchoDor.Ctl file to enable compressing and downloading mail.
;
;  This file can either be apppended to the EchoDor.Ctl file or it can
;  be added using the INCLUDE PackMail.Ctl command.
;
;  If you use this file, delete some of the comments as it will decrease the
;  EchoDor load / start up time.
;
;-----------------------------------------------------------------------------
;Nopackmail - Disables the packmail feature.  If this parameter is uncommented,
;             all of the PackMail features in EchoDor will be disabled.  If you
;             want to use the packmail function be sure to either remove this
;             parameter or leave it commented out.
;
;NOPACKMAIL
;
;PackMenuFile - This is the name of the Pack Mail Menu file.  This is much
;               like the main menu file except it is displayed when the user
;               selects the [P] option on the main menu.
;
;               This parameter is required if you wish to use the pack mail
;               feature in EchoDor.
;
PACKMENUFILE PackMenu
;
;Mailfile - The filename (and path) of where you wish uncompressed mail can
;           be placed.  This parameter is required for PackMail operation.
;
;           If you let the user download this file through your file section
;           on your BBS, be sure to place the file where it can be found.
;
;           If you use the built in download function you should place the
;           file where the download functions can find them.  A good place
;           to put the mail file is in the EchoDor directory.
;
;           If you run multiple nodes, you should name this file differently
;           in each echodor.ctl file so that the different nodes won't bump
;           into each other.  As an alternative you can include a single pound
;           symbom (#) somewhere in the file name.  EchoDor will replace the
;           pound symbol with the node number.
;
MAILFILE C:\EchoDor\Usermail.txt
;
;PackMailText - This is a name of a file that is displayed to the user
;               when he/she finishes packing the mail.  You can tell them
;               the file is available from the files section, or you can
;               tell them to use the [D] command to download the mail or
;               the [C] command to compress the packed mail file.
;
;               This parameter is optional.
;
PACKMAILTEXT PackMail
;-----------------------------------------------------------------------------
;
;  This section contains the parameters that define the mail downloading
;  feature of EchoDor.  The omission of these parameters will not prevent
;  the user from packing mail; however, it will be necessary to place the
;  packmail file somewhere where the user can download it through the file
;  section of the BBS.
;
;  With downloading enabled, the user can download the mail file from directly
;  within EchoDor and not have to exit.  EchoDor will tell the download command
;  to either download the uncompressed file or the commpressed file as
;  necessary.
;
;-----------------------------------------------------------------------------
;DownLoadFile - This parameter tells EchoDor the name of the file that should
;               be displayed to the user when he/she selects [D]ownload from
;               the pack mail menu.  This file should tell the user the
;               protocols that you have available for downloads.
;
;               This file can be created in the three versions:
;                     filename.ANS   (ANSI color)
;                     filename.ASC   (IBM ascii)
;                     filename.      (regular text)
;
;               This file is required to enable downloading.
;
DOWNLOADFILE download
;
;DownLoadProtocol - This parameter tells EchoDor the letter which corresponds
;                   to each specific protocol, and how to call that protocol.
;                   EchoDor has no built in protocols.  All downloading occurs
;                   through external protocol engines.  DSZ is one of the best
;                   known protocol engines.  Samples are given for X, Y, and Z
;                   modem downloads.  You can have as many down load protocol
;                   lines as you need.  You must have at least one for download
;                   to work.
;
;                   The first part of the parameter is the letter that is to
;                   be used to start the protocol.  This should be a single
;                   letter.  Upper and lower case are considered the same.
;
;                   The second part of the parameter is the name of the program
;                   that should be run.  Be sure to include either the .EXE or
;                   the .COM at the end of the program.  EchoDor will not
;                   directly run batch files.  The program must be either in
;                   the current directory or on the path.
;
;                   The last part of the parameter is the command to be passed
;                   to the program to download the file.
;
;                   The command part of the parameter can contain special
;                   control words that are replaced by values before EchoDor
;                   runs the program.  The available values are:
;
;                      %1 = node number (single character)
;                      %2 = com port number (single digit)
;                      %3 = baud rate (300-38400).  If the user is connected
;                           with a locked rate, that locked rate will be used.
;                      %4 = file to download.  A full drive and path will be
;                           passed.
;
;                   Any of the above can be used as needed.  The following
;                   are samples for download protocols for X modem, Y modem,
;                   and Z modem.
;
DOWNLOADPROTOCOL Z DSZ.EXE port %2 sz %4
DOWNLOADPROTOCOL Y DSZ.EXE port %2 sb %4
DOWNLOADPROTOCOL X DSZ.EXE port %2 sx %4
;
;-----------------------------------------------------------------------------
;
;  This section contains the parameters that define the mail compression
;  feature in EchoDor.  The omission of these parameters will not prevent
;  the user from packing mail; however, only the full text file can be
;  received or specific compression (when EchoDor exits) can be used.
;
;  When packing is used, the user can compress his/her text file before
;  attempting to download it.  This will reduce time on the BBS.
;
;-----------------------------------------------------------------------------
;CompressDir - This parameter tells EchoDor where to put files that have been
;              compressed by an archive program.  This parameter must specify
;              a valid directory.  ** Warning ** - this directory will be
;              completely erased each time EchoDor gets ready to compress a
;              mail file.  MAKE SURE YOU GET THIS PARAMETER CORRECT!!!
;
COMPRESSDIR C:\EchoDor\Compress
;
;CompressFile - This parameter tells EchoDor the name of the file that should
;               be displayed to the user when he/she selects [C]ompress from
;               the pack mail menu.  This file should tell the user the
;               archive programs that you have available for compressing mail.
;
;               This file can be created in the three versions:
;                     filename.ANS   (ANSI color)
;                     filename.ASC   (IBM ascii)
;                     filename.      (regular text)
;
;               This file is required to enable compressing mail.
;
COMPRESSFILE compress
;
;PackerProgram - This parameter tells EchoDor the letter which corresponds to
;                each specific compression program and how to call that com-
;                pression program.  EchoDor has no build in archiving programs.
;                All compression occurs through outside compression programs.
;                Examples are given for ZIP, PAK, and ARC.  You can have as
;                many packer program lines as you need.  You must have at least
;                one for comression to work.
;
;                The first part of the command is the letter that is used to
;                start the compress program.  This must be a single letter.
;                Upper and Lower case are considered the same.
;
;                The second part of the parameter is the name of the program
;                that should be run.  Be sure to include either the .EXE or
;                the .COM at the end of the program.  EchoDor will not
;                directly run batch files.  The program must be either in
;                the current directory or on the path.
;
;                The last part of the parameter is the command to be passed
;                to the program to download the file.
;
;                The command part of the parameter can contain special
;                control words that are replaced by values before EchoDor
;                runs the program.  The available values are:
;
;                   %1 = the name of the file to compress.  A full drive &
;                        path will be passed.
;                   %2 = the COMPRESSDIR parameter.
;
;                Either or both of the above can be used.  The following are
;                examples of ZIP, PAK, and ARC.
;
PACKERPROGRAM Z PkZip.Exe -a %2\EchoMail %1
PACKERPROGRAM P Pak.Exe A %2\EchoMail %1
PACKERPRORGAM A Arca.Com %2\EchoMail %1
;
;                This next example uses PAK to generate a self extracting
;                archive for the user.
;
PACKERPROGRAM E Pak.EXE A/EXE %2\EchoMail %1
;
;-----------------------------------------------------------------------------
