{$A+,B-,D+,E-,F-,I-,L-,N-,O-,R-,S-,V+}
{$M 1024,1000,1000}
program tnpatch;

uses crt,dos;

const
  ParNum = 33;                            (* Anzahl Parameter *)
  panz   : byte = 0;                      (* Anzahl Kommandozeilenparms *)
  auto   : byte = 0;                      (* incl Parameter? *)

  prg    = '***** Parameter Patch Program for TheNet 1.22e'+
           ' ****     (V3.2 updated by DG6MAY)';
  space  = '                                  ';
  eprfn  = 'TN122E.BIN';
  signon = 'TheNet 1.22e by DG6MAY';
  len    = 22;                           (* Lnge des Signon *)
  clen   = 22;                           (* ctext-lnge + space + #0 *)
  qlen   = 21;                           (* quittext-lnge + #0 *)
  dlen   = 81;                           (* Textlnge falsches Kommando + #0 *)

type
  str68 = string[68];
   ptyp = record                             (* parametertyp *)
            str : string[11];                   (* name des parms fr anzeige *)
            adr : word;                         (* adresse im file *)
            wrt : word;                         (* neuer Wert *)
            min : word;                         (* unterer Grenzwert *)
            max : word;                         (* oberer Grenzwert  *)
          end;

var
  outfile,infile :  text;
  zeile          :  string[100];
  i,i1,err,wert  :  word;
  pa             :  array [1..ParNum] of ptyp;
  MYID, ALIA     :  string[6];
  PWRD           :  string[80];
  CTXT           :  string[clen];                 (* hallo-text *)
  QTXT           :  string[qlen];                 (* servus *)
  CMDT           :  string[dlen];                 (* falsches Kommandotext *)
  SSID           :  byte;
  MYIDAD, ALIAAD,
  SSIDAD, PWRDAD,
  CTXTAD, QTXTAD,
  CMDTAD         :  word;                         (* adressen *)
  Pgm            :  array [0..32767] of char;
  PCFile         :  string[13];
  ch             :  char;
  crc            :  string[len];


{--------------------------------------------------------------------------}
procedure clrzeilen;
begin
 if auto=0 then
 begin
   gotoxy(1,25); clreol;
   gotoxy(1,24); clreol;
 end;
end;

{--------------------------------------------------------------------------}
procedure help(nr:byte;line: string);
begin
  if auto=0 then gotoxy(1,wherey-2);
  write(#10#13,'Error detected '#7);
  if nr=0 then zeile:='with reading '+line;
  if nr=52 then zeile:='number after ''PA''is wrong';
  if nr=53 then zeile:='something wrong with the value after ''=''';
  if nr=54 then zeile:='value out of range';
  if nr=55 then zeile:='in Patch-File';
  write(zeile);
  if nr > 50 then
  begin
    writeln(' in the following line:');
    writeln(#10#13+line);
  end;
  writeln(#10#10#13'Program haltet');
  halt(nr);
end;
{--------------------------------------------------------------------------}
procedure header;
begin
  clrscr; highvideo; writeln(prg);
  normvideo;
  gotoxy(1,24);
end;
{--------------------------------------------------------------------------}
procedure anzeige (var auto: byte);   (* anzeige auf schirm, feststellen, *)
begin                                 (* ob mit kommandozeilen-parameter  *)
  if paramcount > 1 then
  begin
    auto:=1;
    writeln;
    highvideo;  writeln(prg); lowvideo;
    writeln(#10,'in Automatic-Work ....pse wait ...',#10);
  end
  else header;
end;

{--------------------------------------------------------------------------}
procedure readbin;     (* einlesen des binrfiles, suchen nach dem signon *)
begin

  writeln('reading: ',eprfn);
  assign(infile,eprfn);
  {$I-}   reset(infile); {$I+}
  i:=ioresult;
  if i <> 0 then help(0,eprfn);
  for i := 0 to 32767 do read(infile,pgm[i]);
  close(infile);

  i:=19000;           (* ------- suchen nach dem signon ab dem offset ----*)
  crc[0]:=chr(len);                                (* lnge mu klar sein *)
  repeat
    for i1:=1 to len do crc[i1]:=pgm[i+i1];
    inc(i);
  until (crc=signon) or (i>25000);                        (* bis gefunden *)

  if i > 25000 then
  begin
    writeln('Signon ''',signon,''' not found !');
    halt(0);
  end;

end;

{--------------------------------------------------------------------------}
procedure table;
begin

pa[01].str:='Max-Nodes  '; pa[01].adr:=$9F; pa[01].min:=1;  pa[01].max:=200;
pa[02].str:='min-Quality'; pa[02].adr:=$A1; pa[02].min:=0;  pa[02].max:=255;
pa[03].str:='HF-Quality '; pa[03].adr:=$A3; pa[03].min:=0;  pa[03].max:=255;
pa[04].str:='RS-Quality '; pa[04].adr:=$A5; pa[04].min:=0;  pa[04].max:=255;
pa[05].str:='Obs-Init   '; pa[05].adr:=$A7; pa[05].min:=0;  pa[05].max:=255;
pa[06].str:='min-BCast  '; pa[06].adr:=$A9; pa[06].min:=0;  pa[06].max:=255;
pa[07].str:='Broadcast  '; pa[07].adr:=$AB; pa[07].min:=0;  pa[07].max:=$FFFF;
pa[08].str:='Lifetime   '; pa[08].adr:=$AD; pa[08].min:=0;  pa[08].max:=255;
pa[09].str:='T-Timeout  '; pa[09].adr:=$AF; pa[09].min:=5;  pa[09].max:=600;
pa[10].str:='T-Retry    '; pa[10].adr:=$B1; pa[10].min:=2;  pa[10].max:=127;
pa[11].str:='T-AckDelay '; pa[11].adr:=$B3; pa[11].min:=1;  pa[11].max:=60;
pa[12].str:='T-BsyDelay '; pa[12].adr:=$B5; pa[12].min:=1;  pa[12].max:=1000;
pa[13].str:='T-Window   '; pa[13].adr:=$B7; pa[13].min:=1;  pa[13].max:=127;
pa[14].str:='NoAckBuf   '; pa[14].adr:=$B9; pa[14].min:=1;  pa[14].max:=127;
pa[15].str:='Timeout    '; pa[15].adr:=$BB; pa[15].min:=30; pa[15].max:=$FFFF;
pa[16].str:='Persistence'; pa[16].adr:=$BD; pa[16].min:=5;  pa[16].max:=255;
pa[17].str:='SlotTime   '; pa[17].adr:=$BF; pa[17].min:=0;  pa[17].max:=255;
pa[18].str:='Frack      '; pa[18].adr:=$93; pa[18].min:=1;  pa[18].max:=15;
pa[19].str:='Maxframe   '; pa[19].adr:=$95; pa[19].min:=1;  pa[19].max:=7;
pa[20].str:='L2-Retry   '; pa[20].adr:=$97; pa[20].min:=1;  pa[20].max:=127;
pa[21].str:='T2-Timer   '; pa[21].adr:=$99; pa[21].min:=0;  pa[21].max:=600;
pa[22].str:='T3-Timer   '; pa[22].adr:=$9B; pa[22].min:=0;  pa[22].max:=$FFFF;
pa[23].str:='L2-Digi    '; pa[23].adr:=$9D; pa[23].min:=0;  pa[23].max:=2;
pa[24].str:='CallCheck  '; pa[24].adr:=$C1; pa[24].min:=0;  pa[24].max:=1;
pa[25].str:='ID-Beacon  '; pa[25].adr:=$C3; pa[25].min:=0;  pa[25].max:=600;
pa[26].str:='CQ-MODE    '; pa[26].adr:=$C5; pa[26].min:=0;  pa[26].max:=3;
pa[27].str:='Full-Duplex'; pa[27].adr:=$C7; pa[27].min:=0;  pa[27].max:=1;
pa[28].str:='Idle-Flags '; pa[28].adr:=$C9; pa[28].min:=0;  pa[28].max:=1;
pa[29].str:='TX-Delay   '; pa[29].adr:=$CB; pa[29].min:=0;  pa[29].max:=127;
pa[30].str:='Systemflags'; pa[30].adr:=$CD; pa[30].min:=0;  pa[30].max:=$FFFF;
pa[31].str:='CCP MinBuff'; pa[31].adr:=$CF; pa[31].min:=250;pa[31].max:=800;
pa[32].str:='SpaceChar  '; pa[32].adr:=$D1; pa[32].min:=0;  pa[32].max:=255;
pa[33].str:='Kaltstart  '; pa[33].adr:=$123;pa[33].min:=0;  pa[33].max:=1;

MYID := '';                MYIDAD := $86;
ALIA := '';                ALIAAD := $8D;
SSID := 0;                 SSIDAD := $8C;
PWRD := '';                PWRDAD := $D3;
CTXT := '';                CTXTAD := $4D78;
QTXT := '';                QTXTAD := $4D8E;
CMDT := '';                CMDTAD := $4DE6;



end;

{--------------------------------------------------------------------------}

procedure getfn(x,y: byte; text: string; var datei: text; modus : byte);
begin
  repeat
    clrzeilen; write(text); gotoxy(x,y);
    PCFile := '';
    repeat
     ch:=upcase(readkey);
     if ((ch > #32) and (ch < #42) and (ch <> #34)) or
        ((ch > #44) and (ch < #58) and (ch <> #47)) or
        ((ch > #64) and (ch < #91)) or
        (ch = #13) or (ch='_') or (ch='\' ) or (ch=#8) then
        begin
          if (ch=#8) then
            if (length(PCFile) > 0) then
            begin
              write(#8#32#8);
              dec(PCFile[0]);
            end
            else write(#7)
          else
          begin
            write(ch);
            PCFile:=PCFile+ch;
          end;
        end
        else write(#7);
    until (ch = #13);
    writeln;
    dec(PCFile[0]);
    if pcfile[0]=#0 then halt;
    if (modus=2) and (pos('.',pcfile)=0) then pcfile:=pcfile+'.BIN';
    assign(datei,PCFile);
    if modus=1 then {$I-}   reset(datei); {$I+}
    if modus=2 then {$I-} rewrite(datei); {$I+}
    i:=ioresult;
    if i <> 0 then write(#7);
  until i=0;
end;

{--------------------------------------------------------------------------}

procedure readpat;
var str10 : string[10];
begin
clrzeilen; writeln('reading: '+pcfile);
repeat
   readln(infile,zeile);
                                           (* nchste zeile holen, wenn:  *)
   while ((length(zeile) = 0) or           (* nix in der zeile steht *)
          (ord(zeile[1]) < 33) or          (* 1. Zeichen <= space *)
          (ord(zeile[1]) > 90) or          (* grer 'Z' *)
          (zeile[1] = ';')) and            (* ; ist (kommentar)  *)
          not eof(infile) do               (* und no net end of file ist *)
          readln(infile,zeile);


(**************************************** Call  einlesen *********************)

   if copy(zeile,1,4) = 'MYID' then
   begin
     MYID := copy(zeile,6,6);
     MYID := MYID + copy(space,1,6-length(myid));
   end;


(**************************************** Ident einlesen *********************)

   if copy(zeile,1,4) = 'ALIA' then
   begin
     ALIA := copy(zeile,6,6);
     ALIA := ALIA + copy(space,1,6-length(alia));
   end;


(**************************************** SSID  einlesen *********************)

   if copy(zeile,1,4) = 'SSID' then
   begin
     i1:=pos(#32,zeile);                  (* pos in zeile vor einem space *)
     if i1=0 then i1:=length(zeile)       (* wenn kein space, bis zum ende *)
             else dec(i1);                (* sonst bis pos vorher *)
     val(copy(zeile,6,i1-5),ssid,i);
     if (ssid < 0) or (ssid >15) or (i <>0) then help(53,zeile);
   end;


(**************************************** Password einlesen ******************)

   if copy(zeile,1,4) = 'PWRD' then
   begin
     PWRD := copy(zeile,6,80);
     i1 := pos(' ',pwrd);
     if (length(PWRD) < 80 ) or (i1 > 0) then help(55,zeile);
   end;


(******************************* Begrungstext einlesen *********************)

   if copy(zeile,1,4) = 'CTXT' then
   begin
     CTXT := copy(zeile,6,20);
     CTXT:=CTXT+#32+#0;
     while(length(CTXT) < clen) do CTXT:=CTXT+#32;      (* sieht im Eprom *)
   end;                                                 (* besser aus! *)


(******************************* 'Servus'-Text  einlesen *********************)

   if copy(zeile,1,4) = 'QTXT' then
   begin
     QTXT := copy(zeile,6,20);
     QTXT:=QTXT+#0;
     while(length(QTXT) < qlen) do QTXT:=QTXT+#32;      (* sieht im Eprom *)
   end;                                                 (* besser aus! *)


(********************* Text 'falsches Kommando' einlesen *********************)

   if copy(zeile,1,4) = 'CMDT' then
   begin
     CMDT := copy(zeile,6,80);
     while(length(CMDT) < dlen-1) do CMDT:=CMDT+#32;    (* sonst gibts prob. *)
     CMDT:=CMDT+#0;                                     (* da text in CTEXT *)
     for i:=1 to dlen do
       if CMDT[i]='\' then CMDT[i]:=#13;
   end;


(*********************************** Parameter  einlesen *********************)

   if (copy(zeile,1,2) = 'PA') then
     begin
       val(copy(zeile,3,2),i,err);
       if (err<>0) or (i<0) or (i>parnum) then help(52,zeile);
       i1:=pos(#32,zeile);                  (* pos in zeile vor einem space *)
       if i1=0 then i1:=length(zeile)       (* wenn kein space, bis zum ende *)
              else dec(i1);                 (* sonst bis pos vorher *)
       str10:=copy(zeile,6,i1-5);           (* rberkopieren *)
       val(str10,wert,err);                 (* auswerten *)
       if err <> 0 then help(53,zeile);     (* Fehler erkannt? *)
       with pa[i] do
       begin
         if (wert < min) or (wert > max) then help(54,zeile);
         wrt:=wert;
       end;
     end;

until eof(infile);

close(infile);

end;

{--------------------------------------------------------------------------}

procedure showparms;
var   x,y : byte; hstr : string[3];
      cstr, qstr, xstr : string[100];
begin
  y:=3;
  gotoxy(1,y); write('Ident: ');
  highvideo;   write(ALIA);
  normvideo;   write('  Call: ');
  highvideo;   write(MYID);
  normvideo;   write('  SSID: ');
  highvideo;   writeln(SSID);
  normvideo;
  inc(y,2);

  for i:=1 to Parnum do
  begin
     x:=((i-1) mod 3) * 28+1;
     if i < 10 then inc(x);
     gotoxy(x,y);
     with pa[i] do
       write(i,'  ',str,'  ',wrt);
    if (i mod 3) = 0 then inc(y);
  end;

  (*------------------------------------ formen der Bits ---------- *)
  i1:=pa[30].wrt; i:=32768; y:=15; zeile:='';
  repeat
   if (i1 >= i) then
   begin
     str(y,hstr);
     zeile:=#32+hstr+zeile;
     i1:=i1-i;
   end;
   dec(y);
   i:=i shr 1;
  until y = 255;
  (*----------------------------------------------------------------- *)

  y:=10;
  if length(zeile) > y then
     while (zeile[y] <> ' ' ) do dec(y);

  writeln(#10#13);
  writeln('Pwd:  ',copy(PWRD, 1,40),'   Flags set by Parm30:',copy(zeile,1,y));
  writeln('      ',copy(PWRD,41,40),'   ',copy(zeile,y+1,255));

  writeln;

  cstr:=(copy(ctxt,1,(pos(#0,ctxt)-1)));
  qstr:=(copy(qtxt,1,(pos(#0,qtxt)-1)));
  xstr:=(copy(cmdt,1,(pos(#0,cmdt)-1)));

  writeln('CTXT: ''',cstr,'''     QTXT: ''',qstr,'''',#10#13);
  write  ('CMDT: ''');
  while(xstr[length(xstr)]=' ') do dec(xstr[0]);
  for i:=1 to length(xstr) do
    if xstr[i] = #13 then
    begin
     highvideo; write ('\'); normvideo;
    end
    else write (xstr[i]);
  writeln('''');

end;

{--------------------------------------------------------------------------}

procedure change;
begin

  for i := 1 to 6 do pgm[MYIDAD+i-1] := MYID[i];

  pgm[SSIDAD] := Chr(2*(SSID+48));

  for i := 1 to 6  do pgm[ALIAAD+i-1] := ALIA[i];
  for i := 1 to 80 do pgm[PWRDAD+i-1] := PWRD[i];
  if CTXT > '' then
    for i := 1 to length(CTXT) do pgm[CTXTAD+i-1] := CTXT[i];
  if QTXT > '' then
    for i := 1 to length(QTXT) do pgm[QTXTAD+i-1] := QTXT[i];
  if CMDT > '' then
    for i := 1 to length(CMDT) do pgm[CMDTAD+i-1] := CMDT[i];


  for i := 1 to 32 do
  begin
    pgm[pa[i].adr]   := Chr(pa[i].wrt);
    pgm[pa[i].adr+1] := Chr(trunc( pa[i].wrt / 256));
  end;
  pgm[pa[33].adr]:=chr(pa[33].wrt);                       (* dies ist nur 1 Byte ! *)

end;

{--------------------------------------------------------------------------}

procedure writebin;
begin
  clrzeilen;
  writeln('saving: ',PCFile);
  for i := 0 to 32767 do write(outfile,pgm[i]);
  close(outfile);
end;


{--------------------------------------------------------------------------}

procedure work;
begin
  if auto=1 then   (*--------- aufruf mit kommando-zeilen-parameter ------*)
  repeat                                          (* zhler der parameter *)
    inc(panz);
    if paramcount >= panz then                    (* gibt noch welche *)
    begin
     pcfile:=paramstr(panz);                      (* zuerst patchfilename *)
     assign(infile,pcfile);
     {$I-} reset(infile); {$I+}
     i:=ioresult;
     if i<>0 then halt;                           (* fehler *)
    end;
    readpat;                                      (* patchfile lesen *)
    change;                                       (* und epromarray ndern *)
    inc(panz);
    if paramcount >= panz then
    begin
      pcfile:=paramstr(panz);
      if pos('.',pcfile)=0 then pcfile:=pcfile+'.bin';
      assign(outfile,pcfile);
      {$I-} rewrite(outfile); {$I+}
      i:=ioresult;
      if i <> 0 then halt;
    end;
    writebin;
  until panz > (Paramcount-2)

  else (*------------------------ hier also manuell ------------*)
  repeat

    getfn(32,24,'Enter Patch Control File Name:'+#10+#13+
                '(Exit if only <CR>)',infile,1);
    readpat;
    showparms;
    change;
    getfn(39,24,'Enter name of the binary output file:'+#10+#13+
                '(Exit if only <CR>)',outfile,2);
    writebin;
    header;
  until 1=2;

end;

{--------------------------------------------------------------------------}

Begin
 anzeige(auto);
 readbin;
 table;
 work;
End.
