Library UserDef;
{$D-,L-,I-}     {<< Disable debugging and I/O error checking }
uses Drivers,   {<< Needed for PrintStr routine }
     SnkDefs;   {<< Type definitions }

{ This function is first called for particle 0 (the projectile).
  If it returns the value TRUE, it is called successively for the next
  particles (1,2,3.. from the target) until it either returns FALSE,
  or all particles have been processed. See USERDEF3.PAS for an example
  of how this is exploited. }

function UserFunc(var f:TSnkFile; x,y,z,px,py,pz,t,m:double;i,j:word):boolean;export;
{
  Parameters:
  x,y,z: position coordinates of particle
  px,py,pz: momentum components for particle
  t: time elapsed
  m: mass of particle
  i: row number (0,1,2.. indexes the particle; = 0 for projectile)
  j: run number (1,2,3.. indexes the run)
}
procedure WriteCoordinates;
var
  R:TSnookRec;
begin
  R.rx := x;
  R.ry := y;
  R.rz := z;
  R.px := px;
  R.py := py;
  R.pz := pz;
  R.ti := t;
  R.ms := m;
  R.rw := i;
  R.rn := j;
  write(f,R);
end;

begin
  WriteCoordinates;
  UserFunc := true; 
end;

exports
  UserFunc index 1;

begin
  PrintStr('Loading USERDEF.DLL'#10#13); { for information only }
end.

