;;************************************************************************* 
;;                     dlog.inc       dlog.inc
;;*************************************************************************
;;
;;  Copyright (C) 1989 Northwestern University, Vance Morrison
;;
;;
;; Permission to view, compile, and modify for LOCAL (intra-organization) 
;; USE ONLY is hereby granted, provided that this copyright and permission 
;; notice appear on all copies.  Any other use by permission only.
;;
;; Northwestern University makes no representations about the suitability 
;; of this software for any purpose.  It is provided "as is" without expressed 
;; or implied warranty.  See the copywrite notice file for complete details.
;;
;;*****************************************************************************
;;
;; dlog.inc a module that allows configuration info to be logged to the disk.
;; Do NOT use these routines while the router is routing since a write may
;; take as long as 1 second to service.
;;
;; This module does depend on utility routines found in log.inc
;;
;; Routines provided by this module
;;
;;   DLOG_DECLARE name
;;   DLOG_DEFINE name
;;   DLOG_PRINT  name, string
;;   DLOG_PRINT_REG_HEX  name, string, reg
;;   DLOG_PRINT_INET_in_AX_BX  name, string
;;   DLOG_CLOSE name
;;
;;*****************************************************************************

;;*****************************************************************************
;; definition of DLOG packet structure


dlog_data STRUC
    dlog_handle     DW ?
    dlog_ip_addr    DD ?
    dlog_buffer     db 32 dup (0)
    dlog_file       db 'pcroute.log', 0
dlog_data ENDS


;;******************************************************************************
;;  DLOG_DECLARE name, facility, udp
;;       DLOG_DECLARE delcares a new loging object called 'name'. 
;;
DLOG_DECLARE   MACRO  name
    .errb <name>

    .DATA
    global dlog_&name&_data:dlog_data

    .CODE
    global dlog_&name&_define:near
    global dlog_&name&_print_hex_in_AX_CX_DX_const_ALL:near
    global dlog_&name&_print_inet_in_AX_BX_CX_DX_const_ALL:near

    global log_dec_ascii_in_AX_DI_ES_out_DI_const_BX_DX_BP_ES:near
    global log_hex_ascii_in_AX_DI_ES_out_DI_const_BX_DX_BP_ES:near
ENDM


;;******************************************************************************
;;   DLOG_DEFINE name
;;       DLOG_DEFINE sets aside the memory and acutally does the 
;;       initialization for the routeing objects 'name'
;;
DLOG_DEFINE   MACRO   name
    call dlog_&name&_define
ENDM

DLOG_REAL_DEFINE MACRO name
    local around
    .errb <name>

    .DATA
    dlog_&name&_data    dlog_data <>

    .CODE
    jmp around
                ;; 'external' routines
        dlog_&name&_print_hex_in_AX_CX_DX_const_ALL:
           DLOG_REAL_PRINT_HEX_in_AX_CX_DX_const_ALL name
            RET
        dlog_&name&_print_inet_in_AX_BX_CX_DX_const_ALL:
           DLOG_REAL_PRINT_INET_in_AX_BX_CX_DX_const_ALL name
            RET

    around:
    dlog_&name&_define:

    mov DX, offset dlog_&name&_data.dlog_file       ;; create the file
    mov CX, 0
    mov AH, 3CH
    int 21H

        ;; we assume that this worked, since we have no way of
        ;; recovering from this error

    mov word ptr dlog_&name&_data.dlog_handle, AX
    RET
ENDM


;;**************************************************************************
;; DLOG_CLOSE closes the log file, insuring that everything was written
;; out.  Obviously, no PRINTS can be issued after this
;;
DLOG_CLOSE  MACRO name

    mov BX, dlog_&name&_data.dlog_handle        ;; close the file
    mov AH, 3EH
    int 21H
ENDM


;;**************************************************************************
;; DLOG_PRINT logs the message 'string' to the the log file
;;    Note that this module violates convention and saves ALL registers
;;
DLOG_PRINT  MACRO name, string
   local mystring, endstring
   .errb <string>

    .DATA
mystring    db '&string', 13, 10
endstring   db 0

   .CODE
    push AX
    push BX
    push CX
    push DX

    mov BX, dlog_&name&_data.dlog_handle        ;; write the file
    mov AH, 40H                 
    mov CX, endstring - mystring
    mov DX, offset mystring
    int 21H

    pop DX
    pop CX
    pop BX
    pop AX
ENDM


;;**************************************************************************
;; DLOG_PRINT_REG_HEX logs the message 'string' to the log file
;;    reg is then printed after the string in Hexidecimal notation
;;    Note that this module violates convention and saves ALL registers
;;
DLOG_PRINT_REG_HEX  MACRO name, string, reg
   local mystring, endstring
   .errb <string>

    .DATA
mystring    db '&string'
endstring   db 0

   .CODE
    push CX
    push DX
    push AX

    mov AX, reg
    mov CX, endstring - mystring
    mov DX, offset mystring
    call dlog_&name&_print_hex_in_AX_CX_DX_const_ALL

    pop AX
    pop DX
    pop CX
ENDM


;;**************************************************************************
;; DLOG_PRINT_INET logs the message 'string' to the log file
;;    AX:BX is then printed in internet 'dot' notation
;;    Note that this module violates convention and saves ALL registers
;;
DLOG_PRINT_INET_in_AX_BX  MACRO name, string
   local mystring, endstring
   .errb <string>

    .DATA
    mystring    db '&string'
    endstring   db 0

   .CODE
    push CX
    push DX

    mov CX, endstring - mystring
    mov DX, offset mystring
    call dlog_&name&_print_inet_in_AX_BX_CX_DX_const_ALL

    pop DX
    pop CX
ENDM


;;**************************************************************************
;; Does the real work in doing printing a register in hex
;;
DLOG_REAL_PRINT_HEX_in_AX_CX_DX_const_ALL MACRO name
   local terminate
   .errb <name>

    .DATA
terminate   db 13, 10

   .CODE
    push AX
    push BX
    push CX
    push DX
    push BP
    push SI
    push DI
    push ES

    mov BP, AX          ;; save AX

    mov BX, dlog_&name&_data.dlog_handle        ;; write the file
    mov AH, 40H                 
    int 21H

    mov AX, BP          ;; restore AX

    mov CX, DS
    mov ES, CX
    mov DI, offset dlog_&name&_data.dlog_buffer 
    call log_hex_ascii_in_AX_DI_ES_out_DI_const_BX_DX_BP_ES

    sub DI, offset dlog_&name&_data.dlog_buffer 
    mov CX, DI                                  ;; the length
    mov AH, 40H                                 ;; write the number
    mov DX, offset dlog_&name&_data.dlog_buffer 
    int 21H

    mov CX, 2
    mov DX, offset terminate
    mov AH, 40H                 
    int 21H

    pop ES
    pop DI
    pop SI
    pop BP
    pop DX
    pop CX
    pop BX
    pop AX
ENDM


;;**************************************************************************
;; Does the real work in doing printing an internet dot notation
;;
DLOG_REAL_PRINT_INET_in_AX_BX_CX_DX_const_ALL MACRO name
   local terminate
    .errb <name>

    .DATA
terminate   db 13, 10

    .CODE
    push AX
    push BX
    push CX
    push DX
    push BP
    push SI
    push DI
    push ES

    mov word ptr dlog_&name&_data.dlog_ip_addr, AX
    mov word ptr dlog_&name&_data.dlog_ip_addr+2, BX

    mov BX, dlog_&name&_data.dlog_handle        ;; write the file
    mov AH, 40H                 
    int 21H

    mov AX, DS
    mov ES, AX

    mov DI, offset dlog_&name&_data.dlog_buffer 
    mov CX, 15          ;; maximum size of IP addr
    mov AL, ' '
    rep
    stosb

    mov SI, offset dlog_&name&_data.dlog_ip_addr
    IP_ASCII_in_SI_DI_ES_out_DI_const_BX_BP_ES 

    mov AH, 40H                                 ;; write the number
    mov DX, offset dlog_&name&_data.dlog_buffer 
    mov CX, 15          ;; size of IP address 
    int 21H

    mov CX, 2
    mov DX, offset terminate
    mov AH, 40H                 
    int 21H

    pop ES
    pop DI
    pop SI
    pop BP
    pop DX
    pop CX
    pop BX
    pop AX
ENDM

