#include	"multix.h"
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<time.h>

#include	"appl.h"
TMdxProcId	MyId;

void	ApplCallReqReceived(
TMdxEvent	*Event
)
{
	/*
	Event->ProcId	-	Holds the calling process id.
	Event->Password -	Holds the password used.
	*/
	printf("Call Request from Process (%ld)\n",Event->ProcId);

	MdxAcceptProcess(Event->ProcId,(void *)0);
}


void	ApplSendMsgCompleted(
TMdxEvent	*Event
)
{
	TMdxSRMsgInfo		*MsgInfo;

	/*
	"Event->Data"	holds the information abount the Message we sent.
	*/

	MsgInfo =	(TMdxSRMsgInfo	*)Event->Data;
	switch(MsgInfo->Sent.MsgCode)
	{
		case	ApplGetTimeReplyCode	:
		{
			printf("Time Sent - Error = %d\n",Event->Error);
		}
		break;
		case	ApplTextReplyMsgCode	:
		{
			printf("TextReply Sent - Error = %d\n",Event->Error);
		}
		break;
		default 					:	break;
	}
}


void	ApplTextDataReceived(
TMdxSRMsgInfo  *MsgInfo
)
{
	TBufSize	CountRead;
	TMdxError	Result;
	UInt8		Buf[80];
	Int8Ptr 	ReplyText	=	"This Is a Reply From the Server";


	printf("Text Message Received - Size = %ld\n",MdxMsgSizeGet(MsgInfo->Received.Msg));
	while (	(CountRead	=	MdxMsgRead(	MsgInfo->Received.Msg,
											Buf,
											sizeof(Buf)
											))	>	0	)
	{
		if (	fwrite(Buf,1,CountRead,stdout)	!=	CountRead	)
		{
			printf("Msg Write Failure\n");
			MdxReply(MsgInfo,ApplErrWriteFileError);
			return;
		}
	}
	Result = MdxReplyWithData(	MsgInfo,				/*	Original Msg	*/
							MdErrNoError,			/*	No Error Reply	*/
							(UInt8Ptr)ReplyText,	/*	Data			*/
							(TBufSize)strlen(ReplyText),		/*	Data Size		*/
							ApplTextReplyMsgCode,	/*	Msg Code		*/
							0,						/*	Priority		*/
							MdxSendReliable,		/*	Send Attributes	*/
													/*	Success/Failure	*/
													/*	Report			*/
							0,						/*	No ReqSeq		*/
							1000					/*	10 Secs	Timeout	*/
							);
	printf("Msg Displayed Ok Result = %d\n",Result);
}


void	ApplReplyWithTime(
TMdxSRMsgInfo  *MsgInfo
)
{
	TMdxTime	CurrTime;
	TMdxError	Result;
	CurrTime	=	MdxGetTime();
	Result =	MdxReplyWithData(	MsgInfo,				/*	Original Msg	*/
							MdErrNoError,			/*	No Error Reply	*/
							(UInt8Ptr)&CurrTime,	/*	Data			*/
							sizeof(CurrTime),		/*	Data Size		*/
							ApplGetTimeReplyCode,	/*	Msg Code		*/
							0,						/*	Priority		*/
							MdxSendReliable,		/*	Send Attributes	*/
													/*	Success/Failure	*/
													/*	Report			*/
							0,						/*	No ReqSeq		*/
							1000					/*	10 Secs	Timeout	*/
							);
	printf("Sending Time : Result = %d\n",Result);
}


void	ApplNewMsgReceived(
TMdxEvent	*Event
)
{
	TMdxSRMsgInfo	*MsgInfo;

	/*
	"Event->Data"	holds the information abount the new message.
	*/

	MsgInfo =	(TMdxSRMsgInfo	*)Event->Data;

	/*	First	thing is to check MsgCode of the new message	*/

	switch(MsgInfo->Received.MsgCode)
	{
		case	ApplGetTimeMsgCode	:
		{
			ApplReplyWithTime(MsgInfo);
		}
		break;
		case	ApplTextDataMsgCode :
		{
			ApplTextDataReceived(MsgInfo);
		}
		break;
		default 					:	break;
	}
}




void	ApplInitReceived(void)
{
	/*
	You may choose to use onw or more links of the types specified.
	Un comment the relevent "MdxOpenLink()".

	You may change the parameters for the links.
	*/


	TMdxLinkParams	LinkParams;
	memset(&LinkParams,0,sizeof(LinkParams));
	strcpy(LinkParams.LinkName.Byte,"com2");
	LinkParams.LinkType				=	MdxLinkTypeAsyncLocal;
	LinkParams.ConnectMode			=	MdxConnectModeListen;
	LinkParams.ConnectTimeout		=	0x7fffffff;
	LinkParams.MaxConnectRetries	=	-1;
	LinkParams.ConnectRetriesDelay	=	200;
	LinkParams.LinkBaud 			=	19200;
	LinkParams.UseDlcFraming		=	True;
	LinkParams.ImAliveInterval		=	400l;
	LinkParams.MaxPollRetries		=	2;
	LinkParams.L1MaxSendSize		=	256;
	/*
	MdxOpenLink(&LinkParams);
	*/
	memset(&LinkParams,0,sizeof(LinkParams));
	strcpy(LinkParams.LinkName.Byte,"MdxFs");
	LinkParams.LinkType				=	MdxLinkTypeSpxIpx;
	LinkParams.ConnectMode			=	MdxConnectModeListen;
	LinkParams.ConnectTimeout		=	1000;
	LinkParams.MaxConnectRetries	=	-1;
	LinkParams.ConnectRetriesDelay	=	200;
	LinkParams.UseDlcFraming		=	True;
	LinkParams.MaxPollRetries		=	10;
	LinkParams.L1MaxSendSize		=	500;
	/*
	MdxOpenLink(&LinkParams);
	*/

	memset(&LinkParams,0,sizeof(LinkParams));
	strcpy(LinkParams.LinkName.Byte,"MdxFs");
	LinkParams.LinkType				=	MdxLinkTypeNetBios;
	LinkParams.ConnectMode			=	MdxConnectModeListen;
	LinkParams.ConnectTimeout		=	0x7fffffffl;
	LinkParams.ConnectRetriesDelay	=	300l;
	LinkParams.L1MaxSendSize		=	1024;
	LinkParams.MaxConnectRetries	=	-1l;
	/*
	MdxOpenLink(&LinkParams);
	*/

}


void	cdecl	ApplEventHandler(
TMdxEvent	*Event
)
{
	switch(Event->Code)
	{
		case	MdxEventApplInit				:
		{
			ApplInitReceived();
		}
		break;
		case	MdxEvDataMsgReceived		:
		{
			ApplNewMsgReceived(Event);
		}
		break;
		case	MdxEvSendMsgCompleted		:
		{
			ApplSendMsgCompleted(Event);
		}
		break;
		case	MdxEvCallReqReceived		:
		{
			ApplCallReqReceived(Event);
		}
		break;
		case	MdxStdInAvailable				:
		{
			ApplShutdown	=	True;
		}
		break;
		default 								:	break;
	}
}


Int cdecl	main(
Int 	Argc,
Int8Ptr *Argv
)
{

	if (	Argc	<	2	)
	{
		printf("Usage : server <Proccess Id>\n");
		return(5);
	}
	MyId	=	(TMdxProcId)atol(Argv[1]);
	if (	MyId	<=	0	)
	{
		printf("Node Id Should be between 1 - %ld\n",0x7fffffffl);
		return(0);
	}

	MultiXStart(MyId,"Server",0,ApplEventHandler);

	printf("Type any key to stop the program...\n");
	while (	ApplShutdown	==	False	)
	{
		MultiXWaitEvent();
	}
	return(0);
}
