#include	"multix.h"

#include	<stdio.h>
#include	<stdlib.h>

#include	<string.h>
#include	<time.h>


#include	"appl.h"
TMdxProcId		MyId;

void	ApplReplyWithTime(
TMdxSRMsgInfo  *MsgInfo
)
{
	TMdxTime	CurrTime;
	TMdxError	Result;
	CurrTime	=	MdxGetTime();
	Result =	MdxReplyWithData(	MsgInfo,				/*	Original Msg	*/
							MdErrNoError,			/*	No Error Reply	*/
							(UInt8Ptr)&CurrTime,	/*	Data			*/
							sizeof(CurrTime),		/*	Data Size		*/
							ApplGetTimeReplyCode,	/*	Msg Code		*/
							0,						/*	Priority		*/
							MdxSendReliable,		/*	Send Attributes	*/
													/*	Success/Failure	*/
													/*	Report			*/
							0,						/*	No ReqSeq		*/
							1000					/*	10 Secs	Timeout	*/
							);
	printf("Sending Time : Result = %d\n",Result);
}


void	ApplNewMsgReceived(
TMdxEvent	*Event
)
{
	TMdxSRMsgInfo	*MsgInfo;

	/*
	"Event->Data"	holds the information abount the new message.
	*/

	MsgInfo =	(TMdxSRMsgInfo	*)Event->Data;

	/*	First	thing is to check MsgCode of the new message	*/

	switch(MsgInfo->Received.MsgCode)
	{
		case	ApplGetTimeMsgCode	:
		{
			ApplReplyWithTime(MsgInfo);
		}
		break;
	}
}


void	ApplTimerEvent(
TMdxEvent	*Event
)
{
	TMdxApplTimerInfo	TimerInfo;

	/*
	"Event->Data"	holds the information abount the timer.
	We use	"MdxGetApplTimerInfo()" to extract that info.
	*/

	MdxGetApplTimerInfo(Event->Data,&TimerInfo);

	switch(TimerInfo.Code)
	{
		case	ApplTimerDisplayTimer	:
		{
			time_t	Time	=	time(NullP);
			printf("Current Time Is : %s",ctime(&Time));
		}
		break;
		default :	break;
	}
}



void	ApplInitReceived(void)
{
	/*
	You may choose to use onw or more links of the types specified.
	Un comment the relevent "MdxOpenLink()".

	You may change the parameters for the links.
	*/


	TMdxLinkParams	LinkParams;
	memset(&LinkParams,0,sizeof(LinkParams));
	strcpy(LinkParams.LinkName.Byte,"com2");
	LinkParams.LinkType				=	MdxLinkTypeAsyncLocal;
	LinkParams.ConnectMode			=	MdxConnectModeListen;
	LinkParams.ConnectTimeout		=	0x7fffffff;
	LinkParams.MaxConnectRetries	=	-1;
	LinkParams.ConnectRetriesDelay	=	200;
	LinkParams.LinkBaud 			=	19200;
	LinkParams.UseDlcFraming		=	True;
	LinkParams.ImAliveInterval		=	400l;
	LinkParams.MaxPollRetries		=	2;
	LinkParams.L1MaxSendSize		=	256;
	/*
	MdxOpenLink(&LinkParams);
	*/
	memset(&LinkParams,0,sizeof(LinkParams));
	strcpy(LinkParams.LinkName.Byte,"MdxGateway");
	LinkParams.LinkType				=	MdxLinkTypeSpxIpx;
	LinkParams.ConnectMode			=	MdxConnectModeListen;
	LinkParams.ConnectTimeout		=	1000;
	LinkParams.MaxConnectRetries	=	-1;
	LinkParams.ConnectRetriesDelay	=	200;
	LinkParams.UseDlcFraming		=	True;
	LinkParams.MaxPollRetries		=	10;
	LinkParams.L1MaxSendSize		=	500;
	/*
	MdxOpenLink(&LinkParams);
	*/

	memset(&LinkParams,0,sizeof(LinkParams));
	strcpy(LinkParams.LinkName.Byte,"MdxGateway");
	LinkParams.LinkType				=	MdxLinkTypeNetBios;
	LinkParams.ConnectMode			=	MdxConnectModeListen;
	LinkParams.ConnectTimeout		=	0x7fffffffl;
	LinkParams.ConnectRetriesDelay	=	300l;
	LinkParams.L1MaxSendSize		=	1024;
	LinkParams.MaxConnectRetries	=	-1l;
	/*
	MdxOpenLink(&LinkParams);
	*/
	MdxSetApplTimer(ApplTimerDisplayTimer,6000,0,0,0,-1);
}


void	cdecl	ApplEventHandler(
TMdxEvent	*Event
)
{
	switch(Event->Code)
	{
		case	MdxEventApplInit				:
		{
			ApplInitReceived();
		}
		break;
		case	MdxTimerEvent					:
		{
			ApplTimerEvent(Event);
		}
		break;
		case	MdxStdInAvailable				:
		{
			ApplShutdown	=	True;
		}
		break;
		case	MdxEvProcessAdded		:
		{
			printf("Process Found = %s  (%ld)\n",Event->Data,Event->ProcId);
		}
		break;
		case	MdxEvProcessRemoved			:
		{
			printf("Process Lost = %s  (%ld)\n",Event->Data,Event->ProcId);
		}
		break;
		case	MdxEvLinkStatus		:
		{
			printf("Link %s , Status = %d\n",((TMdxLinkParams	*)Event->Data)->LinkName.Byte,Event->Error);
		}
		break;
		case	MdxEvCallReqReceived		:
		{
			MdxAcceptProcess(Event->ProcId,(void *)0);
		}
		break;
		case	MdxEvDataMsgReceived		:
		{
			ApplNewMsgReceived(Event);
		}
		break;
		default 								:	break;
	}
}


Int cdecl	main(
Int 	Argc,
Int8Ptr *Argv
)
{

	InitStack	=	&Argc;
	if (	Argc	<	2	)
	{
		printf("Usage : GateWay <Proccess Id>\n");
		return(5);
	}
	MyId	=	(TMdxProcId)atol(Argv[1]);
	if (	MyId	<=	0	)
	{
		printf("Node Id Should be between 1 - %ld\n",0x7fffffffl);
		return(0);
	}

	MultiXStart(MyId,"MultiX Gateway",-1,ApplEventHandler);

	printf("Type any key to stop the program...\n");
	while (	ApplShutdown	==	False	)
	{
		MultiXWaitEvent();
	}
	return(0);
}
