/*
 *    Copyright (c) Yaron Keren 1994-1996. All rights reserved.
 */
#include "file_3.h"
#include "file_20.h"
#include <assert.h>
#ifndef _BLAS1
extern "C" {
int idamax_(int *n, double *l_2, int *l_3)
{
double p, s;
int l_563, l_30, i, l_1373;
l_563= (*n);
if (l_563 <= 0) {
return 0;
}
s = 0.;
l_1373=(*l_3);
l_30=1;
double *pr;
pr=l_2;
for (i = 1; i<=l_563 ; i++) {
p=(*pr);
if (p<0)
p=-p;
if (p > s) {
l_30 = i;
s = p;
}
pr+=l_1373;
}
return l_30;
} 
double dasum_(int *n, double *x, int *l_3)
{
int l_563=(*n);
if (l_563 <= 0) {
return 0;
}
int l_1374=(*l_3);
assert(l_1374>0);
double s=0;
double *p=x;
for (int i=l_563;i;i--) {
s+=fabs(*p);
p+=l_1374;
}
return s;
} 
#ifndef _BLASM
void daxpy_(int *n, double *l_4, double *dx, int *l_3, double *dy, int *l_5)
{
int i,l_1374,l_1375,l_563;
double a,*x,*y;
l_563=*n;
if (l_563<=0) return;
a=*l_4;
if (a==0) return;
x=dx; y=dy;
l_1374=*l_3; l_1375=*l_5;
if (l_1374<0) {
x=x+(1-l_563)*l_1374;
}
if (l_1375<0) {
y=y+(1-l_563)*l_1375;
}
if (l_1374==1) {
if (l_1375==1) {
for (i=l_563/4;i;i--) {
*y=(*y)+a*(*x);
y++; x++;
*y=(*y)+a*(*x);
y++; x++;
*y=(*y)+a*(*x);
y++; x++;
*y=(*y)+a*(*x);
y++; x++;
}
} else {
for (i=l_563/4;i;i--) {
*y=(*y)+a*(*x);
y+=l_1375;
x++;
*y=(*y)+a*(*x);
y+=l_1375;
x++;
*y=(*y)+a*(*x);
y+=l_1375;
x++;
*y=(*y)+a*(*x);
y+=l_1375;
x++;
}
}
} else {
if (l_1375==1) {
for (i=l_563/4;i;i--) {
*y=(*y)+a*(*x);
y++;
x+=l_1374;
*y=(*y)+a*(*x);
y++;
x+=l_1374;
*y=(*y)+a*(*x);
y++;
x+=l_1374;
*y=(*y)+a*(*x);
y++;
x+=l_1374;
}
} else {
for (i=l_563/4;i;i--) {
*y=(*y)+a*(*x);
y+=l_1375;
x+=l_1374;
*y=(*y)+a*(*x);
y+=l_1375;
x+=l_1374;
*y=(*y)+a*(*x);
y+=l_1375;
x+=l_1374;
*y=(*y)+a*(*x);
y+=l_1375;
x+=l_1374;
}
}
}
for (i=l_563%4;i;i--) {
*y=(*y)+a*(*x);
y+=l_1375;
x+=l_1374;
}
} 
double ddot_(int *n, double *dx, int *l_3, double *dy, int *l_5)
{
int i,l_563;
int l_1374,l_1375;
double a,*x,*y;
l_563=*n;
if (l_563<=0) return 0;
a=0; x=dx; y=dy;
l_1374=*l_3; l_1375=*l_5;
if (l_1374==1) {
if (l_1375==1) {
for (i=l_563/4;i;i--) {
a+=x[0]*y[0]+x[1]*y[1]+x[2]*y[2]+x[3]*y[3];
y+=4;
x+=4;
}
} else {
for (i=l_563/4;i;i--) {
a+=(*x)*(*y)+x[1]*y[l_1375]+x[2]*y[2*l_1375]+x[3]*y[3*l_1375];
y+=4*l_1375;
x+=4;
}
}
} else {
if (l_1375==1) {
for (i=l_563/4;i;i--) {
a+=(*x)*(*y)+x[l_1374]*y[1]+x[2*l_1374]*y[2]+x[3*l_1374]*y[3];
y+=4;
x+=4*l_1374;
}
} else {
for (i=l_563/4;i;i--) {
a+=(*x)*(*y)+x[l_1374]*y[l_1375]+x[2*l_1374]*y[2*l_1375]+x[3*l_1374]*y[3*l_1375];
y+=4*l_1375;
x+=4*l_1374;
}
}
}
for (i=l_563%4;i;i--) {
a+=(*x)*(*y);
y+=l_1375;
x+=l_1374;
}
return a;
} 
#endif 
int dcopy_(int *n, double *dx, int *l_3, double *dy, int *l_5) {
  int l_563=(*n);
if (l_563 <= 0) {
return 0;
}
int l_1374=(*l_3);
assert(l_1374>0);
int l_1375=(*l_5);
assert(l_1375>0);
double *x=dx;
double *y=dy;
for (int i=l_563;i;i--) {
(*y)=(*x);
x+=l_1374;
y+=l_1375;
}
return 0;
} 
double dnrm2_(int *n, double *dx, int *l_3) {
int l_563=(*n);
if (l_563 <= 0) {
return 0;
}
int l_1374=(*l_3);
assert(l_1374>0);
double *x=dx;
double s=0;
for (int i=l_563;i;i--) {
s=l_395(&s,x);
x+=l_1374;
}
return s;
} 
int drot_(int *n, double *dx, int *l_3, double *dy, int *l_5,
double *c, double *s) {
int l_563, i, l_1374, l_1375;
double l_1376, l_937, ss;
l_563=(*n);
l_937=(*c);
ss=(*s);
if (l_563 <= 0) {
return 0;
}
if (*l_3 == 1 && *l_5 == 1) {
double *l_1377=dx, *l_1378=dy;
for (i = l_563 ; i ; i--) {
l_1376  = l_937 * (*l_1377) + ss * (*l_1378);
(*l_1378) = l_937 * (*l_1378) - ss * (*l_1377);
(*l_1377) = l_1376;
l_1377++; l_1378++;
}
} else {
l_1374 = 0;
l_1375 = 0;
if (*l_3 < 0) {
l_1374 = (-l_563 + 1) * *l_3;
}
if (*l_5 < 0) {
l_1375 = (-l_563 + 1) * *l_5;
}
for (i = 0; i < l_563; i++) {
l_1376 = l_937 * dx[l_1374] + ss * dy[l_1375];
dy[l_1375] = l_937 * dy[l_1375] - ss * dx[l_1374];
dx[l_1374] = l_1376;
l_1374 += *l_3;
l_1375 += *l_5;
}
}
return 0;
} 
 int drotg_(double *l_4, double *l_6, double *c,
double *s)
{
double l_501, l_529;
double r, l_62, l_64, l_1379;
double l_476=1.0;
l_1379 = *l_6;
if (fabs(*l_4) > fabs(*l_6)) {
l_1379 = *l_4;
}
l_62 = fabs(*l_4) + fabs(*l_6);
if (l_62 != 0.) {
goto l_655;
}
*c = 1.;
*s = 0.;
r = 0.;
goto l_508;
l_655:
l_501 = *l_4 / l_62;
l_529 = *l_6 / l_62;
r = l_62 * sqrt(l_501 * l_501 + l_529 * l_529);
r = l_200(&l_476, &l_1379) * r;
*c = *l_4 / r;
*s = *l_6 / r;
l_508:
l_64 = *s;
if (fabs(*c) > 0. && fabs(*c) <= *s) {
l_64 = 1. / *c;
}
*l_4 = r;
*l_6 = l_64;
return 0;
} 
 int ddrotm_(int *n, double *dx, int *l_3,
double *dy, int *l_5, double *l_7)
{
double l_916 = 0.;
double l_1380 = 2.;
int l_499, l_500;
int i;
double l_1381, l_268, l_64;
int l_1382, l_1383, l_1384;
double l_1385, l_1386, l_1387, l_1388;
--l_7;
--dy;
--dx;
l_1381 = l_7[1];
if (*n <= 0 || l_1381 + l_1380 == l_916) {
goto l_515;
}
if (! (*l_3 == *l_5 && *l_3 > 0)) {
goto l_585;
}
l_1384 = *n * *l_3;
if (l_1381 < 0.) {
goto l_509;
} else if (l_1381 == 0) {
goto l_655;
} else {
goto l_1152;
}
l_655:
l_1386 = l_7[4];
l_1388 = l_7[3];
l_499 = l_1384;
l_500 = *l_3;
for (i = 1; l_500 < 0 ? i >= l_499 : i <= l_499; i += l_500) {
l_268 = dx[i];
l_64 = dy[i];
dx[i] = l_268 + l_64 * l_1386;
dy[i] = l_268 * l_1388 + l_64;
}
goto l_515;
l_1152:
l_1385 = l_7[2];
l_1387 = l_7[5];
l_500 = l_1384;
l_499 = *l_3;
for (i = 1; l_499 < 0 ? i >= l_500 : i <= l_500; i += l_499) {
l_268 = dx[i];
l_64 = dy[i];
dx[i] = l_268 * l_1385 + l_64;
dy[i] = -l_268 + l_1387 * l_64;
}
goto l_515;
l_509:
l_1385 = l_7[2];
l_1386 = l_7[4];
l_1388 = l_7[3];
l_1387 = l_7[5];
l_499 = l_1384;
l_500 = *l_3;
for (i = 1; l_500 < 0 ? i >= l_499 : i <= l_499; i += l_500) {
l_268 = dx[i];
l_64 = dy[i];
dx[i] = l_268 * l_1385 + l_64 * l_1386;
dy[i] = l_268 * l_1388 + l_64 * l_1387;
}
goto l_515;
l_585:
l_1382 = 1;
l_1383 = 1;
if (*l_3 < 0) {
l_1382 = (1 - *n) * *l_3 + 1;
}
if (*l_5 < 0) {
l_1383 = (1 - *n) * *l_5 + 1;
}
if (l_1381 < 0.) {
goto l_514;
} else if (l_1381 == 0) {
goto l_510;
} else {
goto l_507;
}
l_510:
l_1386 = l_7[4];
l_1388 = l_7[3];
l_500 = *n;
for (i = 1; i <= l_500; ++i) {
l_268 = dx[l_1382];
l_64 = dy[l_1383];
dx[l_1382] = l_268 + l_64 * l_1386;
dy[l_1383] = l_268 * l_1388 + l_64;
l_1382 += *l_3;
l_1383 += *l_5;
}
goto l_515;
l_507:
l_1385 = l_7[2];
l_1387 = l_7[5];
l_500 = *n;
for (i = 1; i <= l_500; ++i) {
l_268 = dx[l_1382];
l_64 = dy[l_1383];
dx[l_1382] = l_268 * l_1385 + l_64;
dy[l_1383] = -l_268 + l_1387 * l_64;
l_1382 += *l_3;
l_1383 += *l_5;
}
goto l_515;
l_514:
l_1385 = l_7[2];
l_1386 = l_7[4];
l_1388 = l_7[3];
l_1387 = l_7[5];
l_500 = *n;
for (i = 1; i <= l_500; ++i) {
l_268 = dx[l_1382];
l_64 = dy[l_1383];
dx[l_1382] = l_268 * l_1385 + l_64 * l_1386;
dy[l_1383] = l_268 * l_1388 + l_64 * l_1387;
l_1382 += *l_3;
l_1383 += *l_5;
}
l_515:
return 0;
} 
 int drotmg_(double *l_8, double *l_9, double *
l_10, double *l_11, double *l_7)
{
double l_916 = 0.0;
double l_476 = 1.0;
double l_1380 = 2.0;
double l_1389 = 4096.0;
double l_1390 = 16777216.0;
double l_1391 = 5.9604645e-8;
double l_501;
double l_1381, l_1376, l_1392, l_1393, l_1394, l_1395, l_1396,
l_1385=0, l_1388=0, l_1386=0, l_1387=0;
int l_1397=0;
--l_7;
if (! (*l_8 < l_916)) {
goto l_655;
}
goto l_584;
l_655:
l_1394 = *l_9 * *l_11;
if (! (l_1394 == l_916)) {
goto l_508;
}
l_1381 = -l_1380;
goto l_561;
l_508:
l_1393 = *l_8 * *l_10;
l_1395 = l_1394 * *l_11;
l_1396 = l_1393 * *l_10;
if (! (fabs(l_1396) > fabs(l_1395))) {
goto l_911;
}
l_1388 = -(*l_11) / *l_10;
l_1386 = l_1394 / l_1393;
l_1392 = l_476 - l_1386 * l_1388;
if (! (l_1392 <= l_916)) {
goto l_1152;
}
goto l_584;
l_1152:
l_1381 = l_916;
*l_8 /= l_1392;
*l_9 /= l_1392;
*l_10 *= l_1392;
goto l_507;
l_911:
if (! (l_1395 < l_916)) {
goto l_509;
}
goto l_584;
l_509:
l_1381 = l_476;
l_1385 = l_1393 / l_1394;
l_1387 = *l_10 / *l_11;
l_1392 = l_476 + l_1385 * l_1387;
l_1376 = *l_9 / l_1392;
*l_9 = *l_8 / l_1392;
*l_8 = l_1376;
*l_10 = *l_11 * l_1392;
goto l_507;
l_584:
l_1381 = -l_476;
l_1385 = l_916;
l_1386 = l_916;
l_1388 = l_916;
l_1387 = l_916;
*l_8 = l_916;
*l_9 = l_916;
*l_10 = l_916;
goto l_522;
l_585:
if (! (l_1381 >= l_916)) {
goto l_687;
}
if (! (l_1381 == l_916)) {
goto l_510;
}
l_1385 = l_476;
l_1387 = l_476;
l_1381 = -l_476;
goto l_687;
l_510:
l_1388 = -l_476;
l_1386 = l_476;
l_1381 = -l_476;
l_687:
switch (l_1397) {
case 0: goto l_514;
case 1: goto l_516;
case 2: goto l_544;
case 3: goto l_521;
}
l_507:
l_513:
if (! (*l_8 <= l_1391)) {
goto l_511;
}
if (*l_8 == l_916) {
goto l_545;
}
l_1397 = 0;
goto l_585;
l_514:
l_501 = l_1389;
*l_8 *= l_501 * l_501;
*l_10 /= l_1389;
l_1385 /= l_1389;
l_1386 /= l_1389;
goto l_513;
l_511:
l_515:
if (! (*l_8 >= l_1390)) {
goto l_545;
}
l_1397 = 1;
goto l_585;
l_516:
l_501 = l_1389;
*l_8 /= l_501 * l_501;
*l_10 *= l_1389;
l_1385 *= l_1389;
l_1386 *= l_1389;
goto l_515;
l_545:
l_517:
if (! (fabs(*l_9) <= l_1391)) {
goto l_518;
}
if (*l_9 == l_916) {
goto l_522;
}
l_1397 = 2;
goto l_585;
l_544:
l_501 = l_1389;
*l_9 *= l_501 * l_501;
l_1388 /= l_1389;
l_1387 /= l_1389;
goto l_517;
l_518:
l_519:
if (! (fabs(*l_9) >= l_1390)) {
goto l_522;
}
l_1397 = 3;
goto l_585;
l_521:
l_501 = l_1389;
*l_9 /= l_501 * l_501;
l_1388 *= l_1389;
l_1387 *= l_1389;
goto l_519;
l_522:
if (l_1381 < 0.) {
goto l_560;
} else if (l_1381 == 0) {
goto l_523;
} else {
goto l_524;
}
l_523:
l_7[3] = l_1388;
l_7[4] = l_1386;
goto l_561;
l_524:
l_7[2] = l_1385;
l_7[5] = l_1387;
goto l_561;
l_560:
l_7[2] = l_1385;
l_7[3] = l_1388;
l_7[4] = l_1386;
l_7[5] = l_1387;
l_561:
l_7[1] = l_1381;
return 0;
} 
int dscal_(int *n, double *l_4, double *dx, int *l_3) {
int l_100=(*n);
if (l_100 <= 0) {
return 0;
}
double *pr=dx, d=(*l_4);
int l_1374=(*l_3);
for (int i = l_100; i ; i--) {
(*pr)*=d;
pr+=l_1374;
}
return 0;
} 
int dswap_(int *n, double *dx, int *l_3, double *dy, int *l_5) {
int l_563=(*n);
if (l_563 <= 0) {
return 0;
}
int l_1374=(*l_3);
assert(l_1374>0);
int l_1375=(*l_5);
assert(l_1375>0);
double *x=dx;
double *y=dy;
for (int i=l_563;i;i--) {
double t=(*x);
(*x)=(*y);
(*y)=t;
x+=l_1374;
y+=l_1375;
}
return 0;
} 
} 
#endif 
int l_12(int *n, double *l_2, double *l_13, int *l_3)
{
double d, p, s;
int l_563, l_30, i, l_1373;
l_563= (*n);
if (l_563 <= 0) {
return 0;
}
s = 0.;
l_1373=(*l_3);
l_30=1;
double *pr, *pi;
pr=l_2; pi=l_13;
for (i = 1; i<=l_563 ; i++) {
p=(*pr);
d=(*pi);
if (p<0)
p=-p;
if (d>0)
p=p+d;
else
p=p-d;
if (p > s) {
l_30 = i;
s = p;
}
pr+=l_1373; pi+=l_1373;
}
return l_30;
} 
double l_14(int *n, double *l_2, double *l_13, int *l_3)
{
return dasum_(n, l_2, l_3)+dasum_(n, l_13, l_3);
} 
void l_15(int *n, double *l_16, double *si, double *l_2, double *l_13, int *l_3,
double *l_17, double *l_18, int *l_5)
{
double l_547=-(*si);
daxpy_(n,  l_16, l_2, l_3, l_17, l_5);
daxpy_(n,&l_547, l_13, l_3, l_17, l_5);
daxpy_(n,  si, l_2, l_3, l_18, l_5);
daxpy_(n,  l_16, l_13, l_3, l_18, l_5);
return;
}
void l_19(int *n, double *l_16, double *si, double *l_2, double *l_13, int *l_3,
double *l_17, double *l_18, int *l_5)
{
double l_1398=-(*l_16);
daxpy_(n,  l_16, l_2, l_3, l_17, l_5);
daxpy_(n,  si, l_13, l_3, l_17, l_5);
daxpy_(n,  si, l_2, l_3, l_18, l_5);
daxpy_(n,&l_1398, l_13, l_3, l_18, l_5);
return;
}
double l_21(int *n, double *l_2, double *l_13, int *l_3, double *l_17, double *l_18, int *l_5)
{
return( ddot_(n, l_2, l_3, l_18, l_5) -
ddot_(n, l_13, l_3, l_17, l_5) );
}
double l_22(int *n, double *l_2, double *l_13, int *l_3, double *l_17, double *l_18, int *l_5)
{
return( ddot_(n, l_2, l_3, l_17, l_5) +
ddot_(n, l_13, l_3, l_18, l_5) );
}
double l_23(int *n, double *l_2, double *l_13, int *l_3, double *l_17, double *l_18, int *l_5)
{
return( ddot_(n, l_2, l_3, l_18, l_5) +
ddot_(n, l_13, l_3, l_17, l_5) );
}
double l_24(int *n, double *l_2, double *l_13, int *l_3, double *l_17, double *l_18, int *l_5)
{
return( ddot_(n, l_2, l_3, l_17, l_5) -
ddot_(n, l_13, l_3, l_18, l_5) );
}
void l_20(int *n, double *l_2, double *l_13, int *l_3, double *l_17, double *l_18,
int *l_5) {
dcopy_(n,l_2,l_3,l_17,l_5);
dcopy_(n,l_13,l_3,l_18,l_5);
} 
double l_25(int *n, double *l_2, double *l_13, int *l_3) {
double r=dnrm2_(n,l_2,l_3);
double i=dnrm2_(n,l_13,l_3);
return l_395(&r,&i);
} 
void l_26(int *n, double *s, double *l_2, double *l_13, int *l_3) {
dscal_(n,s,l_2,l_3);
dscal_(n,s,l_13,l_3);
} 
void l_26(int *n, double *l_16, double *si, double *l_2, double *l_13, int *l_3) {
int l_100=(*n);
if (l_100 <= 0) {
return;
}
double *pr=l_2, *pi=l_13, l_692=(*l_16), di=(*si);
int l_1374=(*l_3);
for (int i = l_100; i ; i--) {
double t=(*pr);
(*pr)=(*pr)*l_692-(*pi)*di;
(*pi)=t*di+(*pi)*l_692;
pr+=l_1374;
pi+=l_1374;
}
} 
void l_27(int *n, double *l_2, double *l_13, int *l_3, double *l_17, double *l_18,
int *l_5) {
dswap_(n,l_2,l_3,l_17,l_5);
dswap_(n,l_13,l_3,l_18,l_5);
} 
void set(int *n, double *dx, double *dy, int *l_5) {
int l_100=(*n);
if (l_100 <= 0) {
return;
}
double *pr=dy,l_692=(*dx);
int l_1375=(*l_5);
assert(l_1375>0);
for (int i = l_100; i ; i--) {
(*pr)=l_692;
pr+=l_1375;
}
} 
void set(int *n, double *l_2, double *l_13, double *l_17, double *l_18, int *l_5) {
set(n,l_2,l_17,l_5);
set(n,l_13,l_18,l_5);
} 
