/*
 *    Copyright (c) Yaron Keren 1994-1996. All rights reserved.
 */
#ifndef __MATLIB_H
#define __MATLIB_H
#include <stddef.h>
#include <math.h>
#define M_MATRIX 0
#define M_TEXT	 1
union i_o_t {
int i;
int o;
};
class Mr;
class M {
char *name;
int type;
int m;
int n;
int p;
double *pr;
double *pi;
void allocate_double();
void delete_double();
public:
M();
M(int l_260,int l_261);
M(int l_260,int l_261, char *l_262);
M(char *l_262, double l_263, double l_264=0);
M(char *l_262, char *text);
M(double val);
M(char *text);
M(const M& l_57);
M(const Mr& l_57);
~M();
void operator =(double val);
void operator =(char *text);
void operator =(const M& l_57);
void operator =(const Mr& l_57);
void deepcopy(const M& l_57);
int rows() const { return(m); }
int cols() const { return(n); }
int size() const { return(m*n); }
int gettype() const { return(type); }
void settype(int t) { type=t; }
char *getname() const { return(name); }
int dirty() const;
double *addr() const { return(pr); }
double *addr(int row,int col) const { return(pr?(pr+row-1+(col-1)*m):(double *)NULL); }
double *addi() const { return(pi); }
double *addi(int row,int col) const { return(pi?(pi+row-1+(col-1)*m):(double *)NULL); }
double& r() const;
double& r(double l_265) const;
double& r(double row, double col) const;
double& i() const;
double& i(double l_265) const;
double& i(double row, double col) const;
Mr operator ()(M l_57);
Mr operator ()(M l_266, M l_267);
void vwcopy(const M& l_57, const M& v);
void vwcopy(const M& l_57, const M& v, const M& l_268);
friend void rowcol(M& x);
};
class Mr {
friend class M;
int indexed;
M& data;
M idxr;
M idxc;
public:
Mr(M& l_57);
Mr(M& l_57, M& index);
Mr(M& l_57, M& l_284, M& l_285);
~Mr();
int rows();
int cols();
int size();
int gettype();
void settype(int t);
char *getname();
double *addr();
double *addr(int row,int col);
double *addi();
double *addi(int row,int col);
void operator =(double val);
void operator =(const M& l_57);
void operator =(const Mr& l_57);
Mr operator ()(M& l_57);
Mr operator ()(M& l_266, M& l_267);
};
M operator <(M x, M y);
M operator >(M x, M y);
M operator <=(M x, M y);
M operator >=(M x, M y);
M operator ==(M x, M y);
M operator !=(M x, M y);
M operator ||(M x, M y);
M operator &&(M x, M y);
M operator +(M x, M y);
M operator -(M x, M y);
M dot_add(M x, M y);
M dot_sub(M x, M y);
M dot_mul(M x,M y);
M dot_div(M x,M y);
M dot_invdiv(M x,M y);
M dot_pow(M x,M y);
M atan2(M x,M y);
M rem(M x,M y);
M min(M x,M y);
M min0(M x,M y);
M max(M x,M y);
M pow2(M f, M l_1);
M xorM(M x, M y);
void operator +=(M& x, M y);
void operator -=(M& x, M y);
void operator *=(M& x, M y);
void operator /=(M& x, M y);
void operator ++(M x);
void operator --(M x);
M all(M x);
M any(M x);
M max(M x);
M min(M x);
M sum(M x);
M sumabs(M x);
M prod(M x);
M colon(double j, double i, double l_30);
M colon(M l_44, M l_45, M l_46);
extern M nargin, nargout;
extern int nargin_set, nargout_set;
extern M TICTOC, eps, version, Inf, NaN, nop_M;
extern M i,j,pi,zero_M,one_M,two_M,junk_M, sixpack_M, lasterr, mfilename;
extern M stdinM, stdoutM, stderrM;
extern M s_M, l_M, c_p;
extern char *s_s, *l_s;
extern double s_d, l_d;
extern double *s_Mp, *l_Mp, *x_Mp, *c_pp;
extern i_o_t i_o;
typedef M func1M(M);
typedef M func2M(M, M);
typedef M func3M(M, M, M);
typedef M func4M(M, M, M, M);
M junk_func1M(M);
M junk_func2M(M,M);
M junk_func3M(M,M,M);
M junk_func4M(M,M,M,M);
class D {
double d;
char *name;
public:
D(double v) { name=NULL; d=v; }
D(int, int, char *dname) { name=dname; d=0; }
D(const M& l_57);
operator double() const { return d; }
char* getname() const { return name; }
double operator +=(double v) { d+=v; return d; }
double operator -=(double v) { d-=v; return d; }
double operator *=(double v) { d*=v; return d; }
double operator /=(double v) { d/=v; return d; }
void operator ++() { d++; }
void operator --() { d--; }
};
M diag(M x);
M diag(M x, M l_58);
void memreport();
double *newdouble(int size);
char *newchar(int size);
char **newcharptr(int size);
int *newint(int size);
long *newlong(int size);
void deletedouble(double *p);
void deletechar(char *p);
void deletecharptr(char **p);
void deleteint(int *p);
void deletelong(long *p);
typedef double	*double_p;
typedef int	*int_p;
void copy_double(double *l_286, double *l_57, int n);
void fill_double(double *l_286, int n, double val);
void zero_double(double *l_286, int n);
void zero_char(char *l_286, int n);
M error(char *s);
M error(char *s, char *l_95);
M error(char *s, char *l_95, char *l_96);
M error(char *s, char *l_95, char *l_96, char *l_97);
M error(char *s, char *l_95, char *l_96, char *l_97, char *l_98);
M error(char *s, char *l_95, char *l_96, char *l_97, char *l_98, char *l_99);
M warning(char *s);
M warning(char *s, char *l_95);
M warning(char *s, char *l_95, char *l_96);
M eye(M x);
M eye(M x, M y);
M ones(double m);
M ones(double m, double n);
M ones(M x);
M ones(M x, M y);
M randM();
M randM(M x);
M randM(M x, M y);
M randn();
M randn(M x);
M randn(M x, M y);
M zeros(double m);
M zeros(double m, double n);
M zeros(M x);
M zeros(M x, M y);
M fft(M x);
M fft(M x, M l_100);
M ifft(M x);
M ifft(M x, M l_100);
M dft(M x);
M fcloseM(M l_133);
M feofM(M l_133);
M ferrorM(M l_133, M clear=zero_M);
M ferrorM(M l_133, i_o_t, Mr l_134, Mr l_135);
M ferrorM(M l_133, M clear, i_o_t, Mr l_134, Mr l_135);
M fopenM(M filename, M l_136="r", M l_137="n");
M fopenM(M filename, i_o_t, Mr l_133, Mr l_134);
M fopenM(M filename, M l_136, i_o_t, Mr l_133, Mr l_134);
M fopenM(M filename, M l_136, M l_137, i_o_t, Mr l_133, Mr l_134);
M fprintfM(M l_138);
M fprintfM(M l_133, M format, M a=l_M, M l_33=l_M, M c=l_M, M d=l_M, M l_1=l_M, M f=l_M);
M printfM(M format, M a=l_M, M l_33=l_M, M c=l_M, M d=l_M, M l_1=l_M, M f=l_M);
M fread(M l_133, M size=Inf, M precision="\165c\150ar", M skip=zero_M);
M fread(M l_133, i_o_t, Mr l_139, Mr l_140);
M fread(M l_133, M size, i_o_t, Mr l_139, Mr l_140);
M fread(M l_133, M size, M precision, i_o_t, Mr l_139, Mr l_140);
M fread(M l_133, M size, M precision, M skip, i_o_t, Mr l_139, Mr l_140);
M frewind(M l_133);
M fscanfM(M l_133, M format);
M fscanfM(M l_133, M format, M size);
M fscanfM(M l_133, M format, M size, i_o_t, Mr l_139, Mr l_140);
M fscanfM(M l_133, M format, M size, i_o_t, Mr l_139, Mr l_140, Mr l_141);
M fseek(M l_133, M offset, M l_142);
M ftell(M l_133);
M fwrite(M l_133, M l_139, M precision="\165c\150ar", M skip=zero_M);
M ltitr(M a, M l_33, M l_143, M l_144);
M ltifr(M a, M l_33, M s);
M filter(M l_33, M a, M x);
M filter(M l_33, M a, M x, M l_66);
M filter(M l_33, M a, M x, i_o_t, Mr y, Mr l_145);
M filter(M l_33, M a, M x, M l_66, i_o_t, Mr y, Mr l_145);
M axis();
M axis(M a);
M contour(M l_148);
M contour(M X, M l_149, M l_148);
M contour(M l_148, M l_100);
M contour(M X, M l_149, M l_148, M l_100);
M drawnow();
M errorbar(M y, M l_150);
M errorbar(M x, M y, M l_150);
M errorbar(M x, M y, M l_150, M l_143);
M grid();
M grid(M a);
M hold(M a);
M ishold();
M loglog(M y);
M loglog(M l_151	 ,  M l_152    ,  M l_153=l_M,  M l_154=l_M,  M l_155=l_M,
M l_156=l_M,  M l_157=l_M,  M l_158=l_M,  M l_159=l_M,  M l_160=l_M,
M l_161=l_M, M l_162=l_M, M l_163=l_M, M l_164=l_M, M l_165=l_M);
M mesh(M l_148);
M mesh(M x, M y, M l_64);
M meshc(M l_148);
M meshc(M x, M y, M l_64);
M meshdom(M x, M y, i_o_t, Mr X, Mr l_149);
M plot(M y);
M plot(M l_151    ,  M l_152	  ,  M l_153=l_M,	M l_154=l_M,  M l_155=l_M,
M l_156=l_M,  M l_157=l_M,  M l_158=l_M,	M l_159=l_M,  M l_160=l_M,
M l_161=l_M, M l_162=l_M, M l_163=l_M, M l_164=l_M, M l_165=l_M);
M polar(M y);
M polar(M l_151	,  M l_152    ,  M l_153=l_M,  M l_154=l_M,  M l_155=l_M,
M l_156=l_M,  M l_157=l_M,  M l_158=l_M,  M l_159=l_M,  M l_160=l_M,
M l_161=l_M, M l_162=l_M, M l_163=l_M, M l_164=l_M, M l_165=l_M);
M semilogx(M y);
M semilogx(M l_151    ,  M l_152    ,  M l_153=l_M,  M l_154=l_M,  M l_155=l_M,
M l_156=l_M,   M l_157=l_M,  M l_158=l_M,  M l_159=l_M,  M l_160=l_M,
M l_161=l_M,  M l_162=l_M, M l_163=l_M, M l_164=l_M, M l_165=l_M);
M semilogy(M y);
M semilogy(M l_151    ,  M l_152    ,  M l_153=l_M,  M l_154=l_M,  M l_155=l_M,
M l_156=l_M,   M l_157=l_M,  M l_158=l_M,  M l_159=l_M,  M l_160=l_M,
M l_161=l_M,  M l_162=l_M, M l_163=l_M, M l_164=l_M, M l_165=l_M);
M quiver(M x);
M quiver(M x, M y);
M quiver(M x, M y, M s);
M text(M x, M y, M a);
M title(M a,...);
M shg();
M view(M a);
M view(M l_166, M l_167);
M xlabel(M a,...);
M ylabel(M a,...);
M zlabel(M a,...);
M bmpwrite(M l_168, M l_169, M filename);
M image(M l_168);
M colormap(M l_169);
M black(M l_150=64);
M gray(M l_150=64);
M grey(M l_150=64);
M white(M l_150=64);
M axes(...);
M cla(...);
M close(...);
M clf(...);
M figure(...);
M gca(...);
M gcf(...);
M get(...);
M line(...);
M newplot(...);
M reset(...);
M set(...);
M subplot(...);
M surf(...);
M surface(...);
M waitforbuttonpress(...);
M wavwrite(M l_170, M l_171, M filename);
M soundM(M y, M l_171=8192.0);
int isempty(M x);
M   isglobal(M);
int isreal(M x);
int issame(M x, M y);
M   issparse(M);
int isstr(M x);
int istrue(M x);
int istrue(double x);
M balance(M a);
M balance(M a, i_o_t, Mr t, Mr l_33);
M chol(M l_33);
M chol(M x, i_o_t, Mr l_211, Mr p);
M cond(M x);
M det(M x);
M dongarra(M x);
M eig(M x);
M eig(M x, i_o_t, Mr v, Mr d);
M eig(M a, M l_33);
M eig(M a, M l_33, i_o_t, Mr v, Mr d);
M expm(M l_139);
M hess(M a);
M hess(M a, i_o_t, Mr p, Mr h);
M inv(M x);
M invdiv(M a, M l_33);
M lu(M x);
M lu(M x, i_o_t, Mr l_150, Mr l_143);
M lu(M x, i_o_t, Mr l_150, Mr l_143, Mr p);
M norm(M x, M l_212=two_M);
M operator /(M x, M y);
M powM(M x,M y);
M qr(M x);
M qr(M x, M);
M qr(M x, i_o_t, Mr l_213, Mr r);
M qr(M x, M, i_o_t, Mr l_213, Mr r);
M qr(M x, i_o_t, Mr l_213, Mr r, Mr l_1);
M qr(M x, M, i_o_t, Mr l_213, Mr r, Mr l_1);
M qz(M a, M l_33, i_o_t, Mr l_214, Mr l_215);
M qz(M a, M l_33, i_o_t, Mr l_214, Mr l_215, Mr l_213);
M qz(M a, M l_33, i_o_t, Mr l_214, Mr l_215, Mr l_213, Mr l_64);
M qz(M a, M l_33, i_o_t, Mr l_214, Mr l_215, Mr l_213, Mr l_64, Mr v);
M rank(M x);
M rank(M x, M l_216);
M rcond(M x);
M schur(M x);
M schur(M x, i_o_t, Mr l_143, Mr t);
M svd(M x);
M svd(M x, M l_64);
M svd(M x, i_o_t, Mr U, Mr l_217, Mr l_218);
M svd(M x, M l_64, i_o_t, Mr U, Mr l_217, Mr l_218);
M hilb(M n);
M invhilb(M n);
M magic(M n);
M pascalM(M n, M r=zero_M);
M clear(Mr x);
M computer(i_o_t, Mr c, Mr l_274);
M computer();
M cputime();
M diff(M x, M l_275=one_M);
M echo(char* l_276);
M etime(M l_277, M l_278);
M exit();
M eval(...);
M exist(M x);
M feval(...);
M find(M x);
M find(M x, i_o_t, Mr l_279, Mr l_280);
M find(M x, i_o_t, Mr l_279, Mr l_280, Mr v);
int forsize(M& x);
void forelem(M& l_281, M& x, int index);
M full(M x);
M flops(M x);
M flops();
M getenv(M x);
M isieee();
M joinrows(M a, M l_33);
M joincols(M a, M l_33);
M linspace(M l_282, M l_283, M n=100);
M logspace(M l_282, M l_283, M n=50);
M matlabpath();
M matlabpath(M x);
M mean(M x);
M nnz(M x);
M nonzeros(M x);
M quit();
M reshape(M x, M m, M n);
M setstr(M x);
M sparse(...);
M spdiags(...);
M spparms(...);
M tic();
M toc();
M then();
#ifdef MATLAB_MEX_FILE
extern "C" {
}
M Matrix2M(const Matrix& l_287);
void M2Matrix(const M& X, Matrix & l_287);
#endif M min(M x, i_o_t, Mr y, Mr i);
M max(M x, i_o_t, Mr y, Mr i);
#include <iostream.h>
extern istream *matlibin_p;
extern ostream *matlibout_p, *matliberr_p;
#define matlibin (*matlibin_p)
#define matlibout (*matlibout_p)
#define matliberr (*matliberr_p)
M operator *(M x, M y);
#ifdef finite
#undef finite
#endif
#ifdef isinf
#undef isinf
#endif
#ifdef isnan
#undef isnan
#endif
M cos(M x);
M sin(M x);
M tan(M x);
M sec(M x);
M csc(M x);
M cot(M x);
M acos(M x);
M asin(M x);
M atan(M x);
M asec(M x);
M acsc(M x);
M acot(M x);
M cosh(M x);
M sinh(M x);
M tanh(M x);
M sech(M x);
M csch(M x);
M coth(M x);
M acosh(M x);
M asinh(M x);
M atanh(M x);
M asech(M x);
M acsch(M x);
M acoth(M x);
M operator !(M x);
M operator -(M x);
M abs(M x);
M angle(M x);
M arg(M x);
M ceil(M x);
M cumprod(M x);
M cumsum(M x);
M conj(M x);
M exp(M x);
M finite(M x);
M fix(M x);
M floor(M x);
M imag(M x);
M isinf(M x);
M isnan(M x);
M log(M x);
M log10(M x);
M real(M x);
M round(M x);
M sign(M x);
M sqrtM(M x);
M tril(M x);
M triu(M x);
M tril(M x, M y);
M triu(M x, M y);
M log2(M x);
M log2(M x, i_o_t, Mr f, Mr l_1);
M pow2(M x);
double abs(double x);
double abs(double l_2, double l_13);
double max(double x, double y);
double max(double x, double y, double l_64);
double min(double x, double y);
double rem(double x, double y);
double round(double x);
M length(M x);
M size(M x);
M size(M x, M type);
M size(M x, i_o_t, Mr l_288, Mr l_289);
M sort(M x);
M sort(M x, i_o_t, Mr l_217, Mr l_279);
M int2str(M x);
M num2str(M x, M l_290=4);
M sscanfM(M s, M format);
M sscanfM(M s, M format, M size);
M sscanfM(M s, M format, M size, i_o_t, Mr l_139, Mr l_140);
M sscanfM(M s, M format, M size, i_o_t, Mr l_139, Mr l_140, Mr l_141);
M sprintfM(M l_138);
M sprintfM(M format, M a, M l_33=l_M, M c=l_M, M d=l_M, M l_1=l_M, M f=l_M);
M str2mat(M l_151=l_M,  M l_152=l_M,	M l_153=l_M,  M l_154=l_M,  M l_155=l_M,
M l_156=l_M,  M l_157=l_M,	M l_158=l_M,  M l_159=l_M,  M l_160=l_M,
M l_161=l_M, M l_162=l_M, M l_163=l_M, M l_164=l_M, M l_165=l_M);
M strcmp(M a, M l_33);
void initM(istream& l_291, ostream& l_292, ostream& l_293);
void exitM(void);
M brackets(int type,...);
M cd();
M cd(M dir);
M clockM();
M deleteM(M filename);
M dir();
M dos(M l_294);
M load(char *l_295, M& a=l_M, M& l_33=l_M, M& c=l_M, M& d=l_M, M& l_1=l_M, M& f=l_M);
M loadascii(char *l_295, M& a);
M save(char *l_295, M a=l_M, M l_33=l_M, M c=l_M, M d=l_M, M l_1=l_M, M f=l_M);
M saveascii(char *l_295, M a=l_M, M l_33=l_M, M c=l_M, M d=l_M, M l_1=l_M, M f=l_M);
M type(M l_295);
M systemM(M l_296);
M system_dependent(...);
M whos();
M clc();
M disp(M x,ostream& l_297=matlibout);
M error(M x);
M format(M x="\163\150\157rt");
M home();
M input(M x);
M input(M x, M s);
M menu(M title,
M l_151=l_M,  M l_152=l_M,	M l_153=l_M,  M l_154=l_M,  M l_155=l_M,
M l_156=l_M,  M l_157=l_M,	M l_158=l_M,  M l_159=l_M,  M l_160=l_M,
M l_161=l_M, M l_162=l_M, M l_163=l_M, M l_164=l_M, M l_165=l_M);
ostream& operator<<(ostream& l_297, M& x);
ostream& operator<<(ostream& l_297, D& x);
M pauseM();
M pauseM(M x);
M smiley(...);
M warning(M x);
void whos_line(M& x);
M dot_transpose(M x);
M fliplr(M x);
M flipud(M x);
M rot90(M x, M l_30=one_M);
M transpose(M x, int d=0);
#endif
