echo on
%
% Sample program for MATCOM:Computation of dipole force field
%
% (c) Copyright Yaron Keren 1995-1996
%
a=.4;
[Y,X]=meshdom(-1.25:.1:1.25,-1.25:.1:1.25);
r=sqrt(X.^2+Y.^2);	% Create polar coordinates on rectangular grid
teta=atan2(X,Y);
clear X Y

rp=sqrt(r.^2+a.^2/4-a.*r.*cos(teta));	% Find distance from poles
rm=sqrt(r.^2+a.^2/4+a.*r.*cos(teta));
o=ones(r);
clear r teta
d=grad(o./rp-o./rm);	% Force is gradient of the potential
clear rp rm o

% Plotting...
echo off

d=(d./abs(d)).^0.8;
quiver(real(d),-imag(d))
title('Dipole field');
hold on
xbb=[];
ybb=[];
xbr=[];
ybr=[];
for x=-.4:.03:.4
 xb1=x+13+2.5;
 xb2=x+13-2.5;
 yb1=12.5-.4;
 yb2=12.5+.4;
 xbb=[xbb ; xb1 ; xb1 ; NaN];
 ybb=[ybb ; yb1 ; yb2 ; NaN];
 xbr=[xbr ; xb2 ; xb2 ; NaN];
 ybr=[ybr ; yb1 ; yb2 ; NaN];
end
plot (xbb,ybb,'b');
plot (xbr,ybr,'r');
hold off
