echo on
%
% Sample program for MATCOM: create and display a mandelbrot set
%
% (c) Copyright Yaron Keren 1995-1996
%
% Use prec=0.01 or prec=0.005 for larger image
% with better resolution (and longer runtime...)
%
echo off

prec=0.05;
n_colors=64;

tic
X=-2.1:prec:2;
Y=0:prec:2;
[x,y]=meshdom(X,fliplr(Y));
c=x+i*y;
z=zeros(size(x));
maxj=150;
o=maxj*ones(size(x));
for j=1:maxj
  if rem(j,10)==0
    fprintf('.');
  end
  z=z.^2+c;
  v=(z.*conj(z)>=4);
  o(v)=min(o(v),j);
end
disp(' ');
oi=log(o);
oim=max(max(oi))-1;
oi=oi/oim*n_colors+1;
oi=[flipud(oi);oi];
toc
image(oi);
colormap(gray(n_colors));
axis('off');

echo on
%
% If no image shows, the image viewer is not
% installed correctly, see documantation: image viewer.
%
