#************************************************************************
#* MODULE INFORMATION*
#*********************
#*     FILE     NAME:       MIB2.MAK
#*     SYSTEM   NAME:       BEHOLDER
#*     ORIGINAL AUTHOR(S):  Jan van Oorschot
#*     VERSION  NUMBER:     1.00
#*     CREATION DATE:       16-10-90
#*
#* DESCRIPTION: Global makefile for the MIB2 library
#************************************************************************
#* CHANGES INFORMATION **
#************************
#* REVISION:    $Revision:   1.1  $
#* WORKFILE:    $Workfile:   MIB2.mak  $
#* LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/SNMP/MIB2/VCS/MIB2.MAV  $
#  
#     Rev 1.1   01 Feb 1991 13:49:04   etstjan
#  No explicit note
#  
#     Rev 1.0   26 Nov 1990 16:43:32   etstjan
#  No explicit note
#  
#     Rev 1.0   21 Nov 1990 12:28:08   etstjan
#  No explicit note
#************************************************************************
HOMEDIR=..\..
NEWTREE=.^\
MODEL=L
MODE=r
CFLAGS=/DIPS_DOS /W4 /Ox /A$(MODEL) /L$(MODE) /I$(HOMEDIR)\INCLUDE /I..\INCLUDE
LFLAGS=/STACK:8000
MFLAGS = HOMEDIR=$(HOMEDIR) CFLAGS="$(CFLAGS)" LFLAGS="$(LFLAGS)" MODE=$(MODE) MODEL=$(MODEL)
ID=$(HOMEDIR)\INCLUDE
LD=$(HOMEDIR)\LIB
OD=..
PUTNOTE="No explicit note"

SYSTEM=MIB2
LIBS=$(OD)\$(MODEL)IP$(MODE).lib
CS=MIB.C
AS=
CTS=
HS= MIB2.H
MAKS=$(SYSTEM).mak
DOCS=
SRCS=$(CS) $(AS) $(HS) $(DOCS) $(CTS) 
OBJS=MIB.OBJ
TOBJS=
EXES=
TEXES= 
EXPORTS=$(ID)\MIB2.H \
        $(LD)\$(MODEL)$(SYSTEM)$(MODE).lib
#************************************************************************
#*  Supported make commands:
#*
#*      all     -->     do a full make of this system part
#*      compile -->     do a compile of all c-files
#*      lib     -->     collect all obj's in a lib
#*      exe     -->     make exe's
#*      clean   -->     throw out all garbage
#*      collect -->     copy all .lib and .h files to global directories
#*      put     -->     do a PVCS put of the sources 
#*      get     -->     do a PVCS get of the sources
#*      getlock -->     do a PVCS get of the sources and put a lock on them
#*      makedir -->     Make all subdirectories in the given
#*                      tree $(NEWTREE)
#************************************************************************
all:  lib 
    @echo ....Ready  $(MODEL)$(SYSTEM)$(MODE).lib


compile:    $(OBJS)

lib: $(MODEL)$(SYSTEM)$(MODE).lib

exe:   $(EXE) $(TEXES)

clean:
    @-del *.obj 2>nul
    @-del *.lib 2>nul
    @-del *.bak 2>nul
    @-del *.err 2>nul


put:    $(SRCS)
    !@-PUT -l -n -m$(PUTNOTE) $**
    @-PUT -l -n -m$(PUTNOTE) $(SYSTEM).mak

getlock:    $(SRCS)
    !-GET -l $**

collect: $(EXPORTS)
    !-copy $(**F) $**

get:    $(SRCS)
    !GET  $**

makedir:
    mkdir $(NEWTREE)\VCS

#************************************************************************
#*  actual components and relations
#************************************************************************
$(MODEL)$(SYSTEM)$(MODE).lib : $(OBJS)
    !LIB $@ -+$**;
    copy $(MODEL)$(SYSTEM)$(MODE).lib $(LD)

$(SRCS) :

$(EXPORTS) :
