IFDEF M_SMALL
.MODEL SMALL
CODE_FAR equ 0
DATA_FAR equ 0
ENDIF

IFDEF M_MEDIUM
.MODEL MEDIUM
CODE_FAR equ 1
DATA_FAR equ 0
ENDIF

IFDEF M_COMPACT
.MODEL COMPACT
CODE_FAR equ 0
DATA_FAR equ 1
ENDIF

IFDEF M_LARGE
.MODEL LARGE
CODE_FAR equ 1
DATA_FAR equ 1
ENDIF

IFDEF M_HUGE
.MODEL HUGE
CODE_FAR equ 1
DATA_FAR equ 2
ENDIF

IFNDEF CODE_FAR
.ERR
ENDIF

SEGMOFFS    STRUC
    offs    dw (?)
    segm    dw (?)
SEGMOFFS    ENDS

WINDOW      STRUC
    srow    dw (?)
    scol    dw (?)
    nrow    dw (?)
    ncol    dw (?)
    crow    dw (?)
    ccol    dw (?)
    buf     dd (?)
    lev     dw (?)
WINDOW      ENDS

PWCF_CGACOLOR equ  0            ;/* CGA/EGA/VGA+color mon */
PWCF_CGAMONO  equ  1            ;/* CGA/EGA/VGA+mono mon */
PWCF_MDAMONO  equ  2            ;/* MDA+monchrome monitor */

.DATA
EXTRN    __pwv_scrbuf:   DWORD  ;MDA: b000:0000. CGA/EGA/VGA:b800:0000
EXTRN    __pwv_scrncol:  WORD   ;40, 80 or 132 columns
EXTRN    __pwv_scrnrow:  WORD   ;25, 30, 40 of 50 lines
EXTRN    __pwcf_mon:     WORD   ;0=PWCF_MDAMONO,1=PWCF_CGAMONO,2=PWCF_CGACOLOR
EXTRN    __pwv_scrtype:  WORD   ;0=MDA, 1=CGA, 2=EGA

.CODE

PUBLIC  _pwv_init       ; (void)

_pwv_init   PROC        ; (void)
    ; read BIOS variables from 40:xx
    mov     ax, 40h                         ; BIOS data segment
    mov     es, ax
    mov     ax, word ptr es:[004ah]         ; # of cols
    cmp     ax, 0050h                       ; < 80 cols ?
    jl      toofewcols

init0:    
    mov     __pwv_scrncol, ax
    mov     al, byte ptr es:[0084h]         ; # of rows-1
    xor     ah, ah
    inc     ax
    mov     __pwv_scrnrow, ax

    ; set screen type: 0=MDA, 1=CGA, 2=EGA
    mov     ah, 12h                         ; alternate select
    mov     bl, 10h                         ; return EGA info
    int     10h
    cmp     bl, 10h                         ; is there EGA ?
    jnz     init1                           ; EGA --> scrtype = 2
    mov     __pwv_scrtype, 0000h            ; MDA
    mov     __pwv_scrnrow, 0019h            ; 25 rows
    mov     ax, word ptr es:[0063h]         ; base of video ctrl port
    test    al, 40                          ; MDA:ax==3b0, VGA:ax==3D0
    jnz     init1                           ; MDA --> scrtype = 0
    inc     __pwv_scrtype                   ; CGA --> scrtype = 1

init1:
    mov     ah, 0fh                         ; get current video mode
    int     10h
    push    ax                              ; save mode
    mov     al, 10h                         ; add bl(page) * 0x1000
    mul     bh
    mov     ah, al
    xor     al, al
    mov     __pwv_scrbuf.offs, ax

    mov     bx, 0b000h                      ; MDA scr segment
    mov     __pwcf_mon, PWCF_MDAMONO
    pop     ax                              ; retrieve mode
    cmp     al, 07h                         ; mode 7 ?
    je      init2
    cmp     al, 03h                         ; 0,1,2 & 3 are text modes
    jg      notextmode
    add     bx, 0800h                       ; CGA scr segment
    mov     __pwcf_mon, PWCF_CGACOLOR
init2:
    mov     __pwv_scrbuf.segm, bx
    xor     ax, ax                          ;  0: successful call
    ret

notextmode:
    mov     ax, 0ffffh                      ; -1: no text mode
    ret
toofewcols:
    mov     ax, 0fffeh                      ; -2: too few columns
    ret
_pwv_init   ENDP

END
