/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       pkt.c
**     SYSTEM   NAME:       PKT
**     ORIGINAL AUTHOR(S):  Ling Thio
**     VERSION  NUMBER:     v2.00
**     CREATION DATE:       1990/4/12
**
** DESCRIPTION: Retrieves device info for installed devices.
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   PDSINFO.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/C600/BEHOLDER/NPD/PKT/VCS/PDSINFO.C_V  $
**              
**                 Rev 1.0   25 Oct 1990 14:34:48   etstjan
**              Initial revision.
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/ETSTJAN/C600/BEHOLDER/NPD/PKT/VCS/PDSINFO.C_V   1.0   25 Oct 1990 14:34:48   etstjan  $";
#endif
#include <stdio.h>
#include <string.h>
#include <pkt.h>
#include <error.h>

static int Show(int PktInt);
int count=0;

static int Show(int PktInt)
{
    PKTINFO *pInfo=PktDriverInfo(PktInt);
    unsigned char buf[20];
    int adrlen;

    printf("\nPacket Driver at 0x%02x\n"
           "    Name:    %s\n"
           "    Version: %d\n"
           "    Class:   %d\n"
           "    Type:    %d\n"
           "    Number:  %d\n",
        PktInt, pInfo->Name, pInfo->Version,
        pInfo->Class, pInfo->Type, pInfo->Number);
    printf("    Status:  ");
    switch (pInfo->Installed)
    {
    case 1:    printf("Basic\n");    break;
    case 2:    printf("Extended\n"); break;
    case 0xff: printf("Inactive\n"); break;
    default:   printf("Unknown\n");
    }
    printf("    Address: ");
    adrlen=sizeof(buf);
    if (PktGetAddress(PktInt, buf, &adrlen))
        printf("Unknown");
    else
    {
        int i;
        for (i=0;i<adrlen;i++)
            printf("%02x ",buf[i]);
    }
    printf("\n");
    count++;
    return 0;
}

void main(void)
{
    printf("PDSINFO  (c) The DNPAP Group 1991  Version 2.00\n");
    ERR_INI();
    PktInit(Show);
    PktEnd();
    printf(count?"\n%d":"\nNo",count);
    printf(" packet driver%s found.\n",(count==1)?"":"s");
}

