/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       dptime.c
**     SYSTEM   NAME:       PACKET DISPATCHER
**     ORIGINAL AUTHOR(S):  Ling Thio
**     VERSION  NUMBER:     v1.00
**     CREATION DATE:       1989/11/30
**
** DESCRIPTION: Dispatcher's timer functions
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.1  $
** WORKFILE:    $Workfile:   DPTIME.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/NPD/DP/VCS/DPTIME.C_V  $
**              
**                 Rev 1.1   01 Feb 1991 14:20:50   etstjan
**              
**                 Rev 1.0   26 Oct 1990 12:27:38   etstjan
**              Initial revision.
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/ETSTJAN/CPROG/BEHOLDER/NPD/DP/VCS/DPTIME.C_V   1.1   01 Feb 1991 14:20:50   etstjan  $";
#endif
#include <dos.h>
#include "clock.h"
#include "dpinc.h"

static unsigned long DpTimerCnt;
static void (interrupt far *Old1c)(void);

static void interrupt far DpTimer(void);

void DpTimerInit(void)
{
    DpTimerCnt = 0L;
    clock_init();                           /* init micro sec timer */
    Old1c = _dos_getvect(0x1c);
    _dos_setvect(0x1c, DpTimer);
}

void DpTimerEnd()
{
    _dos_setvect(0x1c, Old1c);
    clock_exit();
}

/* ************************************************************
   INT 1C frequency is 18.1961059570
        8253 Clock freq = 4.77 / 4
        16 bits counter: / 65536
   1000000 / Freq = 54956.81342
** ***********************************************************/
static void interrupt far DpTimer()
{
    if ((DpTimerCnt += 54957L) >= 1000000L)
    {
        DpTimerCnt -= 1000000L;
        DpAppsEverySecond();
    }
    _chain_intr(Old1c);
}


