/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       IPLAYER.H
**     SYSTEM   NAME:       IP
**     ORIGINAL AUTHOR(S):  Wim van Campen
**     VERSION  NUMBER:     1.0
**     CREATION DATE:       1990/5/21
**
** DESCRIPTION: Contains the headers for the transport layer 
**              protocols and the IP layer functions. 
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   IPLAYER.H  $
** LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/UDPIP/INCLUDE/VCS/IPLAYER.H_V  $
**              
**                 Rev 1.0   01 Feb 1991 11:41:10   etstjan
**              No explicit note
*************************************************************************/

typedef enum {                         /* protocol requests           */
          RECREQ,                      /* receive a packet            */ 
          ERRREQ,                      /* receive an error code       */
          SRCQNCHREQ,                  /* receive a source quench     */
          REDIRREQ                     /* process a redirect message  */
          } PRREQ;

/* global variables */ 
extern IPADDRESS   *HostAddresses;     /* list of hostadresses          */
extern IPSTAT      IPStat;             /* structure with IP statistics  */


extern int         (*Protoc[256])      /* pointers to higher level      */
                   (PRREQ, CIPHEAD *,  /* protocol routines             */
                    DATALINK *, 
                    int, int);

extern IPADDRESS   *HostRoutes;        /* host routing table            */
extern IPADDRESS   *NetRoutes;         /* network routing table         */
extern IPADDRESS   *DefaultRoutes;     /* default routing table         */

extern RT_CHOICE   RouteChoice;        /* to route or not to route      */
extern RT_CHOICE   RouteSrcRoute;      /* route source routed diagrams  */

/* prototypes */

void      IPReceive(EVENTUNION *RecMessage);
int       IPSend(CIPHEAD *ThisHeader, DATALINK *ThisPacket, DIR_CHOICE Direct);
int       InitIPLayer(void);
IPADDRESS *IPAddressSearch(ADDRESS_T Search_Add, MASKCHOICE MaskSearch,
                           IPADDRESS *ListAdd);
IPADDRESS *AddIPAddress(ADDRESS_T NewAddress, ADDRESS_T NetMask,
                        ADDRESS_T SubNetMask, IFDESCRIPTOR *OwningIf,
                        IPADDRESS **ListAdd);
void      IPReport(int ThisComm, CIPHEAD *ThisHeader, 
                   DATALINK *ThisPacket);
int       GetFirstHop(IFDESCRIPTOR **FirstHopIf, ADDRESS_T *FirstHop,
                      ADDRESS_T Destin, BYTE Tos,
                      int *BCast, DIR_CHOICE Direct);
int       AddRoute(NETHOST NetHost, ADDRESS_T Destin,
                   ADDRESS_T FirstHop, ADDRESS_T NetMask);
void      ModRoute(CIPHEAD *IPHeader, CIPHEAD *RecIPHeader,
                   ADDRESS_T NewAdd);
int       IPGetHostAdd(ADDRESS_T *HostAdd, ADDRESS_T DestAdd, BYTE Tos);
int       DotConvert(ADDRESS_T *AddStore, char *DotAddress);
void      SendProb(BYTE Type, BYTE Code, BYTE Pointer,
                   CIPHEAD *ThisHeader, DATALINK *Packet);
void      SendParamProb(BYTE Pointer, CIPHEAD *ThisHeader, DATALINK *Packet);


/* higher level protocols */
int       ICMPRec(PRREQ ThisReq, CIPHEAD *IPHeader,
                  DATALINK *IPPacket, int BCast, int ECode);
int       UDPRec(PRREQ ThisReq, CIPHEAD *IPHeader,
                 DATALINK *IPPacket, int BCast, int ECode);
int       IPRawRec(PRREQ ThisReq, CIPHEAD *IPHeader,
                   DATALINK *IPPacket, int BCast, int ECode);
void      ICMPSend(CIPHEAD *IPHeader, CICMPHEAD *ICMPHeader,
                   DATALINK *IPPacket, DIR_CHOICE Direct);
