/* [DOC] File ****************************************************
** MODULE INFORMATION*
**********************
**      FILE    NAME:       PWGKEY.C
**      SYSTEM  NAME:       POWER
**      VERSION NUMBER      3.00
**
** Descr:       Key help function for
**              Programmer Oriented Window Environment Routines.
**              (NoC) July 1989 - Ling Thio Software Productions.
******************************************************************
** ADMINISTRATIVE INFORMATION*
******************************
**      ORIGINAL AUTHOR:    Ling Thio
**      CREATION DATE:      89/07/10
**      CHANGES:            none
*****************************************************************/

#include "pwinc.h"                          /* prototyping */

static PWWIN *wait_win = NULL;

/* [DOC] Function *********************************************
** Name:        pw_waiton                                 [API]
** SYNOPSIS:    void pw_waiton(void)
** Descr:       Opens 'Please wait' window.
**              The 'pw_waiton' function opens a window of type
**                PWW_ERROR and displays the message
**                'Please wait ...' in the window.
**              The window can be removed by the 'pw_waitoff()'
**                function.
** RETURNS:     void
** SEE ALSO:    pw_waitoff
**************************************************************/
void pw_waiton()
{
    if (!wait_win)
    {
        wait_win = pw_open(PWC_CENTER, PWC_CENTER, 1, 17, "", PWM_NOKEYINFO, PWW_ERROR);
        pw_puts(wait_win, " Please wait ...");
    }
}

/* [DOC] Function *********************************************
** Name:        pw_waitoff                                [API]
** SYNOPSIS:    void pw_waitoff(void)
** Descr:       Closes 'Please wait' window.
**              The 'pw_waitoff' function closes the window
**                previously opened by 'pw_waiton()'.
** RETURNS:     void
** SEE ALSO:    pw_waiton
**************************************************************/
void pw_waitoff()
{
    if (wait_win)
        pw_close(wait_win);
    wait_win = NULL;
}



