/* [DOC] File ****************************************************
** MODULE INFORMATION*
**********************
**      FILE    NAME:       PWGKEY.C
**      SYSTEM  NAME:       POWER
**      VERSION NUMBER      3.00
**
** Descr:       Key help function for
**              Programmer Oriented Window Environment Routines.
**              (NoC) July 1989 - Ling Thio Software Productions.
******************************************************************
** ADMINISTRATIVE INFORMATION*
******************************
**      ORIGINAL AUTHOR:    Ling Thio
**      CREATION DATE:      89/07/10
**      CHANGES:            none
*****************************************************************/

#include <string.h>                         /* for strlen() */
#include "pwinc.h"                          /* prototyping */

char _pw_f1f9esc[] = "F1=Help  F9=Keys  Esc=Cancel";

static char _pw_press[] = "Press any other key to continue";

/* [DOC] Function *********************************************
** Name:        pw_keyinfo                                [API]
** SYNOPSIS:    void pw_keyinfo(n, keyleft, keyright)
**              PWWIN *win          Pointer to window handle
**              char  *keyleft      Left Key information text
**              char  *keyright     Right Key information text
** Descr:       Provides a short keyhelp on bottom line.
**              The 'pw_key' function assigns the character
**                strings 'keyeft' and 'keyright' to 'win'.
**              When window 'win' is active, this string is
**                displayed at the bottom line of the string,
**                'keyleft' will be left side adjusted,
**                'keyright' will be right side adjusted.
** RETURNS:     void
**************************************************************/
void pw_keyinfo(PWWIN *win, char *keyleft, char *keyright)
{
    win->keyleft  = (keyleft) ? keyleft : _pw_f1f9esc;
    win->keyright = (keyright) ? keyright : _pw_press;
    if (win == pwb_activewin())
    {
        pwg_keyinfo(win->keyleft, win->keyright);
    }
}

void pwg_keyinfo(char *left, char *right)
{
    PWWIN *pWin = pw_win(PWID_BACKGROUND);
    int ll = (left) ? strlen(left) : 0;
    int lr = (right) ? strlen(right) : 0;
    int i;

    pw_cursor(pWin, pWin->nrow, 0);
    if (ll > _pwv_scrncol-2)
        ll = _pwv_scrncol-2;
    for (i=ll; i; i--)
        pw_putc(pWin, *(left++));
    i = ll++;
    ll++;
    if (ll < _pwv_scrncol-2-lr)
        ll = _pwv_scrncol-2-lr;
    while (i < ll)
    {
        pw_putc(pWin, ' ');
        i++;
    }
    while (i < _pwv_scrncol-2)
    {
        pw_putc(pWin, *(right++));
        i++;
    }
}


