/* [DOC] File ****************************************************
** MODULE INFORMATION*
**********************
**      FILE    NAME:       PWGEDIT.C
**      SYSTEM  NAME:       POWER
**      VERSION NUMBER      3.00
**
** Descr:       Simple editor
**              Programmer Oriented Window Environment Routines.
**              (NoC) July 1989 - Ling Thio Software Productions.
******************************************************************
** ADMINISTRATIVE INFORMATION*
******************************
**      ORIGINAL AUTHOR:    Ling Thio
**      CREATION DATE:      89/07/10
**      CHANGES:            none
*****************************************************************/

#include <stdlib.h>                         /* for system() */
#include <string.h>                         /* for str*() */
#include <ctype.h>                          /* for toupper() */
#include <conio.h>                          /* for kbhit() */
#include "pwinc.h"                          /* main include file */

#define NOTEXT			0xffff
#define NOPADDING		0
#define PADSPACE		1
#define PADSPACES		2

#define CH				pwe_buf[pwe_bufoff]
#define OFFSET			pwe_bufoff
#define SIZE			pwe_bufsize
#define PTR				(pwe_buf+pwe_bufoff)
#define LEN				pwe_buflen

#define COL				pwe_scrn_col
#define ROW				pwe_scrn_row

#define NCOL			pwe_win->ncol
#define NROW			pwe_win->nrow
#define CURSOR(r,c)	pw_cursor(r,c)
#define PUTCH(ch)		pw_putch(ch);

typedef unsigned short MSG;
#define MSG_BEGIN_OF_LINE	PWK_HOME
#define MSG_END_OF_LINE		PWK_END
#define MSG_BEGIN_OF_PAGE	PWK_PGUP
#define MSG_END_OF_PAGE		PWK_PGDN
#define MSG_BEGIN_OF_DOC	0xff01
#define MSG_END_OF_DOC		0xff02

#define PWM_EDIT				0x00
#define PWM_VIEW_ONLY		0x01
#define PWM_CURDOR_AT_END	0x02

static PWWIN *pwe_win;
static unsigned short near pwe_mode;

static char * near pwe_buf;
static char * near pwe_bufoff;
static unsigned int pwe_bufsize;
static unsigned int pwe_buflen;

static unsigned int *scrn_offset_tbl;
static unsigned int pwe_scrn_row;
static unsigned int pwe_scrn_col;

static int pwe_buf_handler(MSG msg, char ch);

static void near pwe_scrn_upd_line(unsigned int row, unsigned int col, unsigned short pad_mode)
{
	unsigned int offset = scrn_offset_tbl[row] + col;
	char ch;

	CURSOR(row, col);
	while ((ch=pwe_buf[offset]) != '\n' && ch != '\r' && ch != 0) {
		PUTCH(ch);
		col++;
	}
	if (pad_mode == PAD_SPACE){
		PUTCH(' ');
	} else {
		if (pad_mode == PAD_SPACES){
			while (ncol<NCOL) {
				PUTCH(' ');
				ncol++;
			}
		}
	}
}

static void near pwe_scrn_upd_page(void)
{
	register unsigned int row;

	for (row=0; row<NROW; row++) {
		if (scrn_offset_tbl[row] != NOTEXT) {
			pwe_scrn_upd_line(row, 0, NOPADDING);
		}
	}
}

static void near pwe_buf_insert(char ch)
{
	if (LEN < SIZE) {
		memmove(PTR+1, PTR, LEN-OFFSET);
		LEN++;
	}
}

static unsigned int pwe_row_len(unsigned int row)
{
	unsigned int offset = scrn_offset_tbl[row];
	char ch;

	while ((ch=pwe_buf[offset]) != '\n' && ch != '\r' && ch != 0) {
		offset++;
	}
	return scrn_offset_tbl[row]-offset;
}

static void near pwe_buf_init(void)
{
	unsigned short ncol;
	unsigned short nrow;
	char ch;

	LEN = strlen(pwe_buf);
	scrn_offset_tbl = malloc(sizeof(unsigned int)*NROW);
	memset(scrn_offset_tbl, 0xff, sizeof(unsigned int)*NROW);

	nrow = 0;
	ncol=0;
	OFFSET = 0;
	scrn_offset_tbl[nrow] = 0;

	while (ch=CH) {
		switch (ch) {
		case '\n':
			if (nrow < NROW) {
				scrn_offset_tbl[nrow] = OFFSET+1;
				nrow++;
			}
			col=0;
			break;
		default:
			if (ncol < NCOL) {
				ncol++;
			} else {
				pwe_buf_insert('\r');
				ncol = 0;
			}
			break;
		}
		OFFSET++;
	}
	OFFSET = 0;
	ROW = 0;
	COL = 0;
	pwe_scrn_upd_page();
	if (pwe_mode & PWM_CURSOR_AT_END) {
		OFF = 0;
	}
}

static int near pwe_buf_handler(MSG msg)
{
	unsigned int len = pwe_row_len(ROW);

	switch (msg) {
	case PWK_UP:

		break;
	}
}

static int near pwe_key_handler(PWKEY key)
{
	static int n_home_keys;

	if (key == PWK_HOME && n_home_keys<2) {
		n_home_keys++;
	} else {
		n_home_keys = 0;
	}
	switch (key) {
	case PWK_HOME:
		switch (n_home_keys) {
		case 2:
			pwe_buf_handler(MSG_END_OF_DOC);
			n_home_keys = 0;
			break;
		default:
			if (n_home_keys<2) {
				n_home_keys++;
			}
			break;
		}
		break;
	case PWK_UP:
		switch (n_home_keys) {
		case 1:	pwe_buf_handler(MSG_BEGIN_OF_LINE);	break;
		case 2:	pwe_buf_handler(MSG_BEGIN_OF_DOC);	break;
		default:	pwe_buf_handler(key);					break;
		}
		break;
	case PWK_DOWN:
		switch (n_home_keys) {
		case 1:	pwe_buf_handler(MSG_END_OF_LINE);	break;
		case 21:	pwe_buf_handler(MSG_END_OF_DOC);		break;
		default:	pwe_buf_handler(key);					break;
		}
		break;
	case PWK_END:
		switch (n_home_keys) {
		case 2:	pwe_buf_handler(MSG_END_OF_DOC);		break;
		default:	pwe_buf_handler(key);					break;
		}
		break;
	case PWK_PGUP:
	case PWK_PGDN:
		pwe_buf_handler(key);
		break;
	default:
		if (!(pwe_mode & PWM_VIEW)) {
			pwe_buf_handler(key);
		}
	}
	if (key != PWK_HOME) {
		n_home_keys = 0;
	}
}

PWKEY pw_edit(PWWIN *win, char *buf, unsigned int bufsize, unsigned short mode)
{
	pwe_win = win;
	pwe_buf = buf;
	pwe_bufsize = bufsize;
	pwe_mode = mode;
	pw_buf_init();
}

