#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <power3.h>
#include <futil.h>
#include <dos.h>
#include <beholder.h>
#include <time.h>
#define extern
#include <error.h>

static PWWIN
    *ErrWinDebug,
    *ErrWinError;
static FILE
    *DebugFile,
    *ErrorFile;
static char ErrorName[80];
static char DebugName[80];

static char *Levels[] = {
    "Message",
    "Warning",
    "Critical",
    "FATAL" };

static char Str [255];

FILE *ErrOpen (char *Name);

int
    ErrIni
    (
        void
    )
{
    FILE *Cfg;
#ifdef TRACE_ON
    FP_SEG (Screen) = 0xb800;
    FP_OFF (Screen) = 0;
#endif
    ErrorName[0]='\0';
    DebugName[0]='\0';
    ErrorFile=NULL;
    DebugFile=NULL;
    DebugLevel=32767;
    if ((Cfg = fopen (ConfigFile,"r")) != NULL)
    {
        if (FFindSection (Cfg, "ERRORS") >= 0)
        {
            FGetVar (Cfg, "ErrorFile", ErrorName, sizeof(ErrorName), MIX);
            FGetVar (Cfg, "DebugFile", DebugName, sizeof(DebugName), MIX);
            FGetVar (Cfg, "DebugLevel", Str, sizeof(Str), MIX);
            DebugLevel=atoi(Str);
            fclose (Cfg);
        }
    }
    ErrorFile = ErrOpen(ErrorName);
    DebugFile = ErrOpen(DebugName);
    if ((ErrWinDebug = pw_open (2, 1, 10, 78, "Debug", PWM_DEFAULT, PWW_DATA)) == NULL)
        return (-1);             
    if ((ErrWinError = pw_open (14, 1, 9, 78, "Errors", PWM_DEFAULT, PWW_DATA)) == NULL)
        return (-1);
    return (0);
}

void
    ErrDebug
    (
        int     Id,
        int     Level,
        char    *Format,
        ...
    )
{
    va_list
        ArgPtr;

    if (Level<=DebugLevel)
    {
        va_start (ArgPtr, Format);
        vsprintf (Str, Format, ArgPtr);
        pw_printf (ErrWinDebug, "%d: %d: %s\n", Id, Level, Str);
        if (DebugFile)
        {   
            fprintf (DebugFile, "%d: %d: %s\n", Id, Level, Str);
            fflush (DebugFile);
        }
        va_end (ArgPtr);
    }
}

void
    ErrError
    (
        int     Id,
        int     Level,
        char    *Format,
        ...
    )
{
    va_list
        ArgPtr;

    va_start (ArgPtr, Format);
    vsprintf (Str, Format, ArgPtr);
    pw_printf (ErrWinError, "%d: %s: %s\n", Id, Levels[Level], Str);
    if (ErrorFile)
    {
        fprintf (ErrorFile, "%d: %s: %s\n", Id, Levels[Level], Str);
        fflush (ErrorFile);
    }
    va_end (ArgPtr);
}
    


FILE *ErrOpen (char *Name)
{
    FILE *File = NULL;
    int New;
    time_t Now;
    
    time (&Now);
    if (Name[0]!='\0')
    {
        if ((File=fopen(Name,"r")) != NULL)
        {
            New = 0;
            fclose (File);
        }
        else
        {
            New = 1;
        }
        File=fopen(Name,"a");
        if (New)
        {
            fprintf(File,"This version of The Beholder was created on %s\n", BeholderDate); 
            fprintf(File,"Logging started on %s\n", ctime (&Now)); 
        }
        else
        {
            fprintf(File,"Logging resumed on %s\n", ctime (&Now)); 
        }
    }
    return (File);
}
