/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       LGOBBLER.C
**     SYSTEM   NAME:       GOBBLER
**     ORIGINAL AUTHOR(S):  Tirza van RIjn
**     VERSION  NUMBER:     1.0
**     CREATION DATE:       1991/11/11
**
** DESCRIPTION: Main file for the local GOBBLER
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   PC.C  $
** LOGINFO:     $Log:   I:/TIRZA/CPROG/BEHOLDER/APS/GOBBLER/VCS/LGOBBLER.C_V  $
**              
**                 Rev 1.0   11 Nov 1991 16:37:22   tirza
**              No explicit note
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/TIRZA/CPROG/BEHOLDER/APS/GOBBLER/VCS/LGOBBLER.C_V   1.5   11 Nov 1991 13:35:32   tirza  $";
#endif


#include <stdio.h>  
#include <stdlib.h>                         /* for NULL */
#include <string.h>
#include <time.h>                           /* for initializing start time */
#include <power3.h>                         /* for pw_*() */
#include <error.h>
#include <beholder.h>                       /* for DP structures */


/* Function prototypes */
int IPStackInit(void);
void main(int argc, char **argv);
static int DpMain(void);


char *BeholderDate = __DATE__;
char *BeholderDescription  = "The Gobbler   DNPAP Network Management Monitor  TU Delft";

#ifdef __TURBOC__
extern unsigned _stklen = 8*1024;		/* make 8K stack for borland C */
#endif

void main(int argc, char **argv)
{
    int Ind, Ret = 0;
    char Hdr[80];

    for (Ind = 0; Ind < argc; Ind++)
    {
        if (strcmp(argv[Ind], "-f") == 0)
        {
            strcpy(ConfigFile, argv[Ind + 1]);
            break;
        }
    }
    /* initialize buffer lists, device lists and application lists */
    pw_options(argc, argv);
    Ret = pw_init(argv[0], NULL);
    if (Ret)
    {
        fprintf (stderr, "Can not initialize window system\n");
        exit (1);
    }
    sprintf (Hdr, "%s  %s", BeholderDescription, BeholderDate);
    pw_block(pw_win(PWID_BACKGROUND), -1, -1, 1, 80, PWT_REVERSE);    
    pw_header(Hdr);    
    pw_waiton(); 
    Ret = ERR_INI();
    if (Ret)
    {
        pw_waitoff(); 
        pw_error("Can not initialize errors");
        pw_quit();
        exit (1);
    }
    Ret = BufInit();
    if (Ret)
    {
        pw_waitoff(); 
        pw_error("Can not initialize buffers");
        pw_quit();
        exit (1);
    }
    Ret = DpInit();
    if (Ret)
    {
        pw_waitoff(); 
        pw_error("Can not initialize dispatcher");
        pw_quit();
        exit (1);
    }
/*    Ret = IPStackInit();
    if (Ret)
    {
        pw_waitoff(); 
        pw_error("Can not initialize IP stack");
        DpEnd();
        pw_quit();
        exit (1);
    } */
    pw_waitoff(); 
    DpMain();
    DpEnd();
    pw_quit();
    exit (0);
}

static int DpMain(void)
{
    int ret;

    ret = DpStart();
    if (ret == 0)
        DpLoop();
    pw_waiton(); 
    DpStop();
    pw_waitoff(); 
    return ret;
}
