#include <stdio.h>
#include <time.h>
#include <sys/stat.h>

#include "safechar.h"

int send_esc(char *s,FILE *f)
{
  int newline=0;
  while(*s) switch(*s)
  {
    case '\n': s++; newline=1; break;
    case '\\':
    case '"': putc('\\',f);
    default: putc(*s++,f);
  }
  return newline;
}

void putlength(char *pos, int len)
{
  pos[2]=safechar[len%16];
  len/=16;
  pos[1]=safechar[len%16];
  len/=16;
  pos[0]=safechar[len%16];
  len/=16;
}

main()
{
  char lin[120];
  time_t rt;
  struct stat sb;
  int l1;
  FILE *in=fopen("ldr.hd","r");
  FILE *out=fopen("header.h","w");
  time(&rt);
  fprintf(out,
        "/* header.h--headers for encoder */\n"
        "/* computer generated from uuldr.hd (obf.bin, uuldr.bin (uuldr.asm)) */\n"
        "/*  and ldr.hd (obf.bin, ldr.bin (ldr.asm)) */\n"
        "/* no user serviceable code */\n"
        "/* data is partly 8086 machine code */\n"
        "/* last generation: %s */\n\n"
        "/* header for method #1: */\n"
        "char nheader[]=\n" , ctime(&rt));
  l1=1;
  while(NULL!=fgets(lin,120,in))
  {
    if(l1)
    {
      fstat(fileno(in),&sb);
      putlength(lin+8,(int)(sb.st_size-8-3));
      l1=0;
    }
    putc('"',out);
    if(send_esc(lin,out)) fputs("\\n",out);
    fputs("\"\n",out);
  }
  fputs(";\n\n"
        "/* header for method #2: */\n"
        "char uheader[]=\n",out);
  fclose(in);
  in=fopen("uuldr.hd","r");
  l1=1;
  while(NULL!=fgets(lin,120,in))
  {
    if(l1)
    {
      fstat(fileno(in),&sb);
      putlength(lin+8,(int)(sb.st_size-8-3));
      l1=0;
    }
    putc('"',out);
    if(send_esc(lin,out)) fputs("\\n",out);
    fputs("\"\n",out);
  }
  fputs(";\n\n/*EOF*/\n",out);
  fcloseall();
  return 0;
}
