
;
;   FLOC.COM   v1.00   C. Dye   02-05-1996
;
;   Tiny little file finder.  Assemble this source file with Eric Isaacson's
;   neat A86 assembler.  Okay to distribute by any medium, provided that one
;   of the following is true:  (1) FLOC.S and FLOC.COM may be distributed
;   separately or together if they remain unaltered; a .ZIP file is the
;   preferred method, or (2) you may distribute modified versions or include
;   parts in your own programs, so long as my name is removed from all files.
;   No warranty whatsoever.
;

radix 16

doscall macro                          ; call to dos int_21 with a
mov ah,#1                              ; one-byte function in ah
int 21
#em

doscall2 macro                         ; call to dos int_21 with a
mov ax,#1                              ; two-byte function in ax
int 21
#em

dosprint macro                         ; call to dos string-print function
mov dx,offset #1
mov ah,09
int 21
#em

jmp begin                              ; skip over variables

name_point:                            ; pointer to user's filespec
dw 0000

working_point:                         ; pointer into working buffer
dw 0003

tree_point:                            ; pointer into tree buffer
dw 0000

exit_code:                             ; changed to 00 if any files found
db 01


;   The first step is to parse through the command line.  name_point will
;   be set to the offset of the user's filespec, not including any drive
;   letter.  If a drive letter was specified, it will be moved to the
;   start of working_buffer; if not, the current drive will be used instead.
;   The user's filespec will be terminated with a null.

begin:                                 ; start of code:
mov si,0081                            ; point to start of command-line parms
skipspace:                             ; skip over any spaces preceding name
lodsb
cmp al,0d                              ; end of line without filename?
je syntax                              ; if so, exit with a syntax error
cmp al,20
je skipspace                           ; skip over spaces
mov al,b [si]                          ; look at second char in filename:
dec si
cmp al,':'                             ; is it a colon?
jne default_drive                      ; if not, search current drive
mov al,b [si]                          ; look at the char before the colon:
cmp al,'a'
jb force_uc1                           ; (force lowercase to uppercase)
cmp al,'z'
ja force_uc1
and al,0df
force_uc1:
cmp al,'A'
jb syntax                              ; was it a letter?
cmp al,'Z'                             ; if not, exit with a syntax error
ja syntax
add si,0002                            ; point to the filename (after colon)
cmp b [si],0d                          ; there is one, right?
je syntax                              ; if not, syntax error
cmp b [si],20
je syntax
jmp start_search                       ; begin the search
default_drive:                         ; user did not specify a drive letter:
doscall 19                             ; get the current drive
add al,'A'                             ; convert to a drive letter
jmp start_search                       ; begin the search

syntax:                                ; error on command line:
dosprint msg_syntax                    ; print a syntax message
doscall2 4c10                          ; and exit with errorlevel 16

start_search:                          ; but first, a little post-parse:
mov b [working_buffer+0],al            ; save the drive letter
mov w [name_point],si                  ; save a pointer to the filespec
mov cl,00                              ; note:  no period found yet
walk_filespec:                         ; walk through the user's filespec
lodsb                                  ; one character at a time
cmp al,'.'                             ; found the period?
jne walk_1                              
mov cl,20                              ; if so, note it
walk_1:
cmp al,'/'                             ;  (if any slashes or backslashes
je syntax                              ;   are found, signal a syntax error)
cmp al,'\'
je syntax
cmp al,0d                              ; until a return is found
je filespec_end
cmp al,20                              ; or a space
jne walk_filespec
filespec_end:
dec si
cmp cl,00                              ; did the user type a period?
jne dot_found                          ; if not,
mov w [si],'*' by '.'                  ; use default extension of '.*'
add si,0002
dot_found:                             ; filespec terminated w/ space or cr:
mov b [si],00                          ; replace it with a null
dosprint msg_crlf                      ; print blank line, just for pretties
mov w [working_buffer+1],'\' by ':'    ; poke in colon and root backslash
mov b [tree_buffer+0],00               ; empty the tree buffer
mov dx,offset my_dta
doscall 1a                             ; tell dos new location for dta

;   Done examining the user's filespec.  The next step is to search the
;   current directory (the directory whose name is stored in working_buffer)
;   for subdirectories.  If any subdirectories are found, their names will
;   be appended to the string in tree_buffer.

dir_search:                            ; search for subdirectories in current
mov bx,w [working_point]
mov w [working_buffer+bx+0],'.' by '*' ; filename for search for:
mov w [working_buffer+bx+2], 00 by '*' ; *.* -- subdirectories with any name
mov dx,offset working_buffer
mov cx,0016                            ; attribs to accept:  all directories
doscall 4e                             ; start search for subdirectories
dir_search_loop:
jc dir_search_done                     ; if any error, done with dir search
test b [my_dta+0015],10                ; found an item!  is it a directory?
je dir_search_next                     ; if not, skip ahead
cmp b [my_dta+001e],'.'                ; was it the silly dos '.' or '..' ?
je dir_search_next                     ; if it was, skip ahead
mov si,0003                            ; found a directory name:
mov di,w [tree_point]
cmp di,0000                            ; anything in the tree buffer yet?
je dir_found_1
mov b [tree_buffer+di],01              ; if so, change final null to 01 char.
inc di
dir_found_1:
cmp si,w [working_point]
je dir_found_2
mov al,b [working_buffer+si]           ; copy current directory name
inc si
mov b [tree_buffer+di],al              ; to the end of the tree buffer
inc di                                 ; up to and including the backslash
jmp dir_found_1
dir_found_2:
mov si,offset (my_dta+001e)
dir_found_3:                           ; then copy the name of the newly-
lodsb                                  ; found subdirectory
mov b [tree_buffer+di],al              ; onto the end of that
inc di
cmp al,00
jne dir_found_3                        ; terminated with a null (not a
dec di                                 ;    backslash)
mov w [tree_point],di                  ; update pointer to end of tree buffer

dir_search_next:                       ; look for next subdirectory:
doscall 4f                             ; continue search
jmp dir_search_loop

;   Done hunting for subdirectories.  The next step is to search through the
;   current directory for any files matching the user's filespec.  In order
;   to keep the code short, the user's filespec is passed directly to the
;   DOS find_first_handle function.  Another method is to pass a filespec
;   of "*.*" to DOS, then manually check the returned filename against the
;   user's filespec.  It's also easy to decide whether or not to display the
;   returned filename based on its attributes (or date, file size, etc.)  To
;   permit the display of subdirectory names as well as filenames, change the
;   MOV CX,0006 below to MOV CX,0016.

dir_search_done:                       ; found all subdir's in current dir:
mov si,w [name_point]
mov di,w [working_point]
file_search_1:
lodsb                                  ; copy the user's filespec into the
mov b [working_buffer+di],al           ; working buffer, right after the
inc di                                 ; directory name and backslash
cmp al,00
jne file_search_1
mov dx,offset working_buffer           ; point to user's filespec
mov cx,0006                            ; allow hidden and system files
doscall 4e                             ; begin search for files
file_search_loop:                      ; find anything?
jc file_search_done                    ; if not, done with current directory
mov b [exit_code],00                   ; found a file!  errorlevel = success
mov bx,0000
mov ah,02
file_found_1:
cmp bx,w [working_point]
jae file_found_2
mov dl,b [working_buffer+bx]           ; get a character from the working
inc bx                                 ; buffer and display it (to display
int 21                                 ; the drive and directory name)
jmp file_found_1                       ; loop back for next character
file_found_2:
mov si,offset (my_dta+001e)
file_found_3:
mov dl,b [si]                          ; get a character from the found
cmp dl,00                              ; file's name and display it
je file_found_4
inc si
int 21
jmp file_found_3                       ; loop back for next character
file_found_4:
dosprint msg_crlf                      ; then finish name off with a crlf

file_search_next:                      ; done displaying file's full name:
doscall 4f                             ; dos find_next
jmp file_search_loop                   ; and loop back for more

;  Done hunting through the current directory.  If there are any directory
;  names in the tree buffer, move the first one into the working buffer
;  (make it the current directory) and slide all the others down.

file_search_done:                      ; done with the current working dir.
cmp b [tree_buffer+0],00               ; is the tree buffer empty?
je all_done                            ; if so, exit the program.
mov si,offset tree_buffer
mov di,0003
next_dirname_1:
lodsb                                  ; copy first name from tree buffer
test al,0fe                            ;    (terminated by 00 or 01)
je next_dirname_5
mov b [working_buffer+di],al           ; into the working buffer
inc di
jmp next_dirname_1
next_dirname_5:
mov b [working_buffer+di],'\'          ; finish it off with a backslash
inc di                                 ; and save the address just after that
mov w [working_point],di               ; as the new working buffer pointer
cmp al,00                              ; was that the only dir name in tree?
je next_dirname_9                      ; if so, empty tree buffer
mov di,0000
next_dirname_6:                        ; there are more dir names in buffer:
lodsb
mov b [tree_buffer+di],al              ; move them down
inc di
cmp al,00
jne next_dirname_6
dec di
mov w [tree_point],di                  ; save new address for null at end
jmp dir_search                         ; loop back to search new directory
next_dirname_9:                        ; buffer has just been emptied:
mov b [tree_buffer+0],00               ; put a null at the beginning
mov w [tree_point],0000                ; note its offset within the buffer
jmp dir_search                         ; loop back to search new directory

all_done:                              ; no more directories to search!
mov al,b [exit_code]                   ; exit with errorlevel 00 (found some)
doscall 4c                             ; or errorlevel 01 (didn't find any)

msg_syntax:                            ; basic explanation of program usage
db 0d,0a
db "FLOC.COM  (File LOCate)  v1.00  C. Dye  02-05-1996",0d,0a,0a
db "FLOC [d:]filespec"

msg_crlf:                              ; a carriage return and line feed
db 0d,0a,'$'

working_buffer:
;   Used to hold asciiz filenames for DOS find_first and find_next functions.
;   When searching for subdirectories, holds the full pathname of the current
;   directory plus \*.*<nul>  --  for instance, C:\DOS\*.*<nul>   When
;   searching for files, holds the full pathname of the current working
;   directory plus a backslash and the user's filespec  -- for instance,
;   C:\DOS\S*.EXE<nul>

my_dta  equ  (working_buffer + 60)
;   Relocated DOS disk transfer area, used by find_first and find_next
;   functions.  Normally down in the PSP, but I'm using that same area to
;   hold the user's filespec.

tree_buffer  equ  (my_dta + 40)
;   Holds the names of any unsearched directories, separated by ascii 01
;   characters and terminated with a null.  Directory names omit the
;   leading (root) and trailing backslashes.  For instance, this buffer
;   might hold:  DOS<01>WINDOWS<01>BAT<01>WINDOWS\SYSTEM<nul>
