/* cdd.c
 * created:  15-Mar-1995 jmk
 * autodate: 24-Mar-1996 
 * autotime: 23:04 
 * 
 * Change to a drive/directory combination under ms-dos.  For example:
 *  CDD D:\TEMP changes to directory \TEMP on drive D: 
 *  CDD E:      changes to the currenct directory on drive D:
 *  CDD ..\OVER changes to directory ..\OVER on the current drive
 * 
 * This C source file is compatible with Turbo C/C++ version 3.0 for ms-dos;
 * it may or may not work on with any other compiler without modification.
 * To build, use the following command:  TCC CDD.C
 * This program uses features specific to ms-dos and will probably not work
 * on any other platform.
 * 
 * This program comes with neither explicit nor implicit warranty.
 * Your mileage may vary.
 * 
 * Copyright 1996 by Jim Knoble <jmknoble@mercury.interpath.com>.
 * This program (both source and ms-dos executable) is freely distributable
 * under the GNU Public License, a copy of which should be included with
 * this program.  Please read the license before distributing the program.
 * 
 * The author additionally requires that *any* modifications made to
 * this program be attributed to the author of the modification and not to
 * the original author.  Please document any such modifications in this 
 * source file.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dir.h>

#define NONDRV  -1

char version[] = "%s version 1.1 15-mar-1995 by jim knoble\n";
char usage[] = "usage: %s [<d:>][<dirspec>]\n\
\tchdir to <dirspec> on drive <d:>\n";

char errmsg_baddrv[] = "%s: error: could not find drive `%c:'\n";
char errmsg_baddir[] = "%s: error: could not find directory `%s'\n";
/* dbg: char msg_chgdrvsuc[] = "%s: changed to `%c:'\n"; */
/* dbg: char msg_chgdirsuc[] = "%s: changed to `%s'\n"; */

void main (int argc, char **argv)
{
   char *cmdnam;
   int olddrvnum = getdisk();
   int newdrvnum = NONDRV;
   char *pthspe;
   
   /* build a command name from argv[0] */
   cmdnam = strdup(argv[0]);
   cmdnam = strlwr(cmdnam);
   
   /* if we're called with no arguments, display help and exit */
   if (argc <= 1)
    {
       printf(version, cmdnam);
       printf(usage, cmdnam);
       exit(0);
    }
   else
    {
       pthspe = argv[1];
       
       /* check if there's a drive spec in the path
	*     string:  d : d i r ...
	*     index:   0 1 2 3 4 ...
	*/
       if (':' == pthspe[1])
        {
	   /* msdos drive number: 0=>a:, 1=>b:, &c. */
	   newdrvnum = tolower(pthspe[0]) - 'a';
	   /* change to new drive */
	   (void) setdisk(newdrvnum);
	   /* see if it worked */
	   if (getdisk() != newdrvnum)
            {
	       /* we have a problem -- that drive is unavailable */
	       printf(errmsg_baddrv, cmdnam, newdrvnum + 'a');
	       exit(1);
            }
	   else
            {
	       /* move past the drive spec */
	       /* dbg: printf(msg_chgdrvsuc, cmdnam, newdrvnum + 'a'); */
	       pthspe += 2;
            }
        } /* ':' == pthspe[1] */
       
       /* check if a directory spec was given--the only way
	* we don't get a directory is if a drive is specified
	* with no directory after it; if none, we're done.
	*/
       if (strlen(pthspe))
        {
	   /* check to see if that directory exists
	    * (we do this by trying to go there).
	    */
	   if (0 != chdir(pthspe))
            {
	       /* we couldn't go there */
	       printf(errmsg_baddir, cmdnam, pthspe);
	       /* if we changed drives, we should
		* change back to the original one.
		*/
	       if (olddrvnum != newdrvnum)
                {
		   (void) setdisk(olddrvnum);
                }
	       exit(1);
            } /* chdir() */
        } /* strlen(pthspe) */
       
       /* we're done */
       /* dbg: printf(msg_chgdirsuc, cmdnam, pthspe); */
       exit(0);
       
    } /* else argc > 1 */
}

/** End of source file **/
