/*******************************************************

    The CalcPlus Class Library Version 1.0,
    Author: Vladimir Schipunov, Copyright (C) 1996

    This library is free software. Permission to use,
    copy, modify and redistribute the CalcPlus library
    for any purpose is hereby granted without fee,
    provided that the above copyright notice appear
    in all copies.

*******************************************************/

#include <iostream.h>
#include <stdlib.h>
#include "calcexpr.h"
#include "calctype.h"

//
//  This is an example of how new functions can be added
//  to the interpreter. Note that you must register
//  function or procedure specifying its name, address and
//  number of arguments (see at EOF).
//  Enumeration of arguments begins from 0.
//

//------------------------------------------------------
//
//  Creating new array of the length n
//
//------------------------------------------------------

USER_FUNC( NewArray )
    DEF_ARGV( 0, n, Long )
    RETURNS( Array )
    for( int i = 0; i < (long)n; i++ )
        ret.add( new CNil );
USER_END

//------------------------------------------------------
//
//  Returns length of the array
//
//------------------------------------------------------

USER_FUNC( Len )
    DEF_ARGX( 0, x )
    RETURNS( Long )
    int t = x.type();
    if( t!=idString && t!=idArray )
        USER_ERR("Wrong type in calling LEN");
    ret = x.size();
USER_END

//------------------------------------------------------
//
//  Extracts substring from the given string
//
//------------------------------------------------------

USER_FUNC( Substr )
    DEF_ARGV( 0, str, String )
    DEF_ARGV( 1, pos, Long )
    DEF_ARGV( 2, len, Long )
    delete xpf->v;
    xpf->v = new CString( str.s()+
        (int)((long)pos), (int)((long)len+1) );
    RETURNS( String );
    ret.zero = 1;
    ret[len] = 0;
USER_END

//------------------------------------------------------
//
//  Returns array of the strings as
//  the description of structure
//
//------------------------------------------------------

USER_FUNC( Structure )
    DEF_ARGV( 0, str, String )
    LexObj *obj = 0;
    for( XBlock *x = xpf->xblock(); x && !obj;
        x = x->father ? x->father->xblock() : 0 )
            obj = x->structs( str );
    if( !obj )
        USER_ERR("Structure not found");
    delete xpf->v;
    xpf->v = ((LexStruct*)obj)->data->copy();
USER_END

//------------------------------------------------------
//
//  Truncates spaces from the right end of the string
//
//------------------------------------------------------

USER_FUNC( Left )
    DEF_ARGV( 0, str, String )
    delete xpf->v;
    xpf->v = new CString( str.left(0).s());
USER_END;

//------------------------------------------------------
//
//  Simple RTTI
//
//------------------------------------------------------

USER_FUNC( Type )
    DEF_ARGX( 0, x )
    RETURNS( String )
    ret = "?";
    ret[0] = *x.name();
USER_END;

//------------------------------------------------------
//
//  Removes element from the array
//
//------------------------------------------------------

USER_FUNC( Adel )
    DEF_ARGV( 0, array, Array )
    DEF_ARGX( 1, index )
    RETURNS( Bool )
    int t = index.type();
    if( t!=idString && t!=idLong )
        USER_ERR("Wrong type in calling ADEL");
    int r = t==idString ?
        array.remove( array.index( (CString&)index )):
        array.remove( (CLong&)  index );
    ret = !r;
USER_END

//------------------------------------------------------
//
//  Adds new element to the array
//
//------------------------------------------------------

USER_PROC( Aadd )
    DEF_ARGV( 0, array, Array )
    DEF_ARGX( 1, x )
    array.add( x.copy());
USER_END

//------------------------------------------------------
//
//  Checks whether function defined or not
//
//------------------------------------------------------

USER_FUNC( Defined )
    DEF_ARGV( 0, str, String )
    RETURNS( Bool )
    LexObj *obj = 0;
    for( XBlock *x = xpf->xblock(); x && !obj;
        x = x->father ? x->father->xblock() : 0 )
            obj = x->funcs( str );
    ret = obj ? 1 : 0;
USER_END

//------------------------------------------------------
//
//  Is variable empty
//
//------------------------------------------------------

USER_FUNC( Empty )
    DEF_ARGX( 0, x )
    RETURNS( Bool )
    ret = x.empty();
USER_END

//------------------------------------------------------
//
//  Converts value to string
//
//------------------------------------------------------

USER_FUNC( Str )
    DEF_ARGX( 0, x )
    RETURNS( String )
    ret = x.s();
USER_END

//------------------------------------------------------
//
//  Reads value of the variable from the text buffer.
//  Variable should be passed by reference.
//
//------------------------------------------------------

USER_PROC( Read )
    DEF_ARGX( 0, x )
    DEF_ARGV( 1, s, String )
    char buf[256];
    s.s( buf );
    x.read( buf );
USER_END

//------------------------------------------------------
//
//  Exit from program
//
//------------------------------------------------------

USER_PROC( Quit )
    DEF_ARGX( 0, x )
    cerr << x << endl;
    exit( 1 );
USER_END

//------------------------------------------------------
//
//  Gets string from stdin
//
//------------------------------------------------------

USER_FUNC( Getstr )
    DEF_ARGV( 0, s, String )
    RETURNS( String )
    char buf[ 256 ];
    cout << s << flush;
    cin.getline( buf, sizeof( buf ));
    ret = buf;
USER_END

//------------------------------------------------------
//
//  Returns argument of command line
//
//------------------------------------------------------

USER_FUNC( Argv )
    DEF_ARGV( 0, i, Long )
    RETURNS( String )
    if( 0<=(long)i && (long)i<XUserFunction::Argc )
        ret = XUserFunction::Argv[(int)((long)i)];
USER_END

//------------------------------------------------------
//
//  Returns argument count given in the command line
//
//------------------------------------------------------

USER_FUNC( Argc )
    RETURNS( Long )
    ret = XUserFunction::Argc;
USER_END

//------------------------------------------------------
//
//  Converts string to number
//
//------------------------------------------------------

USER_FUNC( Val )
    DEF_ARGV( 0, s, String )
    RETURNS( Long )
    char buf[256];
    s.s( buf );
    ret.read( buf );
USER_END

//------------------------------------------------------
//
//  Converts number or string to date
//
//------------------------------------------------------

USER_FUNC( Date )
    DEF_ARGX( 0, x )
    RETURNS( Date )
    if( x.id == idString )
    {
        char buf[256];
        x.s( buf );
        ret.read( buf );
    }
    if( x.id == idLong )
        ret.set( (CLong&) x );
USER_END

//------------------------------------------------------
//
//  Reads enviroment variable
//
//------------------------------------------------------

USER_FUNC( Getenv )
    DEF_ARGV( 0, var, String )
    RETURNS( String )
    const char* s = getenv( var );
    ret = s ? s : "";
USER_END

//------------------------------------------------------
//
//  Performs a system call
//
//------------------------------------------------------

USER_FUNC( System )
    DEF_ARGV( 0, command, String )
    RETURNS( Long )
    ret = system( command );
USER_END

//------------------------------------------------------
void UserLib()
{
    RegFunc( "ARRAY", NewArray );
    RegFunc( "LEN", Len );
    RegFunc( "SUBSTR", Substr, 3 );
    RegFunc( "STRUCTURE", Structure );
    RegFunc( "LEFT", Left );
    RegFunc( "ADEL", Adel, 2 );
    RegProc( "AADD", Aadd, 2 );
    RegFunc( "DEFINED", Defined );
    RegFunc( "EMPTY", Empty );
    RegFunc( "STR", Str );
    RegProc( "READ", Read, 2 );
    RegFunc( "ARGV", Argv );
    RegProc( "QUIT", Quit );
    RegFunc( "GETSTR", Getstr );
    RegFunc( "ARGC", Argc, 0 );
    RegFunc( "VAL", Val );
    RegFunc( "DATE", Date );
    RegFunc( "TYPE", Type );
    RegFunc( "GETENV", Getenv );
    RegFunc( "SYSTEM", System );
}

