; File......: NTXHANDL.ASM
; Author....: Ted Means
; Date......: $Date:   15 Oct 1992 23:59:12  $
; Revision..: $Revision:   1.0  $
; Log file..: $Logfile:   C:/nanfor/src/ntxhandl.asv  $
; 
; This is an original work by Ted Means and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log:   C:/nanfor/src/ntxhandl.asv  $
;  
;     Rev 1.0   15 Oct 1992 23:59:12   GLENN
;  Initial revision.
;  

; $DOC$
; $FUNCNAME$
;     FT_NTXHand()
; $CATEGORY$
;     Database
; $ONELINER$
;     Obtain the handle associated with an open .NTX file.
; $SYNTAX$
;     FT_NTXHand( <nOrderNum> ) -> nHandle
; $ARGUMENTS$
;     <nOrderNum> is a numeric value indicating the active index for which
;     the handle is to be obtained.
; $RETURNS$
;    The file handle, or zero if no .NTX is open in the specified
;    work area or if <nOrderNum> does not represent an open index.
; $DESCRIPTION$
;    For your own twisted reasons you may need make direct use of the
;    file handle associated with an index.  This function gives you
;    that capability, but use it with care and don't blame me if you
;    botch something up.
;
;    By default this function works on the current work area, but can be
;    made to work on any work area through the use of the standard Clipper
;    alias operator.
;
;    Be aware that this function makes use of Clipper's internal work
;    area information which is subject to change in future versions of
;    Clipper.  If this makes you uncomfortable then don't use this function,
;    you gutless weasel.
;
;    This function is written to adhere to Turbo Assembler's IDEAL mode.
;    To use another assembler, rearrange the SEGMENT and PROC directives
;    and make any other necessary changes to the source code.
;
; $EXAMPLES$
;      // Get the handle for the second index
;
;      QOut( FT_NTXHand( 2 ) )
;
;      // Try a non-current work area
;
;      nHandle := THISFILE->( FT_NTXHand( 1 ) )
;
;      // This will return zero because only 15 indexes can be active
;
;      nHandle := THATFILE->( FT_NTXHand( 22 ) )
; $END$

IDEAL

Public   FT_NTXHand

Extrn    __WorkAreas:DWord                   ; INTERNAL!!!
Extrn    __RetNI:Far
Extrn    __ParNI:Far

Segment  _NanFor   Word      Public    "CODE"
         Assume    CS:_NanFor

Proc     FT_NTXHand          Far

         Mov       AX,1                      ; Specify param #1
         Push      AX                        ; Put on stack
         Call      __ParNI                   ; Retrieve parameter
         Add       SP,2                      ; Realign stack
         Or        AX,AX                     ; Make sure parameter is
         JZ        @@Done                    ; within acceptable range
         Cmp       AX,15
         JBE       @@Okay
         Xor       AX,AX                     ; If not, return zero
         Jmp       Short @@Done

@@Okay:  LES       BX,[__WorkAreas]          ; Load pointer to work areas
         Mov       DX,AX                     ; Move index specifier into DX
         Mov       AX,[Word Ptr ES:BX]       ; Check to see if work area
         Or        AX,[Word Ptr ES:BX + 2]   ; is in use
         JZ        @@Done                    ; If not, return zero
         LES       BX,[DWord Ptr ES:BX]      ; Load work area pointer
         Dec       DX                        ; Compute offset to locate
         SHL       DX,1                      ; pointer to index info
         SHL       DX,1
         Add       BX,DX
         Mov       AX,[Word Ptr ES:BX + 98h] ; See if specified index is open
         Or        AX,[Word Ptr ES:BX + 9Ah]
         JZ        @@Done                    ; If not, return zero
         LES       BX,[ES:BX + 98h]          ; Load index info pointer
         Mov       AX,[Word Ptr ES:BX]       ; Get handle

@@Done:  Push      AX                        ; Put return value on stack
         Call      __RetNI                   ; Return it
         Add       SP,2                      ; Realign stack
         Ret
Endp     FT_NTXHand
Ends     _NanFor
End

