/*
**  STRCHCAT.C - Append a character to a string.
**
**  Arguments: 1 - Pointer to string to append to
**             2 - Character to append
**             3 - Maximum size of string buffer
**
**  Returns: Pointer to modified string, or NULL if insufficent space
**
**  Original Copyright 1990-95 by Robert B. Stout as part of
**  the MicroFirm Function Library (MFL)
**
**  This version is hereby donated to the public domain.
*/

#include <stdlib.h>
#include <string.h>
#include "snip_str.h"

char *_strchcat(char *string, int ch, size_t buflen)
{
      size_t len;

      if (NULL == string || ((len = strlen(string)) + 1) >= buflen)
            return NULL;

      string[len++] = ch;
      string[len]   = '\0';
      return string;
}

#ifdef TEST

#include <stdio.h>

main()
{
      char buf1[80] = "This buffer's big enough", buf2[] = "This one's not";
      char *ptr;

      printf("_strchcat(\"%s\", '!') ", buf1);
      ptr = _strchcat(buf1, '!', sizeof(buf1));
      printf("returned %p...", ptr);
      if (NULL != ptr)
            printf("\n...which is \"%s\"", buf1);
      puts("\n");

      printf("_strchcat(\"%s\", '!') ", buf2);
      ptr = _strchcat(buf2, '!', sizeof(buf2));
      printf("returned %p...", ptr);
      if (NULL != ptr)
            printf("\n...which is \"%s\"", buf2);
      puts("\n");
      return EXIT_SUCCESS;
}

#endif /* TEST */ 
