/* by: Dan Kozak */

/*
**  For use with your code, strip out the demo main() and make this into
**  a header file.
*/

#ifndef KB_DATA__H
#define KB_DATA__H

#include "extkword.h"
#include "mk_fp.h"

typedef struct                     /* Keyboard status structure */
{
  unsigned int
  right_shift_down  : 1,           /* Right Shift key depressed */
  left_shift_down   : 1,            /* Left Shift key depressed */
  ctrl_down         : 1,                  /* Ctrl key depressed */
  alt_down          : 1,                   /* Alt key depressed */
  scroll_on         : 1,                   /* Scroll Lock is on */
  num_on            : 1,                      /* Num Lock is on */
  caps_on           : 1,                     /* Caps Lock is on */
  ins_on            : 1,              /* Insert state is active */
  filler            : 3,           /* Filler for word alignment */
  ctrl_numloc       : 1,                   /* Suspend key is on */
  scroll_down       : 1,           /* Scroll Lock key depressed */
  num_down          : 1,              /* Num Lock key depressed */
  caps_down         : 1,             /* Caps Lock key depressed */
  ins_down          : 1;                /* Insert key depressed */
} biosshiftstate;

biosshiftstate FAR * volatile kbd_status =
      (biosshiftstate FAR * volatile)(MK_FP(0x0000, 0x0417L));

#ifdef TEST

#include <stdio.h>
#include <time.h>

main()
{
      clock_t start = clock();

      puts("Press some key stuff and I'll tell you what in 3 seconds...\n");

      while (((clock() - start) / CLOCKS_PER_SEC) < 3)
            ;

      printf("right_shift_down = %d\n",kbd_status->right_shift_down);
      printf("left_shift_down = %d\n",kbd_status->left_shift_down);
      printf("ctrl_down = %d\n",kbd_status->ctrl_down);
      printf("alt_down = %d\n",kbd_status->alt_down);
      printf("scroll_on = %d\n",kbd_status->scroll_on);
      printf("num_on = %d\n",kbd_status->num_on);
      printf("caps_on = %d\n",kbd_status->caps_on);
      printf("ins_on = %d\n",kbd_status->ins_on);
      printf("filler = %d\n",kbd_status->filler);
      printf("ctrl_numloc = %d\n",kbd_status->ctrl_numloc);
      printf("scroll_down = %d\n",kbd_status->scroll_down);
      printf("num_down = %d\n",kbd_status->num_down);
      printf("caps_down = %d\n",kbd_status->caps_down);
      printf("ins_down = %d\n",kbd_status->ins_down);

      return 0;
}

#endif /* TEST */

#endif /* KB_DATA__H */
